/**
 * Copyright (c) 2008 Parity Communications, Inc. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Sergey Lyakhov - initial API and implementation
 *    Markus Sabadello - moved to idas.common
 */
package org.eclipse.higgins.idas.common;

import java.security.PrivateKey;

import org.eclipse.higgins.idas.api.IAuthNMaterials;
import org.eclipse.higgins.idas.api.IdASException;

/**
 * Authentication materials consisting of a name and a private key.
 */
public class AuthNNamePrivateKeyMaterials implements IAuthNMaterials {

	private static final long serialVersionUID = -723279024202161473L;

	private String name = null;
	private PrivateKey privateKey = null;

	public AuthNNamePrivateKeyMaterials(String name, PrivateKey privateKey) throws IdASException {

		this.name = name;
		this.privateKey = privateKey;
	}

	public String getName() {
		return this.name;
	}

	public PrivateKey getPrivateKey() {
		return this.privateKey;
	}

	public String toString() {

		return "Name: " + this.getName();
	}

	public int hashCode() {

		int hashCode = 1;
		if (this.getName() != null) hashCode += this.getName().hashCode() * 31;
		if (this.getPrivateKey() != null) hashCode += this.getPrivateKey().getEncoded().hashCode() * 31;

		return hashCode;
	}

	public boolean equals(Object object) {

		if (object == this) return true;
		if (! (object instanceof AuthNNamePasswordMaterials)) return false;

		AuthNNamePrivateKeyMaterials other = (AuthNNamePrivateKeyMaterials) object;

		if (this.getName() == null && other.getName() != null) return false;
		if (this.getName() != null && other.getName() == null) return false;

		if (this.getPrivateKey() == null && other.getPrivateKey() != null) return false;
		if (this.getPrivateKey() != null && other.getPrivateKey() == null) return false;

		return this.getName().equals(other.getName()) && this.getPrivateKey().getEncoded().equals(other.getPrivateKey().getEncoded());
	}
}
