package org.eclipse.higgins.idas.common;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Date;

import org.eclipse.higgins.idas.api.IAuthNMaterials;
import org.eclipse.higgins.util.saml.SAML2Assertion;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;


public class AuthNSAML2AssertionMaterials extends SAML2Assertion implements IAuthNMaterials {
	
	private static final long serialVersionUID = -1446556135686272949L;

	private String stringAssertion;

	public AuthNSAML2AssertionMaterials(String string) throws SAXException, IOException {
		super(new StringReader(string));
		stringAssertion = string;
	}
	
	public AuthNSAML2AssertionMaterials(Document document) {

		super(document);

		this.setVersion("2.0");
		this.setIssueInstant(new Date());
	}

	public AuthNSAML2AssertionMaterials() {

		this((Document) null);
	}

	public AuthNSAML2AssertionMaterials(InputStream stream) throws SAXException, IOException {

		super(stream);
	}

	public AuthNSAML2AssertionMaterials(Reader reader) throws SAXException, IOException {

		super(reader);
	}

	public AuthNSAML2AssertionMaterials(Document document, Element element) {

		super(document, element);
	}
	
	public String getStringAssertion() {
		return stringAssertion;
	}
	
}
