/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.idas.cp.google.test;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Iterator;
import junit.framework.TestCase;
import org.eclipse.higgins.idas.api.IAttribute;
import org.eclipse.higgins.idas.api.IAttributeValue;
import org.eclipse.higgins.idas.api.IAuthNMaterials;
import org.eclipse.higgins.idas.api.IComplexAttrValue;
import org.eclipse.higgins.idas.api.IContext;
import org.eclipse.higgins.idas.api.IContextId;
import org.eclipse.higgins.idas.api.IEntity;
import org.eclipse.higgins.idas.api.IFilter;
import org.eclipse.higgins.idas.api.IFilterAssertion;
import org.eclipse.higgins.idas.api.IFilterAttributeAssertion;
import org.eclipse.higgins.idas.api.ISimpleAttrValue;
import org.eclipse.higgins.idas.api.ITypedValue;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.common.AuthNNamePasswordMaterials;
import org.eclipse.higgins.idas.registry.IdASRegistry;
import org.eclipse.higgins.idas.registry.contextid.ContextIdFactory;
import org.eclipse.higgins.idas.registry.discovery.FileDiscovery;
import org.eclipse.higgins.idas.registry.discovery.IDiscovery;
import org.eclipse.higgins.idas.spi.BasicValueInt;

public class GDataCPTest
extends TestCase {
    public static void main(String[] args) throws Exception {
        String proxyHost = "<proxyHost>";
        System.setProperty("http.proxySet", "true");
        System.setProperty("http.proxyHost", proxyHost);
        System.setProperty("http.proxyPort", "80");
        System.setProperty("https.proxySet", "true");
        System.setProperty("https.proxyHost", proxyHost);
        System.setProperty("https.proxyPort", "80");
        IdASRegistry registry = IdASRegistry.getInstance();
        IContextId contextId = ContextIdFactory.fromString((String)"GDataContext.xrds");
        registry.setDiscovery((IDiscovery)new FileDiscovery(new File("GDataContext.xrds")));
        System.out.println("List: " + Arrays.toString(contextId.getTypes()));
        IContext context = registry.createContext("GDataContext.xrds");
        context.open((IAuthNMaterials)new AuthNNamePasswordMaterials(context, "<GMail ID>", "<password>"));
        IEntity entity = GDataCPTest.createContact(context, "Test Entity1");
        GDataCPTest.updateContact(context, entity);
        GDataCPTest.listContacts(context);
        GDataCPTest.queryContacts(context);
        GDataCPTest.deleteContact(context, entity);
    }

    private static IEntity createContact(IContext context, String entityID) throws IdASException, URISyntaxException {
        IEntity entity = context.addEntity(new URI("contact"), entityID);
        IAttribute attr = entity.addAttribute(new URI("title"));
        attr.addSimpleValue(ISimpleAttrValue.STRING_TYPE_URI, (Object)"Mohamad Taufeeq");
        attr = entity.addAttribute(new URI("email"));
        IComplexAttrValue attrValue = attr.addComplexValue(ITypedValue.ANYURI_TYPE_URI);
        IAttribute compAttr = attrValue.addAttribute(new URI("address"));
        compAttr.addSimpleValue(ISimpleAttrValue.STRING_TYPE_URI, (Object)"mohamad.taufeeq@oracle.com");
        compAttr = attrValue.addAttribute(new URI("rel"));
        compAttr.addSimpleValue(ISimpleAttrValue.STRING_TYPE_URI, (Object)"http://schemas.google.com/g/2005#work");
        context.applyUpdates();
        System.out.println("Contact added successfully: " + entity);
        return entity;
    }

    private static void listContacts(IContext context) throws IdASException, URISyntaxException {
        System.out.println("Enter List contacts");
        Iterator entityIter = context.getEntities(null);
        while (entityIter.hasNext()) {
            IEntity entity = (IEntity)entityIter.next();
            System.out.println("\nSearch Result: " + entity);
        }
    }

    private static void deleteContact(IContext context, IEntity entity) throws IdASException {
        entity.remove();
        context.applyUpdates();
        System.out.println("Contact deleted successfully: " + entity.getEntityID());
    }

    private static void queryContacts(IContext context) throws IdASException, URISyntaxException {
        System.out.println("Enter Query contacts");
        IFilter filter = context.buildFilter();
        filter.setOperator("urn:eclipse.higgins.idas.OP_AND");
        IFilter nFilter = context.buildFilter();
        IFilterAttributeAssertion attrAssertion = context.buildAttributeAssertion();
        attrAssertion.setID(new URI("maxResults"));
        attrAssertion.setComparator("urn:org.eclipse.higgins.idas.api.comparator.attribute.equality");
        BasicValueInt assertionValue = new BasicValueInt(10, null);
        attrAssertion.setAssertionValue((IAttributeValue)assertionValue);
        nFilter.setAssertion((IFilterAssertion)attrAssertion);
        filter.addFilter(nFilter);
        nFilter = context.buildFilter();
        attrAssertion = context.buildAttributeAssertion();
        attrAssertion.setID(new URI("startIndex"));
        attrAssertion.setComparator("urn:org.eclipse.higgins.idas.api.comparator.attribute.equality");
        assertionValue = new BasicValueInt(1, null);
        attrAssertion.setAssertionValue((IAttributeValue)assertionValue);
        nFilter.setAssertion((IFilterAssertion)attrAssertion);
        filter.addFilter(nFilter);
        Iterator entityIter = context.getEntities(filter);
        while (entityIter.hasNext()) {
            System.out.println("\nSearch Result: " + entityIter.next());
        }
    }

    private static void updateContact(IContext context, IEntity entity) throws IdASException, URISyntaxException {
        System.out.println("Enter update contacts");
        IAttribute orgAttr = entity.addAttribute(new URI("organization"));
        IComplexAttrValue attrValue = orgAttr.addComplexValue(ITypedValue.ANYURI_TYPE_URI);
        IAttribute compAttr = attrValue.addAttribute(new URI("orgName"));
        compAttr.addSimpleValue(ISimpleAttrValue.STRING_TYPE_URI, (Object)"Oracle Corporation");
        compAttr = attrValue.addAttribute(new URI("orgTitle"));
        compAttr.addSimpleValue(ISimpleAttrValue.STRING_TYPE_URI, (Object)"Senior Staff Engineer");
        compAttr = attrValue.addAttribute(new URI("rel"));
        compAttr.addSimpleValue(ISimpleAttrValue.STRING_TYPE_URI, (Object)"http://schemas.google.com/g/2005#work");
        compAttr = attrValue.addAttribute(new URI("primary"));
        compAttr.addSimpleValue(ISimpleAttrValue.BOOLEAN_TYPE_URI, (Object)"true");
        context.applyUpdates();
        entity.removeAttribute(new URI("organization"));
        context.applyUpdates();
    }
}

