/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.idas.cp.google;

import com.google.gdata.client.Query;
import com.google.gdata.client.contacts.ContactsService;
import com.google.gdata.data.BaseEntry;
import com.google.gdata.data.DateTime;
import com.google.gdata.data.PlainTextConstruct;
import com.google.gdata.data.TextConstruct;
import com.google.gdata.data.contacts.ContactEntry;
import com.google.gdata.data.contacts.ContactFeed;
import com.google.gdata.data.extensions.Email;
import com.google.gdata.data.extensions.OrgName;
import com.google.gdata.data.extensions.OrgTitle;
import com.google.gdata.data.extensions.Organization;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.idas.api.ContextNotOpenException;
import org.eclipse.higgins.idas.api.ContextOpenException;
import org.eclipse.higgins.idas.api.IAttribute;
import org.eclipse.higgins.idas.api.IAuthNMaterials;
import org.eclipse.higgins.idas.api.IContext;
import org.eclipse.higgins.idas.api.IContextId;
import org.eclipse.higgins.idas.api.IEntity;
import org.eclipse.higgins.idas.api.IFilter;
import org.eclipse.higgins.idas.api.ISimpleValue;
import org.eclipse.higgins.idas.api.IValue;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.api.NoSuchEntityException;
import org.eclipse.higgins.idas.api.NotImplementedException;
import org.eclipse.higgins.idas.common.AuthNNamePasswordMaterials;
import org.eclipse.higgins.idas.cp.google.GDataEntity;
import org.eclipse.higgins.idas.spi.AttributeNotification;
import org.eclipse.higgins.idas.spi.BasicContext;
import org.eclipse.higgins.idas.spi.BasicFilter;
import org.eclipse.higgins.idas.spi.BasicFilterAssertion;
import org.eclipse.higgins.idas.spi.BasicFilterAttributeAssertion;
import org.eclipse.higgins.idas.spi.EntityNotification;
import org.eclipse.higgins.idas.spi.ValueNotification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GDataContext
extends BasicContext {
    private static final Log log = LogFactory.getLog((String)GDataContext.class.getName());
    public static URI PROP_CONTENT = URI.create("content");
    public static URI PROP_TITLE = URI.create("title");
    public static URI PROP_EMAIL = URI.create("email");
    public static URI PROP_IM = URI.create("im");
    public static URI PROP_PHONE = URI.create("phoneNumber");
    public static URI PROP_POSTAL_ADDRESS = URI.create("postalAddress");
    public static URI PROP_ORGANIZATION = URI.create("organization");
    public static URI PROP_ORG_NAME = URI.create("orgName");
    public static URI PROP_ORG_TITLE = URI.create("orgTitle");
    public static URI PROP_TEXT = URI.create("text");
    public static URI PROP_ADDRESS = URI.create("address");
    public static URI PROP_REL = URI.create("rel");
    public static URI PROP_LABEL = URI.create("label");
    public static URI PROP_PRIMARY = URI.create("primary");
    public static URI PARAM_MAX_RESULTS = URI.create("maxResults");
    public static URI PARAM_START_INDEX = URI.create("startIndex");
    public static URI PARAM_UPDATED_MIN = URI.create("updatedMin");
    private final IContextId m_contextId;
    private final ContactsService m_service;
    private URL m_feedURL;
    private final String m_projection;
    private final Map<?, ?> m_connectionSettings;

    public GDataContext(IContextId contextId) throws IdASException {
        this.m_contextId = contextId;
        this.m_service = new ContactsService("Higgins Google Contacts CP");
        Map contextSettings = contextId.getConfiguration();
        this.m_connectionSettings = (Map)contextSettings.get("Connection");
        if (this.m_connectionSettings == null) {
            throw new IdASException("No connection specified for Google Contacts");
        }
        this.m_projection = (String)this.m_connectionSettings.get("Projection");
    }

    public String open(IAuthNMaterials identity) throws IdASException {
        if (this.isOpen(null)) {
            throw new ContextOpenException();
        }
        if (identity instanceof AuthNNamePasswordMaterials) {
            String userName = ((AuthNNamePasswordMaterials)identity).getUsername();
            String password = ((AuthNNamePasswordMaterials)identity).getPassword();
            try {
                this.m_feedURL = new URL(this.m_connectionSettings.get("FeedURL") + "contacts/" + userName + "/" + this.m_projection);
                this.m_service.setUserCredentials(userName, password);
                this.setOpen(true);
            }
            catch (Exception e) {
                throw new IdASException((Throwable)e);
            }
            return userName;
        }
        throw new IdASException("Unsupported authentication material");
    }

    public IEntity addEntity(URI entityType, String entityID) throws IdASException {
        if (!this.isOpen(null)) {
            throw new ContextNotOpenException();
        }
        GDataEntity entity = new GDataEntity((IContext)this, entityType, entityID);
        this.updateNotification(new EntityNotification((IEntity)entity, "urn:eclipse.higgins.idas.spi.EntityNotification.UPDATE_ADD", null));
        return entity;
    }

    public Iterator<IEntity> getEntities(IFilter filter, Iterator attrSelectionList) throws IdASException {
        if (!this.isOpen(null)) {
            throw new ContextNotOpenException();
        }
        ContactFeed resultFeed = null;
        LinkedList<GDataEntity> contactList = new LinkedList<GDataEntity>();
        try {
            if (filter != null) {
                Query query = new Query(this.m_feedURL);
                GDataContext.buildQuery((BasicFilter)filter, query);
                resultFeed = (ContactFeed)this.m_service.query(query, ContactFeed.class);
            } else {
                resultFeed = (ContactFeed)this.m_service.getFeed(this.m_feedURL, ContactFeed.class);
            }
        }
        catch (Exception ex) {
            throw new IdASException((Throwable)ex);
        }
        for (ContactEntry contact : resultFeed.getEntries()) {
            contactList.add(new GDataEntity((IContext)this, null, contact.getId(), contact));
        }
        return contactList.iterator();
    }

    public IEntity getEntity(String entityID) throws IdASException {
        Iterator entities = this.getEntities(null);
        while (entities.hasNext()) {
            IEntity entity = (IEntity)entities.next();
            if (!entity.getEntityID().equals(entityID)) continue;
            return entity;
        }
        throw new NoSuchEntityException();
    }

    private static void buildQuery(BasicFilter basicFilter, Query query) throws IdASException {
        BasicFilterAssertion assertion = (BasicFilterAssertion)basicFilter.getAssertion();
        if (assertion == null) {
            String operator = basicFilter.getOperator();
            if (!operator.equals("urn:eclipse.higgins.idas.OP_AND")) {
                throw new NotImplementedException("Unsupported operator:" + operator);
            }
            Iterator filters = basicFilter.getFilters();
            while (filters.hasNext()) {
                IFilter filter = (IFilter)filters.next();
                GDataContext.buildQuery((BasicFilter)filter, query);
            }
        } else {
            URI attrURI = assertion.getID();
            String comparator = assertion.getComparator();
            if (!comparator.equals("urn:org.eclipse.higgins.idas.api.comparator.attribute.equality")) {
                throw new NotImplementedException("Unsupported comparator:" + comparator);
            }
            if (assertion instanceof BasicFilterAttributeAssertion) {
                BasicFilterAttributeAssertion attributeAssertion = (BasicFilterAttributeAssertion)assertion;
                IValue assertionValue = attributeAssertion.getAssertionValue();
                if (!assertionValue.isSimple()) {
                    throw new NotImplementedException("Complex value not supported");
                }
                String value = ((ISimpleValue)assertionValue).getCanonical();
                if (attrURI.equals(PARAM_MAX_RESULTS)) {
                    query.setMaxResults(Integer.parseInt(value));
                } else if (attrURI.equals(PARAM_START_INDEX)) {
                    query.setStartIndex(Integer.parseInt(value));
                } else if (attrURI.equals(PARAM_UPDATED_MIN)) {
                    query.setUpdatedMin(DateTime.parseDateTime((String)value));
                } else {
                    query.setStringCustomParameter(attrURI.toString(), value);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyUpdates() throws IdASException {
        if (!this.isOpen(null)) {
            throw new ContextNotOpenException();
        }
        Hashtable updateList = super.getUpdateList();
        try {
            for (Map.Entry entrySet : updateList.entrySet()) {
                log.debug((Object)("Updating entry [" + (String)entrySet.getKey() + "]"));
                ContactEntry contact = null;
                for (EntityNotification notification : (List)entrySet.getValue()) {
                    String action = notification.getAction();
                    if (action.equals("urn:eclipse.higgins.idas.spi.EntityNotification.UPDATE_ADD")) {
                        GDataEntity entity = (GDataEntity)notification.getEntity();
                        entity.setContactEntry(this.addContact((IEntity)entity));
                        break;
                    }
                    if (action.equals("urn:eclipse.higgins.idas.spi.EntityNotification.UPDATE_REMOVE")) {
                        this.removeContact(notification.getEntity());
                        continue;
                    }
                    if (action.equals("urn:eclipse.higgins.idas.spi.EntityNotification.UPDATE_ATTR_NOTIFY")) {
                        if (contact == null) {
                            contact = this.getContact(notification.getEntity());
                        }
                        this.updateContactWithNotification(notification, contact);
                        continue;
                    }
                    throw new IdASException("Invalid Entity Notification Action: " + action);
                }
                if (contact == null) continue;
                GDataEntity entity = (GDataEntity)((EntityNotification)((List)entrySet.getValue()).get(0)).getEntity();
                entity.setContactEntry(this.updateContact(contact));
                contact = null;
            }
        }
        finally {
            updateList.clear();
        }
    }

    public URI getContextID() throws IdASException {
        try {
            return new URI(this.m_contextId.toString());
        }
        catch (URISyntaxException e) {
            throw new IdASException((Throwable)e);
        }
    }

    public void close() throws IdASException {
        if (!this.isOpen(null)) {
            throw new ContextNotOpenException();
        }
        this.setOpen(false);
    }

    private ContactEntry addContact(IEntity entity) throws IdASException {
        try {
            ContactEntry contact = new ContactEntry();
            Iterator attrIter = entity.getAttributes();
            while (attrIter.hasNext()) {
                GDataContext.updateContact(contact, (IAttribute)attrIter.next(), false);
            }
            return (ContactEntry)this.m_service.insert(this.m_feedURL, (BaseEntry)contact);
        }
        catch (Exception ex) {
            throw new IdASException("Could not add contact", (Throwable)ex);
        }
    }

    private ContactEntry updateContact(ContactEntry contact) throws IdASException {
        try {
            URL entityURL = new URL(contact.getEditLink().getHref());
            contact = (ContactEntry)this.m_service.update(entityURL, (BaseEntry)contact);
        }
        catch (Exception ex) {
            new IdASException("Could not update entity", (Throwable)ex);
        }
        return contact;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void updateContactWithNotification(EntityNotification entityNotif, ContactEntry contact) throws IdASException {
        AttributeNotification attrNotif = entityNotif.getAttributeNotification();
        String attrAction = attrNotif.getAction();
        if (attrAction.equals("urn:eclipse.higgins.idas.spi.AttributeNotification.UPDATE_VALUE_NOTIFY")) {
            ValueNotification attrValueNotif = attrNotif.getAttributeValueNotification();
            String valueAction = attrValueNotif.getAction();
            if (valueAction.equals("urn:eclipse.higgins.idas.spi.AttributeValueNotification.UPDATE_ADD")) {
                GDataContext.updateContact(contact, attrNotif.getAttr(), true);
                return;
            }
            if (!valueAction.equals("urn:eclipse.higgins.idas.spi.AttributeValueNotification.UPDATE_REMOVE")) return;
            return;
        }
        if (!attrAction.equals("urn:eclipse.higgins.idas.spi.AttributeNotification.UPDATE_REMOVE")) {
            if (attrAction.equals("urn:eclipse.higgins.idas.spi.AttributeNotification.UPDATE_ADD")) return;
            throw new NotImplementedException(attrNotif.getAction());
        }
        URI attrID = attrNotif.getAttr().getType();
        if (attrID.equals(PROP_TITLE)) {
            contact.setTitle(null);
            return;
        }
        if (attrID.equals(PROP_CONTENT)) {
            contact.setContent((TextConstruct)null);
            return;
        }
        if (attrID.equals(PROP_EMAIL)) {
            contact.getEmailAddresses().clear();
            return;
        }
        if (attrID.equals(PROP_IM)) {
            contact.getImAddresses().clear();
            return;
        }
        if (attrID.equals(PROP_PHONE)) {
            contact.getPhoneNumbers().clear();
            return;
        }
        if (attrID.equals(PROP_POSTAL_ADDRESS)) {
            contact.getPostalAddresses().clear();
            return;
        }
        if (!attrID.equals(PROP_ORGANIZATION)) return;
        contact.getOrganizations().clear();
    }

    private void removeContact(IEntity entity) throws IdASException {
        try {
            ContactEntry contactEntry = this.getContact(entity);
            URL entityURL = new URL(contactEntry.getEditLink().getHref());
            this.m_service.delete(entityURL);
        }
        catch (Exception ex) {
            new IdASException("Could not delete entity", (Throwable)ex);
        }
    }

    private ContactEntry getContact(IEntity entity) throws IdASException {
        ContactEntry contactEntry = null;
        try {
            String entityID = entity.getEntityID();
            URL entityURL = new URL(entityID.replace("/base/", "/" + this.m_projection + "/"));
            contactEntry = (ContactEntry)this.m_service.getEntry(entityURL, ContactEntry.class);
            if (contactEntry == null) {
                throw new IdASException("No contact found with ID: " + entityID);
            }
        }
        catch (Exception ex) {
            new IdASException("Could not delete entity", (Throwable)ex);
        }
        return contactEntry;
    }

    private static void updateContact(ContactEntry contact, IAttribute attr, boolean replace) throws IdASException {
        block6: {
            URI attrID;
            block8: {
                block7: {
                    block5: {
                        attrID = attr.getType();
                        if (!attrID.equals(PROP_TITLE)) break block5;
                        ISimpleValue title = (ISimpleValue)attr.getValues().next();
                        contact.setTitle((TextConstruct)new PlainTextConstruct(title.getCanonical()));
                        break block6;
                    }
                    if (!attrID.equals(PROP_CONTENT)) break block7;
                    ISimpleValue content = (ISimpleValue)attr.getValues().next();
                    contact.setContent((TextConstruct)new PlainTextConstruct(content.getCanonical()));
                    break block6;
                }
                if (!attrID.equals(PROP_EMAIL)) break block8;
                if (replace) {
                    contact.getEmailAddresses().clear();
                }
                Iterator emailIter = attr.getValues();
                while (emailIter.hasNext()) {
                    IEntity attrValue = (IEntity)emailIter.next();
                    IAttribute emailAttr = attrValue.getAttribute(PROP_ADDRESS);
                    Iterator iter = emailAttr.getValues();
                    Email email = new Email();
                    email.setAddress(((ISimpleValue)iter.next()).getCanonical());
                    contact.addEmailAddress(email);
                    emailAttr = attrValue.getAttribute(PROP_REL);
                    if (emailAttr == null) continue;
                    iter = emailAttr.getValues();
                    email.setRel(((ISimpleValue)iter.next()).getCanonical());
                }
                break block6;
            }
            if (!attrID.equals(PROP_ORGANIZATION)) break block6;
            if (replace) {
                contact.getOrganizations().clear();
            }
            Iterator orgIter = attr.getValues();
            while (orgIter.hasNext()) {
                IEntity attrValue = (IEntity)orgIter.next();
                IAttribute orgAttr = attrValue.getAttribute(PROP_ORG_NAME);
                Iterator iter = orgAttr.getValues();
                Organization organization = new Organization();
                organization.setOrgName(new OrgName(((ISimpleValue)iter.next()).getCanonical()));
                contact.addOrganization(organization);
                orgAttr = attrValue.getAttribute(PROP_ORG_TITLE);
                if (orgAttr != null) {
                    iter = orgAttr.getValues();
                    organization.setOrgTitle(new OrgTitle(((ISimpleValue)iter.next()).getCanonical()));
                }
                if ((orgAttr = attrValue.getAttribute(PROP_REL)) == null) continue;
                iter = orgAttr.getValues();
                organization.setRel(((ISimpleValue)iter.next()).getCanonical());
            }
        }
    }
}

