/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.idas.cp.google;

import com.google.gdata.data.contacts.ContactEntry;
import com.google.gdata.data.extensions.Email;
import com.google.gdata.data.extensions.Im;
import com.google.gdata.data.extensions.Organization;
import com.google.gdata.data.extensions.PhoneNumber;
import com.google.gdata.data.extensions.PostalAddress;
import java.net.URI;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.idas.api.IAttribute;
import org.eclipse.higgins.idas.api.IContext;
import org.eclipse.higgins.idas.api.IEntity;
import org.eclipse.higgins.idas.api.ISimpleValue;
import org.eclipse.higgins.idas.api.ITypedValue;
import org.eclipse.higgins.idas.api.IValue;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.cp.google.GDataContext;
import org.eclipse.higgins.idas.spi.BasicAttribute;
import org.eclipse.higgins.idas.spi.BasicAttributeSet;
import org.eclipse.higgins.idas.spi.BasicContext;
import org.eclipse.higgins.idas.spi.BasicEntity;
import org.eclipse.higgins.idas.spi.IEntityContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GDataEntity
extends BasicEntity {
    private static final Log log = LogFactory.getLog((String)GDataEntity.class.getName());
    private ContactEntry m_contact;
    private boolean m_loadAttrs;

    public GDataEntity(IContext context, URI uriType, String entityID) throws IdASException {
        this(context, uriType, entityID, null);
    }

    public GDataEntity(IContext context, URI uriType, String entityID, ContactEntry contact) throws IdASException {
        super(context, uriType, entityID);
        this.setContainer((IEntityContainer)((BasicContext)context));
        this.setContactEntry(contact);
    }

    public IAttribute addAttribute(URI type) throws IdASException {
        BasicAttributeSet attrSet = this.getBasicAttributeSet();
        IAttribute attr = attrSet.getAttribute(type);
        if (attr != null) {
            return attr;
        }
        return super.addAttribute(type);
    }

    public IAttribute getAttribute(URI attrID) throws IdASException {
        return null;
    }

    public Iterator<IAttribute> getAttributes() throws IdASException {
        BasicAttributeSet attributeSet = this.getBasicAttributeSet();
        if (this.m_contact != null && !this.m_loadAttrs) {
            GDataEntity.loadAttributes(this.m_contact, attributeSet);
            this.m_loadAttrs = true;
        }
        return attributeSet.getAttributes();
    }

    protected void setContactEntry(ContactEntry contact) {
        this.m_contact = contact;
        if (contact != null) {
            this.setEntityID(contact.getEditLink().getHref());
        }
    }

    private static void loadAttributes(ContactEntry contact, BasicAttributeSet attributeSet) throws IdASException {
        List postalAddresses;
        List imAddresses;
        List organizations;
        List phoneNumbers;
        List emailAddresses;
        BasicAttribute attr = null;
        if (contact.getTitle() != null) {
            attr = attributeSet.addUnnotifiedAttribute(GDataContext.PROP_TITLE);
            String contactName = contact.getTitle().getPlainText();
            attr.addSimpleValue(ITypedValue.STRING_TYPE_URI, (Object)contactName);
        }
        if (contact.getContent() != null) {
            attr = attributeSet.addUnnotifiedAttribute(GDataContext.PROP_CONTENT);
            String contactNotes = contact.getTextContent().getContent().getPlainText();
            attr.addSimpleValue(ITypedValue.STRING_TYPE_URI, (Object)contactNotes);
        }
        if ((emailAddresses = contact.getEmailAddresses()).size() > 0) {
            attr = attributeSet.addUnnotifiedAttribute(GDataContext.PROP_EMAIL);
            for (Email emailAddress : emailAddresses) {
                IEntity attrValue = attr.addComplexValue(ITypedValue.ANYURI_TYPE_URI);
                IAttribute compAttr = attrValue.addAttribute(GDataContext.PROP_ADDRESS);
                compAttr.addSimpleValue(ITypedValue.STRING_TYPE_URI, (Object)emailAddress.getAddress());
                compAttr = attrValue.addAttribute(GDataContext.PROP_REL);
                compAttr.addSimpleValue(ITypedValue.STRING_TYPE_URI, (Object)emailAddress.getRel());
                compAttr = attrValue.addAttribute(GDataContext.PROP_PRIMARY);
                compAttr.addSimpleValue(ITypedValue.BOOLEAN_TYPE_URI, (Object)emailAddress.getPrimary());
            }
        }
        if ((phoneNumbers = contact.getPhoneNumbers()).size() > 0) {
            attr = attributeSet.addUnnotifiedAttribute(GDataContext.PROP_PHONE);
            for (PhoneNumber phoneNumber : phoneNumbers) {
                IEntity attrValue = attr.addComplexValue(ITypedValue.ANYURI_TYPE_URI);
                IAttribute compAttr = attrValue.addAttribute(GDataContext.PROP_TEXT);
                compAttr.addSimpleValue(ITypedValue.STRING_TYPE_URI, (Object)phoneNumber.getPhoneNumber());
                compAttr = attrValue.addAttribute(GDataContext.PROP_REL);
                compAttr.addSimpleValue(ITypedValue.STRING_TYPE_URI, (Object)phoneNumber.getRel());
                compAttr = attrValue.addAttribute(GDataContext.PROP_PRIMARY);
                compAttr.addSimpleValue(ITypedValue.BOOLEAN_TYPE_URI, (Object)phoneNumber.getPrimary());
            }
        }
        if ((organizations = contact.getOrganizations()).size() > 0) {
            attr = attributeSet.addUnnotifiedAttribute(GDataContext.PROP_ORGANIZATION);
            for (Organization organization : organizations) {
                IEntity attrValue = attr.addComplexValue(ITypedValue.ANYURI_TYPE_URI);
                IAttribute compAttr = attrValue.addAttribute(GDataContext.PROP_ORG_NAME);
                compAttr.addSimpleValue(ITypedValue.STRING_TYPE_URI, (Object)organization.getOrgName().getValue());
                compAttr = attrValue.addAttribute(GDataContext.PROP_ORG_TITLE);
                compAttr.addSimpleValue(ITypedValue.STRING_TYPE_URI, (Object)organization.getOrgTitle().getValue());
                compAttr = attrValue.addAttribute(GDataContext.PROP_REL);
                compAttr.addSimpleValue(ITypedValue.STRING_TYPE_URI, (Object)organization.getRel());
                compAttr = attrValue.addAttribute(GDataContext.PROP_PRIMARY);
                compAttr.addSimpleValue(ITypedValue.BOOLEAN_TYPE_URI, (Object)organization.getPrimary());
            }
        }
        if ((imAddresses = contact.getImAddresses()).size() > 0) {
            attr = attributeSet.addUnnotifiedAttribute(GDataContext.PROP_IM);
            for (Im imAddress : imAddresses) {
                IEntity attrValue = attr.addComplexValue(ITypedValue.ANYURI_TYPE_URI);
                IAttribute compAttr = attrValue.addAttribute(GDataContext.PROP_ADDRESS);
                compAttr.addSimpleValue(ITypedValue.STRING_TYPE_URI, (Object)imAddress.getAddress());
                compAttr = attrValue.addAttribute(GDataContext.PROP_REL);
                compAttr.addSimpleValue(ITypedValue.STRING_TYPE_URI, (Object)imAddress.getRel());
                compAttr = attrValue.addAttribute(GDataContext.PROP_PRIMARY);
                compAttr.addSimpleValue(ITypedValue.BOOLEAN_TYPE_URI, (Object)imAddress.getPrimary());
            }
        }
        if ((postalAddresses = contact.getPostalAddresses()).size() > 0) {
            attr = attributeSet.addUnnotifiedAttribute(GDataContext.PROP_POSTAL_ADDRESS);
            for (PostalAddress postalAddress : postalAddresses) {
                IEntity attrValue = attr.addComplexValue(ITypedValue.ANYURI_TYPE_URI);
                IAttribute compAttr = attrValue.addAttribute(GDataContext.PROP_TEXT);
                compAttr.addSimpleValue(ITypedValue.STRING_TYPE_URI, (Object)postalAddress.getValue());
                compAttr = attrValue.addAttribute(GDataContext.PROP_REL);
                compAttr.addSimpleValue(ITypedValue.STRING_TYPE_URI, (Object)postalAddress.getRel());
                compAttr = attrValue.addAttribute(GDataContext.PROP_PRIMARY);
                compAttr.addSimpleValue(ITypedValue.BOOLEAN_TYPE_URI, (Object)postalAddress.getPrimary());
            }
        }
    }

    public String toString() {
        StringBuilder buff = new StringBuilder();
        try {
            buff.append("\nEntity ID:").append(this.getEntityID());
            buff.append(GDataEntity.toString(this.getAttributes()));
        }
        catch (IdASException ex) {
            log.error((Object)ex.getMessage(), (Throwable)ex);
        }
        return buff.toString();
    }

    private static String toString(Iterator<IAttribute> attrIterator) throws IdASException {
        StringBuilder buff = new StringBuilder();
        while (attrIterator.hasNext()) {
            IAttribute attribute = attrIterator.next();
            buff.append("\n Attr ID:").append(attribute.getType());
            buff.append("\n    Value:");
            Iterator attrValues = attribute.getValues();
            while (attrValues.hasNext()) {
                IValue attrValue = (IValue)attrValues.next();
                if (!attrValue.isSimple()) {
                    IEntity value = (IEntity)attrValue;
                    buff.append(GDataEntity.toString(value.getAttributes()));
                    continue;
                }
                buff.append(((ISimpleValue)attrValue).getCanonical());
            }
        }
        return buff.toString();
    }
}

