/**
 * Copyright (c) 2006, 2008 Oracle and/or its affiliates. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Mohamad Raja - Initial implementation
 */
package org.eclipse.higgins.idas.cp.google;

import java.net.URI;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.eclipse.higgins.configuration.api.ISettingDescriptor;
import org.eclipse.higgins.idas.api.IContext;
import org.eclipse.higgins.idas.api.IContextFactory;
import org.eclipse.higgins.idas.api.IContextId;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.spi.BasicAttributeSet;

public class GDataContextFactory extends BasicAttributeSet implements IContextFactory
{
	private ISettingDescriptor _contextFactoryDescriptor = null;
	private List _contextTypesList = null;
	private String _contextFactoryClassName = null;

	//@Override
    public IContext createContext(IContextId contextID) throws IdASException
    {
        return new GDataContext(contextID);
    }

    //@Override
    public ISettingDescriptor getContextDescriptor(String contextIdName)
        throws IdASException
    {
        return null;
    }

    //@Override
    public Iterator<URI> getContexts(String filter) throws IdASException
    {
        return null;
    }

    //@Override
    public String getName() throws IdASException
    {
        return null;
    }

    //@Override
    public String getPolicy() throws IdASException
    {
        return null;
    }
	
	public List getTypes() throws IdASException { 
		return this._contextTypesList;
	}

    //@Override
    public void setPolicy(String policy) throws IdASException
    {
    }

    //@Override
    public void configure(Map mapGlobalSettings, String strComponentName,
        Map mapComponentSettings, ISettingDescriptor componentDescriptor,
        ISettingDescriptor globalDescriptor) throws Exception
    {

    		if ( mapComponentSettings != null ) { 
    			this._contextFactoryClassName = (String)mapComponentSettings.get("Instance");
    			this._contextTypesList = (List)mapComponentSettings.get("ContextTypes");
    		}
    		this._contextFactoryDescriptor = componentDescriptor;
    }
	
	public ISettingDescriptor getComponentDescriptor() {
		return this._contextFactoryDescriptor;
	}
}
