/**
 * Copyright (c) 2006, 2008 Oracle and/or its affiliates. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Mohamad Raja - Initial implementation
 */
package org.eclipse.higgins.idas.cp.google.test;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Iterator;

import junit.framework.TestCase;

import org.eclipse.higgins.idas.api.IAttribute;
import org.eclipse.higgins.idas.api.IEntity;
import org.eclipse.higgins.idas.api.IContext;
import org.eclipse.higgins.idas.api.IContextId;
import org.eclipse.higgins.idas.api.IFilter;
import org.eclipse.higgins.idas.api.IFilterAttributeAssertion;
import org.eclipse.higgins.idas.api.ISimpleValue;
import org.eclipse.higgins.idas.api.ITypedValue;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.common.AuthNNamePasswordMaterials;
import org.eclipse.higgins.idas.registry.IdASRegistry;
import org.eclipse.higgins.idas.registry.contextid.ContextIdFactory;
import org.eclipse.higgins.idas.registry.discovery.FileDiscovery;
import org.eclipse.higgins.idas.spi.BasicValueInt;

public class GDataCPTest extends TestCase
{
    public static void main(String[] args) throws Exception
    {
        String proxyHost = "<proxyHost>";
        System.setProperty("http.proxySet", "true");
        System.setProperty("http.proxyHost", proxyHost);
        System.setProperty("http.proxyPort", "80");

        System.setProperty("https.proxySet", "true");
        System.setProperty("https.proxyHost", proxyHost);
        System.setProperty("https.proxyPort", "80");

        IdASRegistry registry = IdASRegistry.getInstance();
        IContextId contextId = ContextIdFactory.fromString("GDataContext.xrds");
        registry.setDiscovery(new FileDiscovery(new File("GDataContext.xrds")));
        System.out.println("List: " + Arrays.toString(contextId.getTypes()));

        IContext context = registry.createContext("GDataContext.xrds");
        context.open(new AuthNNamePasswordMaterials(
            context, "<GMail ID>", "<password>"));

        IEntity entity = createContact(context, "Test Entity1");
        updateContact(context, entity);
        listContacts(context);
        queryContacts(context);
        deleteContact(context, entity);
    }

    private static IEntity createContact(IContext context, String entityID)
        throws IdASException, URISyntaxException
    {
        IEntity entity = context.addEntity(new URI("contact"), entityID);
        IAttribute attr = entity.addAttribute(new URI("title"));
        attr.addSimpleValue(ITypedValue.STRING_TYPE_URI, "Mohamad Taufeeq");

        attr = entity.addAttribute(new URI("email"));
        IEntity attrValue = 
            attr.addComplexValue(ITypedValue.ANYURI_TYPE_URI);
        IAttribute compAttr = attrValue.addAttribute(new URI("address"));
        compAttr.addSimpleValue(ITypedValue.STRING_TYPE_URI, 
            "mohamad.taufeeq@oracle.com");

        compAttr = attrValue.addAttribute(new URI("rel"));
        compAttr.addSimpleValue(ITypedValue.STRING_TYPE_URI, 
            "http://schemas.google.com/g/2005#work");

        context.applyUpdates();
        System.out.println("Contact added successfully: " + entity);
        return entity;
    }

    private static void listContacts(IContext context) 
        throws IdASException, URISyntaxException
    {
        System.out.println("Enter List contacts");
        Iterator entityIter = context.getEntities((IFilter)null);
        while (entityIter.hasNext())
        {
            IEntity entity = (IEntity)entityIter.next();
            System.out.println("\nSearch Result: " + entity);
        }
    }

    private static void deleteContact(IContext context, IEntity entity)
        throws IdASException
    {
        entity.remove();
        context.applyUpdates();
        System.out.println("Contact deleted successfully: " 
            + entity.getEntityID());
    }

    private static void queryContacts(IContext context) 
        throws IdASException, URISyntaxException
    {
        System.out.println("Enter Query contacts");
        IFilter filter = context.buildFilter();
        filter.setOperator(IFilter.OP_AND);

        IFilter nFilter = context.buildFilter();
        IFilterAttributeAssertion attrAssertion = context.buildAttributeAssertion();
        attrAssertion.setID(new URI("maxResults"));
        attrAssertion.setComparator(IFilterAttributeAssertion.COMP_ATTR_EQ);
        BasicValueInt assertionValue = new BasicValueInt(10, null);
        attrAssertion.setAssertionValue(assertionValue);
        nFilter.setAssertion(attrAssertion);
        filter.addFilter(nFilter);

        nFilter = context.buildFilter();
        attrAssertion = context.buildAttributeAssertion();
        attrAssertion.setID(new URI("startIndex"));
        attrAssertion.setComparator(IFilterAttributeAssertion.COMP_ATTR_EQ);
        assertionValue = new BasicValueInt(1, null);
        attrAssertion.setAssertionValue(assertionValue);
        nFilter.setAssertion(attrAssertion);
        filter.addFilter(nFilter);

        Iterator entityIter = context.getEntities(filter);
        while (entityIter.hasNext())
            System.out.println("\nSearch Result: " + entityIter.next());
    }

    private static void updateContact(IContext context, IEntity entity)
        throws IdASException, URISyntaxException
    {
        System.out.println("Enter update contacts");
        IAttribute orgAttr = entity.addAttribute(new URI("organization"));
        IEntity attrValue = 
            orgAttr.addComplexValue(ITypedValue.ANYURI_TYPE_URI);

        IAttribute compAttr = 
            attrValue.addAttribute(new URI("orgName"));
        compAttr.addSimpleValue(ITypedValue.STRING_TYPE_URI, 
            "Oracle Corporation");

        compAttr = attrValue.addAttribute(new URI("orgTitle"));
        compAttr.addSimpleValue(ITypedValue.STRING_TYPE_URI, 
            "Senior Staff Engineer");

        compAttr = attrValue.addAttribute(new URI("rel"));
        compAttr.addSimpleValue(ITypedValue.STRING_TYPE_URI, 
            "http://schemas.google.com/g/2005#work");

        compAttr = attrValue.addAttribute(new URI("primary"));
        compAttr.addSimpleValue(ITypedValue.BOOLEAN_TYPE_URI, "true");
        context.applyUpdates();

        entity.removeAttribute(new URI("organization"));
        context.applyUpdates();
    }
}
