/**
 * Copyright (c) 2009 Parity Communications, Inc. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Sergey Lyakhov - initial API and implementation
 */
package org.eclipse.higgins.idas.cp.hb;

import java.util.List;

import org.eclipse.higgins.idas.api.IdASException;

/**
 * Wrap hibernate dynamic persistent object (DOM4J element or MAP).
 */
public interface IHibernateEntity {

	/**
	 * @return The name of hibernate entity
	 */
	public String getEntityName();

	/**
	 * @return Hibernate persistent object
	 */
	public Object getEntityObject();

	/**
	 * Set single property
	 * 
	 * @param objectName
	 *            Hibernate property name
	 * @param value
	 *            Value
	 * @throws IdASException
	 */
	public void setObject(String objectName, Object value) throws IdASException;

	/**
	 * Create a new transient hibernate entity and add it to collection
	 * 
	 * @param collectionName
	 *            The name of collection
	 * @param entityName
	 *            The name of new entity to be created
	 * @param singleValued
	 *            if <code>true</code>, than collection should not contain more
	 *            than one value
	 * @return
	 * @throws IdASException
	 */
	public IHibernateEntity buildCollectionEntity(String collectionName, String entityName, boolean singleValued)
			throws IdASException;

	/**
	 * Remove entity from appropriate collection
	 * 
	 * @param collectionName
	 * @param hibernateEntity
	 * @throws IdASException
	 */
	public void removeFromCollection(String collectionName, IHibernateEntity hibernateEntity) throws IdASException;

	/**
	 * Return all values of collection in form of <code>IHibernateEntity</code>
	 * 
	 * @param collectionName
	 * @return
	 * @throws IdASException
	 */
	public List getCollection(String collectionName) throws IdASException;

	/**
	 * Get single property
	 * 
	 * @param collectionName
	 *            The name of collection
	 * @return
	 * @throws IdASException
	 */
	public Object getObject(String name) throws IdASException;

}
