/**
 * Copyright (c) 2009 Parity Communications, Inc. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Sergey Lyakhov - initial API and implementation
 */
package org.eclipse.higgins.idas.cp.hb;

import java.net.URI;

import org.eclipse.higgins.idas.api.IdASException;
import org.hibernate.EntityMode;

/**
 * Responds for <code>IHibernateEntity</code> instances initialization from
 * Hibernate persistent object and convertation between IdAS and Hibernate data
 */
public interface IHibernateEntityFactory {

	/**
	 * @return Hibernate <code>EntityMode</code> used by the context
	 */
	public EntityMode getEntityMode();

	/**
	 * @param hibernateObject
	 *            Hibernate persistent object (map or DOM4J element)
	 * @param entityName
	 *            Hibernate entity name
	 * @return
	 * @throws IdASException
	 */
	public IHibernateEntity create(Object hibernateObject, String entityName) throws IdASException;

	/**
	 * Convert value of Hibernate entity into value of
	 * <code>ISimpleAttrValue</code>
	 * 
	 * @param value
	 *            Hibernate entity value
	 * @param valueType
	 *            Type of <code>ISimpleAttrValue</code>
	 * @return
	 * @throws IdASException
	 */
	public Object hibernateToIdas(Object value, URI valueType) throws IdASException;

	/**
	 * Convert value of <code>ISimpleAttrValue</code> into Hibernate form
	 * 
	 * @param value
	 *            Data of IdAS ISimpleAttrValue
	 * @param valueType
	 *            Type of IdAS ISimpleAttrValue
	 * @return
	 * @throws IdASException
	 */
	public Object idasToHibernate(Object value, URI valueType) throws IdASException;

}
