/**
 * Copyright (c) 2009 Parity Communications, Inc. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Sergey Lyakhov - initial API and implementation
 */

package org.eclipse.higgins.idas.cp.hb;

/**
 * Represents  context entity which should be saved, updated or deleted by
 * session to apply changes in context 
 * 
 */
public interface IStatefulObject {

	public final static String NEW_OBJ = "NEW_OBJ";

	public final static String STORED_OBJ = "STORED_OBJ";

	public final static String CHANGED_OBJ = "CHANGED_OBJ";

	public final static String PRE_DELETED_STORED_OBJ = "PRE_DELETED_STORED_OBJ";

	public final static String PRE_DELETED_NEW_OBJ = "PRE_DELETED_NEW_OBJ";

	public final static String DELETED_OBJ = "DELETED_OBJ";

	/**
	 * @return
	 */
	public String getState();

	/**
	 * @return
	 */
	public IHibernateEntity getHibernateEntity();

	/**
	 * @return Owner of this <code>ISessionEntity</code> which should be
	 *         updated
	 */
	public IStatefulObject getParentObject();

	/**
	 * 
	 */
	public void commitState();

}
