/**
 * Copyright (c) 2008 Parity Communications, Inc. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Sergey Lyakhov - initial API and implementation
 */

package org.eclipse.higgins.idas.cp.hb.authentication;

import java.net.URI;

public class AuthConstants {

	/**
	 * Entity name which holds user's account data
	 */
	public static final String USER_ACCOUNT = "userAccount";

	/**
	 * The name of Entity property which contains userAccount
	 */
	public static final String USER_PROPERTY_NAME = "userAccount";

	/**
	 * The name of property of <code>USER_ACCOUNT</code> entity which is used
	 * to hold the login of user's account. Used in case of username/password
	 * authentication.
	 */
	public static final String USER_LOGIN = "login";

	/**
	 * The name of field in user account and entities which holds UUID of user account.
	 */
	public static final String USER_TOKEN = "user_token";

	/**
	 * The name of property of <code>USER_ACCOUNT</code> entity which is used
	 * to hold SHA-256 hash value of password of user's account. Used in case of
	 * username/password authentication.
	 */
	public static final String USER_PASSWORD_HASH = "password_hash";

	/**
	 * The name of datatype property used to hold PPID value of user's account.
	 */
	final public static String PPID_PROPERTY = "http://www.eclipse.org/higgins/authentication#PPID";

	/**
	 * The name of property of <code>Entity</code> entity which is used to hold
	 * PPID value
	 * 
	 */
	final public static String PPID_HIBERNATE_NAME = "PPID";

	final public static URI PPID_PROPERTY_URI = URI.create(PPID_PROPERTY);

}