/**
 * Copyright (c) 2008 Parity Communications, Inc. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Sergey Lyakhov - initial API and implementation
 */

package org.eclipse.higgins.idas.cp.hb.authentication;

import java.io.Serializable;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.common.AuthNNamePasswordMaterials;
import org.eclipse.higgins.idas.cp.hb.IHibernateEntity;
import org.eclipse.higgins.idas.cp.hb.impl.Context;

public class PasswordBasedUserAccount extends UserAccount {
	private static Log log = LogFactory.getLog(PasswordBasedUserAccount.class);

	/**
	 * @param model
	 * @param accountInd
	 * @param credentials
	 * @throws IdASException
	 */
	public PasswordBasedUserAccount(Context model, Serializable userAccountID, IHibernateEntity userAccount, AuthNNamePasswordMaterials credentials) throws IdASException {
		super(model, userAccountID, userAccount, credentials);
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	public boolean equals(Object obj) {
		if (obj instanceof PasswordBasedUserAccount == false)
			return false;
		PasswordBasedUserAccount ext = (PasswordBasedUserAccount) obj;
		AuthNNamePasswordMaterials extCredentials = (AuthNNamePasswordMaterials) ext.getCredentials();
		AuthNNamePasswordMaterials credentials = (AuthNNamePasswordMaterials) credentials_;
		String name = null;
		String password = null;
		String extName = null;
		String extPassword = null;
		try {
			name = credentials.getUsername();
			password = credentials.getUsername();
			extName = extCredentials.getUsername();
			extPassword = extCredentials.getPassword();
		} catch (Exception e) {
			log.error(e, e);
			return false;
		}
		if (name == null)
			return false;
		if (name.equals(extName) == false)
			return false;
		if (password == null && extPassword == null)
			return true;
		if (password == null)
			return false;
		return password.equals(extPassword);
	}
}
