/**
 * Copyright (c) 2008 Parity Communications, Inc. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Sergey Lyakhov - initial API and implementation
 */

package org.eclipse.higgins.idas.cp.hb.authentication;

import java.io.Serializable;

//import org.apache.commons.logging.Log;
//import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.cp.hb.IHibernateEntity;
import org.eclipse.higgins.idas.cp.hb.IUserAccount;
import org.eclipse.higgins.idas.cp.hb.impl.Context;

public abstract class UserAccount implements IUserAccount {
//	private static Log log = LogFactory.getLog(UserAccount.class);

	protected Context context_ = null;

	protected Serializable userAccountID_ = null;

	protected Object credentials_ = null;

	protected IHibernateEntity userAccount_ = null;

	/**
	 * @param context
	 * @param userAccountID
	 * @param userToken
	 * @param credentials
	 * @throws IdASException
	 */
	public UserAccount(Context context, Serializable userAccountID, IHibernateEntity userAccount, Object credentials)
			throws IdASException {
		if (context == null)
			throw new IdASException("The parameter \"context\" is null");
		if (credentials == null)
			throw new IdASException("The parameter \"credentials\" is null");
		context_ = context;
		userAccountID_ = userAccountID;
		userAccount_ = userAccount;
		credentials_ = credentials;
	}

	public Object getCredentials() {
		return credentials_;
	}

	public Serializable getUserAccountID() {
		return userAccountID_;
	}

	public Object getUserAccount() {
		if (userAccount_ != null) {
			return userAccount_.getEntityObject();
		}
		return null;
	}

}
