/**
 * Copyright (c) 2007 Parity Communications, Inc. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Yuriy Pilipenko - initial API and implementation
 */

package org.eclipse.higgins.idas.cp.hb.filter.impl;

import java.util.ArrayList;

import org.eclipse.higgins.idas.api.BadFilterException;
import org.eclipse.higgins.idas.api.IFilter;
import org.eclipse.higgins.idas.api.IFilterAssertion;
import org.eclipse.higgins.idas.api.IdASException;


public class Filter implements IFilter {
	//private Log log = LogFactory.getLog(Filter.class);

	private IFilterAssertion assertion_ = null;
	private String operator_ = null;
	private ArrayList filters_ = null;

	//private Context idasContext_ = null;
	//private ICondition condition_ = null;

	public Filter() throws IdASException {

//		if (context == null)
//			throw new IdASException("Parameter \"context\" is null");
//		idasContext_ = context;
	}

	public void setAssertion(IFilterAssertion assertion) throws IdASException {
		if (!(assertion instanceof FilterAssertion))
			throw new BadFilterException("FilterAssertion created by another context provider implementation cannot be added");
		if (operator_ != null || filters_ != null)
			throw new BadFilterException("Assertion cannot be added when operator or filter is present");
		assertion_ = assertion;
	}

	public void setOperator(String operator) throws IdASException {
		if (assertion_ != null)
			throw new BadFilterException("Operators cannot be added when assertion is set");
		if (!OP_NOT.equals(operator) && !OP_AND.equals(operator) && !OP_OR.equals(operator)) 
			throw new BadFilterException("Unexpected operator: " + operator);
		operator_ = operator;
	}

	public void addFilter(IFilter filter) throws IdASException {
		if (filter == null)
			throw new BadFilterException("Cannot add null filter.");
		if (assertion_ != null)
			throw new BadFilterException("Filter cannot be added when assertion is present");
		if (!(filter instanceof Filter))
			throw new BadFilterException("Filter created by another context provider implementation cannot be added");
		if (filters_ == null)
			filters_ = new ArrayList();
		if (operator_ == OP_NOT && filters_.size() >= 1) {
			throw new BadFilterException("Cannot add more filters with operator " + OP_NOT);
		}
		filters_.add(filter);
	}

	public void addFilter(IFilterAssertion filterAssertion) throws IdASException {
		if (!(filterAssertion instanceof FilterAssertion))
			throw new BadFilterException("FilterAssertion created by another context provider implementation cannot be added");
		IFilter filter = new Filter();
		filter.setAssertion(filterAssertion);
		addFilter(filter);
	}

	/**
	 * @return assertion set by calling {@link #setAssertion(IFilterAssertion)}.
	 *         May be null.
	 * @throws IdASException
	 */
	public IFilterAssertion getAssertion() throws IdASException {
		return assertion_;
	}
	
	/**
	 * @return operator set by calling {@link #setOperator(String)}. May be
	 *         null.
	 * @throws IdASException
	 */
	public String getOperator() throws IdASException {
		return operator_;
	}
	
	/**
	 * @return
	 * @throws IdASException
	 */
	public ArrayList getFilters() throws IdASException {
		return filters_;
	}


	/**
	 * This method is used when Filter was added to FilterAttributeAssertion as
	 * metadata filter
	 * 
	 * @param root
	 * @param filterContext
	 * @throws IdASException
	 */
//	public void initAsAttributeMetadataFilter(GraphPattern root, FilterContext filterContext) throws IdASException {
//		log.trace("org.eclipse.higgins.idas.cp.jena2.impl.filter.Filter::initAsAttributeMetadataFilter");
//		if (assertion_ == null) {
//			if (filters_ == null || filters_.size() == 0)
//				throw new IdASException("Filter doesn't contain any filters/assertion");
//			int size = filters_.size();
//			for (int i = 0; i < size; i++) {
//				CompoundCondition condition = new CompoundCondition(operator_);
//				Filter filter = (Filter) filters_.get(i);
//				filter.initAsAttributeMetadataFilter(root, filterContext);
//				condition.addCondition(filter.getCondition());
//				condition_ = condition;
//			}
//		} else {
//			if (assertion_ instanceof FilterMetadataAssertion == false)
//				throw new IdASException("Filters added to IFilterAttributeAssertion as metadata filter can contain only IFilterMetadataAssertion instance");
//			FilterMetadataAssertion assertion = (FilterMetadataAssertion) assertion_;
//			assertion.initAsAttributeMetadata(root, filterContext);
//			condition_ = assertion.getCondition();
//		}
//	}

}
