/**
 * Copyright (c) 2007 Parity Communications, Inc. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Sergey Lyakhov - initial API and implementation
 */

package org.eclipse.higgins.idas.cp.hb.filter.impl;

import java.net.URI;

import org.eclipse.higgins.idas.api.IFilterAssertion;
import org.eclipse.higgins.idas.api.IdASException;
import org.hibernate.Criteria;
import org.hibernate.criterion.Criterion;

public abstract class FilterAssertion implements IFilterAssertion {
	//private Log log = LogFactory.getLog(FilterAssertion.class);

	protected String comparator_;
	protected URI type_;
	protected boolean includeSubtypes_ = false;

	
	public void setID(URI id, boolean bIncludeSubtypes) throws IdASException {
		setID(id);
		includeSubtypes(bIncludeSubtypes);
	}

	public void setID(URI id) throws IdASException {
		type_ = id;
	}
	
	public void includeSubtypes(boolean bIncludeSubtypes) throws IdASException {
		includeSubtypes_ = bIncludeSubtypes;
	}
	
	abstract public Criterion getRestriction(Criteria criteria) throws IdASException; 

}
