/**
 * Copyright (c) 2007 Parity Communications, Inc. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Sergey Lyakhov - initial API and implementation
 */

package org.eclipse.higgins.idas.cp.hb.filter.impl;

import java.net.URI;

import org.eclipse.higgins.idas.api.BadFilterException;
import org.eclipse.higgins.idas.api.IFilterEntityIDAssertion;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.cp.hb.util.MappingBuilder;
import org.hibernate.Criteria;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public class FilterEntityIDAssertion extends FilterAssertion implements IFilterEntityIDAssertion {

	private String entityID_ = null;

	public FilterEntityIDAssertion() {
		comparator_ = IFilterEntityIDAssertion.COMP_ENTITYID_EQ;
	}

	public void setComparator(String comparator) throws IdASException {
		if (comparator == null)
			throw new BadFilterException("Comparator cannot be null");
		if (!comparator.equals(IFilterEntityIDAssertion.COMP_ENTITYID_EQ))
			throw new IdASException("Unsupported compatator: " + comparator + " for " + this.getClass().getName());
	}

	public void setID(URI id) throws IdASException {
		throw new IdASException("The type of FilterEntityIDAssertion is predefined and couldn't be set.");
	}

	public void setAssertionValue(String entityID) throws IdASException {
		if (entityID == null)
			throw new IdASException("Unable to set \"null\" assertion value");
		entityID_ = entityID;
	}

	public Criterion getRestriction(Criteria criteria) throws BadFilterException {
		return Restrictions.eq(MappingBuilder.higgins_entityId, entityID_);
	}

}
