/**
 * Copyright (c) 2007 Parity Communications, Inc. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Sergey Lyakhov - initial API and implementation
 */

package org.eclipse.higgins.idas.cp.hb.filter.impl;

import java.net.URI;

import org.eclipse.higgins.idas.api.BadFilterException;
import org.eclipse.higgins.idas.api.IFilterEntityTypeAssertion;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.api.model.IContextModel;
import org.eclipse.higgins.idas.api.model.IEntityModel;
import org.eclipse.higgins.idas.cp.hb.impl.Context;
import org.hibernate.Criteria;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Property;

public class FilterEntityTypeAssertion extends FilterAssertion implements IFilterEntityTypeAssertion {

	private Context context;
	private IContextModel model;
	private String typeHbName;

	public FilterEntityTypeAssertion(Context context) throws IdASException {
		super();
		this.context = context;
		this.model = context.getContextModel();
	}

	public void setID(URI id) throws IdASException {
		throw new IdASException("The type of FilterEntityTypeAssertion is predefined and couldn't be set.");
	}

	public void setComparator(String comparator) throws IdASException {
		if (comparator == null)
			throw new BadFilterException("Comparator cannot be null");
		if (!comparator.equals(IFilterEntityTypeAssertion.COMP_TYPE_EQ))
			throw new IdASException("Unsupported compatator: " + comparator + " for " + this.getClass().getName());
		comparator_ = comparator;
	}

	public void setAssertionValue(URI assertion) throws IdASException {
		IEntityModel nodeModel = (IEntityModel) model.getEntityModel(assertion);
		if (nodeModel == null) {
			throw new BadFilterException("The schema does not contain definition for Entity type " + assertion);
		}
		super.setID(assertion);
		typeHbName = context.getTypeResolver().modelTypeToHibernateType(nodeModel);
	}

	public Criterion getRestriction(Criteria criteria) throws IdASException {
		// EntityModelExt root = model_.getTopEntityModel();
		// TODO Bug in hybernate implementation of criteria query on "class"
		// property
		// TODO !!!!!!!!!!!! use with fixed hibernate3.jar
		return Property.forName("class").eq(typeHbName);

	}

}
