/**
 * Copyright (c) 2008 Parity Communications, Inc. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Sergey Lyakhov - initial API and implementation
 */
package org.eclipse.higgins.idas.cp.hb.impl;

import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.apache.axiom.om.util.UUIDGenerator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.idas.api.AuthenticationException;
import org.eclipse.higgins.idas.api.ContextNotOpenException;
import org.eclipse.higgins.idas.api.ContextOpenException;
import org.eclipse.higgins.idas.api.IAttribute;
import org.eclipse.higgins.idas.api.IValue;
import org.eclipse.higgins.idas.api.IAuthNAttributesMaterials;
import org.eclipse.higgins.idas.api.IAuthNMaterials;
import org.eclipse.higgins.idas.api.IContext;
import org.eclipse.higgins.idas.api.IEntity;
import org.eclipse.higgins.idas.api.IExtension;
import org.eclipse.higgins.idas.api.IFilter;
import org.eclipse.higgins.idas.api.IFilterAttributeAssertion;
import org.eclipse.higgins.idas.api.IFilterEntityIDAssertion;
import org.eclipse.higgins.idas.api.IFilterEntityTypeAssertion;
import org.eclipse.higgins.idas.api.IHasAttributes;
import org.eclipse.higgins.idas.api.ISimpleValue;
import org.eclipse.higgins.idas.api.ISingleValuedAttribute;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.api.InvalidEntityIDException;
import org.eclipse.higgins.idas.api.InvalidTypeException;
import org.eclipse.higgins.idas.api.NotImplementedException;
import org.eclipse.higgins.idas.api.EntityExistsException;
import org.eclipse.higgins.idas.api.NotSingleValuedAttributeException;
import org.eclipse.higgins.idas.common.AuthNAnonymousMaterials;
import org.eclipse.higgins.idas.cp.hb.IHibernateEntity;
import org.eclipse.higgins.idas.cp.hb.IHibernateEntityFactory;
import org.eclipse.higgins.idas.cp.hb.IStatefulObject;
import org.eclipse.higgins.idas.cp.hb.IUserAccount;
import org.eclipse.higgins.idas.cp.hb.filter.impl.Filter;
import org.eclipse.higgins.idas.cp.hb.filter.impl.FilterAttributeAssertion;
import org.eclipse.higgins.idas.cp.hb.filter.impl.FilterContext;
import org.eclipse.higgins.idas.cp.hb.filter.impl.FilterEntityIDAssertion;
import org.eclipse.higgins.idas.cp.hb.filter.impl.FilterEntityTypeAssertion;
import org.eclipse.higgins.idas.cp.hb.impl.entity.Dom4jHibernateEntityFactory;
import org.eclipse.higgins.idas.cp.hb.impl.entity.MapHibernateEntityFactory;
import org.eclipse.higgins.idas.cp.hb.util.MappingBuilder;
import org.eclipse.higgins.idas.cp.hb.util.SessionContext;
import org.eclipse.higgins.idas.cp.hb.util.TypeResolver;
import org.eclipse.higgins.idas.cp.model.impl.ContextModel;
import org.eclipse.higgins.idas.cp.model.impl.EntityModel;
import org.eclipse.higgins.idas.cp.model.util.Validator;
import org.eclipse.higgins.idas.spi.BasicAttribute;
import org.eclipse.higgins.idas.spi.BasicAuthNAttributesMaterials;
import org.eclipse.higgins.idas.spi.BasicComplexValue;
import org.eclipse.higgins.idas.spi.BasicSimpleValue;
import org.eclipse.higgins.idas.api.model.IContextModel;
import org.eclipse.higgins.idas.api.model.IdASModelException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;

import org.eclipse.higgins.idas.cp.hb.authentication.AuthConstants;
import org.eclipse.higgins.idas.cp.hb.authentication.AuthenticationModule;

public class Context implements IContext {

	public static final String PARAM_CONTEXT_URI = "context.uri";

	public static final String PARAM_SCHEMA_URI = "schema.uri";

	public static final String PARAM_SCHEMA_FILE = "schema.file";
	// Can be true (by default) or false 
	public static final String PARAM_AUTHENTICATION = "context.allowanonymous";
	// Can be true (by default) or false 
	public static final String PARAM_VALIDATION = "context.performvalidation";

	public static final String PARAM_HIBERNATE_CONFIG = "hibernateConfig";
	// Can be DOM4J or MAP (by default) 
	public static final String PARAM_MAPPING_MODE = "context.hibernatemappingmode";

	private static Log log = LogFactory.getLog(Context.class);

	protected String ns_ = null;

	protected ContextModel model_ = null;

	protected SessionFactory sessionFactory_ = null;

	protected TypeResolver typeResolver_ = null;

	protected Session session_ = null;

	protected Transaction transaction_ = null;

	protected ArrayList changedEntities_ = new ArrayList();

	protected Map config_ = null;

	protected IUserAccount userAccount_ = null;

	protected boolean authenticationRequired_ = false;

	protected boolean validationRequired_ = false;

	protected AuthenticationModule authModule_ = null;

	protected IAuthNMaterials currentCredentials = null;

	protected IAuthNMaterials lastCredentials = null;

	protected IHibernateEntityFactory hibernateEntityFactory = null;
	
	public Context(ContextModel model, ContextContext contextContext, Map config) {
		model_ = model;
		sessionFactory_ = contextContext.getSessionFactory();
		typeResolver_ = contextContext.getTypeResolver();
		config_ = config;
 		if (config_.containsKey(PARAM_AUTHENTICATION)) {
			String param = String.valueOf(config_.get(PARAM_AUTHENTICATION));
			authenticationRequired_ = ! "false".equalsIgnoreCase(param);
		}
		if (config_.containsKey(PARAM_VALIDATION)) {
			String param = String.valueOf(config_.get(PARAM_VALIDATION));
			validationRequired_ = ! "false".equalsIgnoreCase(param);
		}
		boolean useMapMode = true;
		if (config_.containsKey(PARAM_MAPPING_MODE)) {
			String param = String.valueOf(config_.get(PARAM_MAPPING_MODE));
			useMapMode = ! "DOM4J".equalsIgnoreCase(param);
		}
		if (useMapMode) {
			hibernateEntityFactory = new MapHibernateEntityFactory();
		}
		else {
			hibernateEntityFactory = new Dom4jHibernateEntityFactory();
		}
	}

	public IEntity addEntity(URI type, String entityID) throws IdASException, InvalidTypeException, InvalidEntityIDException, EntityExistsException {
		if (!isOpen(null))
			throw new ContextNotOpenException("");
		if (type == null)
			throw new IdASException("Parameter \"type\" is null");
		if (entityID != null && getEntity(entityID) != null) {
			throw new EntityExistsException("Entity with such ID already exists.");
		}
		EntityModel nm = (EntityModel) model_.getEntityModel(type);
		if (nm == null)
			throw new IdASModelException("Context can not create a entity with type = " + type.toString());
		IHibernateEntity he = getHibernateEntityFactory().create(null, typeResolver_.modelTypeToHibernateType(nm));
		Object userAccount = userAccount_.getUserAccount();
		if (userAccount != null) {
			try {
				he.setObject(AuthConstants.USER_PROPERTY_NAME , userAccount);
			}
			catch(Exception e) {
				log.error(e, e);
				throw new IdASException(e);
			}
		}
		String newSubjID = (entityID != null) ? entityID : UUIDGenerator.getUUID();
		he.setObject(MappingBuilder.higgins_entityId, newSubjID);
		Entity entity = new Entity(this, null, nm, he, false);
		registerChangedSubject(entity);
		return entity;
	}

	public IEntity addEntity(IEntity copyFrom) throws IdASException, EntityExistsException {
		if (!isOpen(null))
			throw new ContextNotOpenException("");
		if (copyFrom == null)
			throw new IdASException("Parameter \"copyFrom\" is null");
		Entity entity = (Entity) addEntity(copyFrom.getType(), copyFrom.getEntityID());
		Iterator attr = copyFrom.getAttributes();
		while (attr.hasNext()) {
			IAttribute attribute = (IAttribute) attr.next();
			entity.addAttribute(attribute);
		}
		return entity;
	}

	public IAttribute buildAttribute(URI attrID) throws IdASException {
		return new BasicAttribute(attrID, (Iterator) null, null, this);
	}

	public IFilterAttributeAssertion buildAttributeAssertion() throws IdASException {
		return new FilterAttributeAssertion(this);
	}

	public IAuthNAttributesMaterials buildAuthNAttributesMaterials() throws IdASException {
		return new BasicAuthNAttributesMaterials(null, this);
	}

	public IFilterEntityIDAssertion buildEntityIDAssertion() throws IdASException {
		return new FilterEntityIDAssertion();
	}

	public IEntity buildComplexAttrValue(URI type) throws IdASException, InvalidTypeException {
		return new BasicComplexValue(type, null, null);
	}

	public IFilter buildFilter() throws IdASException {
		return new Filter();
	}

	public ISimpleValue buildSimpleAttrValue(URI type, Object value) throws IdASException, InvalidTypeException {
		return new BasicSimpleValue(type, value);
	}

	public IFilterEntityTypeAssertion buildEntityTypeAssertion() throws IdASException {
		return new FilterEntityTypeAssertion(this);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.idas.IContext#close()
	 */
	public void close() throws IdASException {
		if (currentCredentials == null)
			throw new ContextNotOpenException("");
		try {
			transaction_.rollback();
			if (session_.isOpen())
				session_.close();
		} catch (Exception e) {
			log.error(e, e);
			throw new IdASException(e);
		}
		userAccount_ = null;
		currentCredentials = null;
	}

	public String exportData(String filter, String representationFormat) throws IdASException {
		throw new NotImplementedException("");
	}

	public IContextModel getContextModel() throws IdASException {
		return model_;
	}

	public URI getContextID() throws IdASException {
		return model_.getType();
	}

	public Iterator getRelationships() throws IdASException {
		throw new NotImplementedException("");
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.idas.IContext#getSchema()
	 */
	public String getSchema() throws IdASException {
		return null;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.idas.api.IContext#getSubject(java.lang.String)
	 */
	public IEntity getEntity(String cuid) throws IdASException {
		if (!isOpen(null))
			throw new ContextNotOpenException("");
		if (cuid == null) {
			//throw new NoSuchEntityException("Couldn't get DigitalSubject with null cuid");
			return null;
		}
		StringBuffer sb = new StringBuffer();
		sb.append("FROM ");
		sb.append(MappingBuilder.higgins_Entity);
		sb.append(" WHERE ");
		sb.append(MappingBuilder.higgins_entityId);
		sb.append(" = '");
		sb.append(cuid);
		sb.append("'");
		String userId = (userAccount_.getUserAccountID() != null) ? userAccount_.getUserAccountID().toString() : null;
		if (userId != null) {
			sb.append(" AND ");
			sb.append(AuthConstants.USER_ACCOUNT );
			sb.append(" = ");
			sb.append(userId);
		}
		String queryStr = sb.toString(); 
		Query query = session_.createQuery(queryStr);
		List lst = query.list();
		if (lst.size() == 0) {
			//throw new NoSuchEntityException();
			return null;
		}
		if (lst.size() > 1)
			throw new IdASException("There are more then one Entity with the same entity ID");
		Object obj = lst.get(0);
		String name = session_.getEntityName(obj);
		IHibernateEntity he = getHibernateEntityFactory().create(obj, name);
		String entityName = he.getEntityName();
		URI type = typeResolver_.hibernateTypeToModelType(entityName);
		if (type == null)
			throw new IdASException("Can not find entity type for mapping table name = " + entityName);
		EntityModel entityModel = (EntityModel) model_.getEntityModel(type);
		Entity nd = new Entity(this, null, entityModel, he, true);
		return nd;
	}

	public IEntity getEntity(String cuid, Iterator attrSelectionList) throws IdASException {
		return getEntity(cuid);
	}

	public Iterator getEntities(IFilter filter) throws IdASException {
		if (!isOpen(null))
			throw new ContextNotOpenException("");
		/*
		 * if (filter == null) throw new IdASException("Parameter \"filter\" is
		 * null.");
		 */
		if ((filter != null))
			if (!(filter instanceof Filter))
				throw new IdASException("IFIlter instance should be an instance of " + Filter.class.getName());
		ArrayList entities = new ArrayList();
		FilterContext ctx = new FilterContext(this);
		Iterator itr = ctx.getEntityElements((Filter) filter).iterator();
		while (itr.hasNext()) {
			Object obj = itr.next();
			IHibernateEntity he = getHibernateEntityFactory().create(obj, null);
			//if (checkUserAccount(elm)) {
				String entityName = he.getEntityName();
				URI type = typeResolver_.hibernateTypeToModelType(entityName);
				if (type == null)
					throw new IdASException("Can not find entity type for mapping table name = " + entityName);
				EntityModel entityModel = (EntityModel) model_.getEntityModel(type);
				Entity entity = new Entity(this, null, entityModel, he, true);
				entities.add(entity);
			//}
		}
		return entities.iterator();
	}

/*	private boolean checkUserAccount(Element entity) throws IdASException {
		if (authenticationRequired_) {
			Element ua = entity.element(AuthConstants.USER_ACCOUNT);
			if (ua != null) {
				Element id = ua.element("id_");
				if (id == null) {
					log.warn("Can not get id element from userAccount element");
					return false;
				}
				String userID = id.getText();
				if (userID == null)  {
					log.warn("Can not get value of user account ID");
					return false;
				}
				if (userID.equals(String.valueOf(userAccount_.getUserAccountID())))
					return true;
				else
					return false;
			}
			else {
				log.warn("User check warning. Entity element does not contain user account element and will be skipped.");
				return false;
			}
		}
		else
			return true;
	}
*/
	public Iterator getEntities(IFilter filter, Iterator attrSelectionList) throws IdASException {
		return getEntities(filter);
	}

	public void importData(String filter, String representationFormat) throws IdASException {
		throw new NotImplementedException("");
	}

	public boolean isOpen(Object identity) throws IdASException {
		if (identity == null)
			return this.userAccount_ != null;
		else
			return identity.equals(userAccount_.getCredentials());
	}

	public String open(IAuthNMaterials authentication) throws IdASException, ContextOpenException {
		if (currentCredentials != null)
			throw new ContextOpenException("");
		if (authentication == null)
			authentication = new AuthNAnonymousMaterials();
		if (authModule_ == null)
			authModule_ = new AuthenticationModule(this);
		userAccount_ = authModule_.authenticate(authentication);
		lastCredentials = currentCredentials = authentication;
		session_ = sessionFactory_.openSession().getSession(hibernateEntityFactory.getEntityMode());
		beginUpdates();
		return null;
	}

	public void removeSubject(String cuid) throws IdASException {
	}

	public void setSchema(String schema) throws IdASException {
	}

	public boolean verifyEntityAttributes(String subjectID, Iterator attributes) throws IdASException {
		throw new NotImplementedException("");
	}

	private void updateChangedEntities() throws IdASException {
		SessionContext sc = new SessionContext();
		sc.updateEntity(session_, changedEntities_);
	}

	private void commitChangedEntities() throws IdASException {
		for (int i = 0, size = changedEntities_.size(); i < size; i++) {
			Entity entity = (Entity) changedEntities_.get(i);
			entity.commitState();
			commitChangedAttributes(entity.getAttributes());
		}
	}

	private void commitChangedAttributes(Iterator attrs) throws IdASException {
		while (attrs.hasNext()) {
			IAttribute attr = (IAttribute) attrs.next();
			Iterator vals = attr.getValues();
			while (vals.hasNext()) {
				IValue val = (IValue) vals.next();
				if (val.isSimple()) {
					((SimpleValue) val).commitState();
				} else {
					Entity cv = (Entity) val;
					cv.commitState();
					commitChangedAttributes(cv.getAttributes());
				}
			}
		}
	}

	private void validateEntities() throws IdASException {
		if (validationRequired_ == false)
			return;
		for (int i = 0, size = changedEntities_.size(); i < size; i++) {
			Entity entity = (Entity) changedEntities_.get(i);
			String entityState = entity.getState();
			if (! IStatefulObject.PRE_DELETED_NEW_OBJ.equals(entityState) && ! IStatefulObject.PRE_DELETED_STORED_OBJ.equals(entityState)) {
				Validator.validateEntity(entity);
			}
		}
	}

	/**
	 * Register the subject which was changed and should be validated
	 * (optionally) before saving
	 * 
	 * @param subj
	 * @throws IdASException
	 */
	public void registerChangedSubject(Entity entity) {
		if (!changedEntities_.contains(entity)) {
			changedEntities_.add(entity);
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.idas.cp.jena2.IJenaContext#unregisterChangedSubject(org.eclipse.higgins.idas.cp.jena2.impl.DigitalSubject)
	 */
	public void unregisterChangedSubject(Entity entity) {
		if (changedEntities_.contains(entity))
			changedEntities_.remove(entity);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.idas.cp.jena2.IJenaContext#setValidationMode(boolean)
	 */
	public void setValidationMode(boolean performValidation) {
		validationRequired_ = performValidation;
	}

	public Session getSession() throws IdASException {
		if (isOpen(null)) {
			return session_;
		} else
			throw new ContextNotOpenException("Context is not open.");
	}

	public void beginUpdates() throws IdASException {
		changedEntities_.clear();
		transaction_ = session_.beginTransaction();
		transaction_.begin();
	}

	public void applyUpdates() throws IdASException {
		validateEntities();
		updateChangedEntities();
		try {
//			session_.flush();
			transaction_.commit();
			commitChangedEntities();
			beginUpdates();
		} catch (Exception e) {
			log.error(e, e);
			throw new IdASException(e);
		}
	}

	public void cancelUpdates() throws IdASException {
		try {
			transaction_.rollback();
			beginUpdates();
		} catch (Exception e) {
			log.error(e, e);
			throw new IdASException(e);
		}
	}

	public SessionFactory getSessionFactory() {
		return sessionFactory_;
	}

	public boolean isAuthenticationRequired() {
		return authenticationRequired_;
	}
	
	public IUserAccount getUserAccount() {
		return userAccount_;
	}

	public void setComponentSetting(String key, Object value, boolean failUnsupported) throws IdASException {
		// TODO Auto-generated method stub
		
	}

	public void setComponentSetting(String key, Object value) throws IdASException {
		// TODO Auto-generated method stub
		
	}

	public IAttribute addAttribute(URI attrID) throws IdASException, InvalidTypeException {
		// TODO Auto-generated method stub
		return null;
	}

	public IAttribute addAttribute(IAttribute copyFrom) throws IdASException {
		// TODO Auto-generated method stub
		return null;
	}

	public boolean equals(IHasAttributes attributes) throws IdASException {
		// TODO Auto-generated method stub
		return false;
	}

	public IAttribute getAttribute(URI attrID) throws IdASException {
		// TODO Auto-generated method stub
		return null;
	}

	public Iterator getAttributes() throws IdASException {
		// TODO Auto-generated method stub
		return null;
	}

	public ISingleValuedAttribute getSingleValuedAttribute(URI attrID) throws IdASException, NotSingleValuedAttributeException {
		// TODO Auto-generated method stub
		return null;
	}

	public void removeAttribute(URI attrID) throws IdASException {
		// TODO Auto-generated method stub
		
	}

	public void removeAttributeValue(URI attrID, Object value) throws IdASException {
		// TODO Auto-generated method stub
		
	}

	public void removeAttributeValue(IAttribute attr) throws IdASException {
		// TODO Auto-generated method stub
		
	}

	public String open(IAuthNMaterials authentication, IExtension[] extensions) throws IdASException, ContextOpenException {
		return open(authentication);
	}

	public Iterator getEntities(IFilter filter, Iterator attrSelectionList, IExtension[] extensions) throws IdASException {
		return getEntities(filter, attrSelectionList);
	}

	public void reopen() throws IdASException, AuthenticationException {
		if(lastCredentials != null)
			open(lastCredentials);
		else
			throw new IdASException("Context could not be reopen because it was not yet open before.");
	}

	public IHibernateEntityFactory getHibernateEntityFactory() {
		return hibernateEntityFactory;
	}

	public TypeResolver getTypeResolver() {
		return typeResolver_;
	}

	public Iterator getEntities(String query) throws IdASException {
		throw new IdASException("Not implemented.");
	}

	public Iterator getEntities(String query, Iterator attrSelectionList) throws IdASException {
		throw new IdASException("Not implemented.");
	}

	public Iterator getEntities(String query, Iterator attrSelectionList, IExtension[] extensions) throws IdASException {
		throw new IdASException("Not implemented.");
	}

	public IEntity addAttributeValue(URI attrType, String entityId) throws IdASException {
		throw new IdASException("Not implemented.");
	}

}
