/**
 * Copyright (c) 2008 Parity Communications, Inc. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Sergey Lyakhov - initial API and implementation
 */
package org.eclipse.higgins.idas.cp.hb.impl;

import java.io.File;
import java.net.URI;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.configuration.api.ISettingDescriptor;
import org.eclipse.higgins.idas.api.IContext;
import org.eclipse.higgins.idas.api.IContextFactory;
import org.eclipse.higgins.idas.api.IContextId;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.cp.hb.util.MappingBuilder;
import org.eclipse.higgins.idas.cp.model.ContextModelFactory;
import org.eclipse.higgins.idas.cp.model.impl.ContextModel;
import org.hibernate.cfg.Configuration;

import com.hp.hpl.jena.ontology.OntDocumentManager;

public class ContextFactory implements IContextFactory {
	private Log log = LogFactory.getLog(ContextFactory.class);

	protected String id_ = null;

	protected String name_ = null;

	protected String policy_ = null;

	protected File configFile_ = null;

	protected String cacheLocation_ = null;

	protected OntDocumentManager documentManager_ = null;

	protected HashMap modelBySchema_ = new HashMap();

	protected HashMap contextContextByContextID_ = new HashMap();


	private ISettingDescriptor _contextFactoryDescriptor = null;
	private List _contextTypesList = null;
	private String _contextFactoryClassName = null;
	
	
	public ContextFactory() throws IdASException {
	}

	protected ContextFactory(String id, String name) throws IdASException {
	}

	public String getName() throws IdASException {
		return name_;
	}

	public Iterator getContexts(String filter) throws IdASException {
		return null;
	}

	public String getPolicy() throws IdASException {
		return policy_;
	}

	public void setPolicy(String policy) throws IdASException {
		policy_ = policy;
	}

	public IContext createContext(IContextId contextID) throws IdASException {
		if (contextID == null)
			throw new IdASException("Parameter \"contextID\" is null.");
		Map config = contextID.getConfiguration();
		try {
			URI contextURI = (URI) config.get(Context.PARAM_CONTEXT_URI);
			URI schemaURI = (URI) config.get(Context.PARAM_SCHEMA_URI);
			String schemaFile = (String) config.get(Context.PARAM_SCHEMA_FILE);
			if (contextURI == null)
				throw new IdASException("Property \"contextURI\" was not found in the context configuration.");
			if (schemaURI == null)
				throw new IdASException("Property \"schemaURI\" was not found in the context configuration.");
			if (schemaFile == null)
				throw new IdASException("Property \"schemaFile\" was not found in the context configuration.");
			Map hibernateConfig = (Map) config.get("hibernateConfig");
			if (hibernateConfig == null)
				throw new IdASException("Map \"hibernateConfig\" was not found in the context configuration.");
			Properties hibernateProperties = new Properties();
			hibernateProperties.putAll(hibernateConfig);
			ContextModel contextModel = ContextModelFactory.getInstance().getContextModel(schemaURI, schemaFile);
			ContextContext contextContext = getContextContext(contextURI, contextModel, hibernateProperties);
			Context context = new Context(contextModel, contextContext, config);
			return context;

		} catch (Exception e) {
			log.error(e);
			throw new IdASException(e);
		}
	}

	public void configure(Map mapGlobalSettings, String strComponentName, Map mapComponentSettings, ISettingDescriptor componentDescriptor,ISettingDescriptor globalDescriptor) throws Exception {
		if ( mapComponentSettings != null ) { 
			this._contextFactoryClassName = (String)mapComponentSettings.get("Instance");
			this._contextTypesList = (List)mapComponentSettings.get("ContextTypes");
		}
		this._contextFactoryDescriptor = componentDescriptor;
	}

	private synchronized ContextContext getContextContext(URI contextURI, ContextModel model, Properties hibernateProperties) throws IdASException {
		if (contextContextByContextID_.containsKey(contextURI)) {
			return (ContextContext)contextContextByContextID_.get(contextURI);
		}
		else {
			MappingBuilder mappingBuilder = new MappingBuilder(model, hibernateProperties);
			mappingBuilder.build();
			Configuration config = mappingBuilder.getConfiguration();
			ContextContext cc = new ContextContext(config.buildSessionFactory(), mappingBuilder.getTypeResolver());
			contextContextByContextID_.put(contextURI, cc);
			return cc;
		}
	}

	public ISettingDescriptor getComponentDescriptor() {
		return this._contextFactoryDescriptor;
	}

	public List getTypes() throws IdASException { 
		return this._contextTypesList;
	}

	public ISettingDescriptor getContextDescriptor(String contextIdName) throws IdASException {
		return null;
	}

}
