/**
 * Copyright (c) 2008 Parity Communications, Inc. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Sergey Lyakhov - initial API and implementation
 */
package org.eclipse.higgins.idas.cp.hb.impl;

import java.net.URI;
import java.util.Iterator;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.idas.api.IAttribute;
import org.eclipse.higgins.idas.api.IEntity;
import org.eclipse.higgins.idas.api.ISimpleValue;
import org.eclipse.higgins.idas.api.ISingleValuedAttribute;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.api.InvalidTypeException;
import org.eclipse.higgins.idas.api.NotImplementedException;
import org.eclipse.higgins.idas.api.NotSingleValuedAttributeException;
import org.eclipse.higgins.idas.api.model.IAttributeModel;
import org.eclipse.higgins.idas.api.model.ISimpleValueModel;
import org.eclipse.higgins.idas.api.model.IValueModel;
import org.eclipse.higgins.idas.api.model.IdASModelException;
import org.eclipse.higgins.idas.cp.hb.IHibernateEntity;
import org.eclipse.higgins.idas.cp.hb.IStatefulObject;
import org.eclipse.higgins.idas.cp.hb.util.DatatypeMapper;
import org.eclipse.higgins.idas.cp.hb.util.HBVocabulary;

public class SimpleValue extends StatefulObject implements ISimpleValue {
	private static Log log = LogFactory.getLog(SimpleValue.class);

	protected Context context_ = null;

	protected Attribute attribute_ = null;

	protected IHibernateEntity valueEntity_ = null;

	protected ISimpleValueModel valueModel_ = null;

	protected IAttributeModel attributeModel_ = null;

	protected Entity entity_ = null;

	public SimpleValue(Context context, Attribute attribute, IHibernateEntity valueEntity, ISimpleValueModel valueModel,
			boolean isStoredValue) throws IdASException {
		if (context == null)
			throw new IdASException("Parameter \"context\" is null.");
		if (attribute == null)
			throw new IdASException("Parameter \"attribute\" is null.");
		if (valueModel == null)
			throw new IdASException("Parameter \"valueModel\" is null.");
		context_ = context;
		attribute_ = attribute;
		attributeModel_ = attribute.getModel();
		valueEntity_ = valueEntity;
		valueModel_ = valueModel;
		entity_ = attribute_.getEntityOwner();
		if (isStoredValue) {
			setState(STORED_OBJ);
		}
	}

	public String getCanonical() throws IdASException {
		return getDataStr(getData());
	}

	public Object getData() throws IdASException {
		Object obj = null;
		if (attribute_.getModel().getAttributeMode() == IAttributeModel.SINGLE_VALUED_MODE) {
			obj = attribute_.getOwnerEntity().getObject(context_.getTypeResolver().modelTypeToHibernateType(attribute_.getModel()));
		} else {
			obj = valueEntity_.getObject(HBVocabulary.SIMPLE_VALUE_FIELD_NAME);
		}
		return context_.getHibernateEntityFactory().hibernateToIdas(obj, valueModel_.getType());
	}

	private String getDataStr(Object data) throws IdASException {
		if (data == null)
			return null;
		else
			return data.toString();
	}

	public String getLexical() throws IdASException {
		return getDataStr(getData());
	}

	public void setData(Object data) throws IdASException {
		if (data != null && DatatypeMapper.isCorrectType(valueModel_.getType().toString(), data) == false)
			throw new IdASException("Can not set a wrong value type " + data.getClass().getName() + " for simple value with type "
					+ valueModel_.getType().toString());
		Object obj = context_.getHibernateEntityFactory().idasToHibernate(data, valueModel_.getType());
		context_.registerChangedSubject(entity_);
		if (attributeModel_.getAttributeMode() == IAttributeModel.SINGLE_VALUED_MODE) {
			String hibernateType = context_.getTypeResolver().modelTypeToHibernateType(attributeModel_);
			attribute_.getOwnerEntity().setObject(hibernateType, obj);
			attribute_.getOwner().markChanged();
		} else {
			valueEntity_.setObject(HBVocabulary.SIMPLE_VALUE_FIELD_NAME, obj);
			markChanged();
		}
	}

	public URI getType() throws IdASException {
		return valueModel_.getType();
	}

	public boolean isSimple() throws IdASException {
		return true;
	}

	public void remove() throws IdASException {
		context_.registerChangedSubject(entity_);
		String hibernateType = context_.getTypeResolver().modelTypeToHibernateType(attributeModel_);
		if (attributeModel_.getAttributeMode() == IAttributeModel.SINGLE_VALUED_MODE) {
			attribute_.getOwnerEntity().setObject(hibernateType, null);
		} else {
			attribute_.getOwnerEntity().removeFromCollection(hibernateType, valueEntity_);
		}
		markDeleted();
	}

//	public boolean equals(Object obj) {
//		if (obj == null)
//			return false;
//		if (obj == this)
//			return true;
//		if (obj instanceof SimpleValue == false)
//			return false;
//		SimpleValue sv = (SimpleValue) obj;
//		if (valueEntity_ != null) {
//			return valueEntity_.equals(sv.getHibernateEntity());
//		} else {
//			try {
//				if (!getModel().getType().equals(sv.getModel().getType()))
//					return false;
//				if (getData() == null) {
//					if (sv.getData() == null)
//						return true;
//					else
//						return false;
//				}
//				if (getData().equals(sv.getData()))
//					return true;
//				else
//					return false;
//			} catch (Exception e) {
//				log.error(e, e);
//				return false;
//			}
//		}
//	}

	public ISimpleValueModel getModel() {
		return valueModel_;
	}

	public IAttribute addAttribute(URI attrID) throws IdASException, InvalidTypeException {
		throw new NotImplementedException();
	}

	public IAttribute addAttribute(IAttribute copyFrom) throws IdASException {
		throw new NotImplementedException();
	}

	public IAttribute getAttribute(URI attrID) throws IdASException {
		throw new NotImplementedException();
	}

	public Iterator getAttributes() throws IdASException {
		throw new NotImplementedException();
	}

	public ISingleValuedAttribute getSingleValuedAttribute(URI attrID) throws IdASException, NotSingleValuedAttributeException {
		throw new NotImplementedException();
	}

	public void removeAttribute(URI attrID) throws IdASException {
		throw new NotImplementedException();
	}

	public void removeAttributeValue(URI attrID, Object value) throws IdASException {
		throw new NotImplementedException();
	}

	public void removeAttributeValue(IAttribute attr) throws IdASException {
		throw new NotImplementedException();
	}

	public IHibernateEntity getHibernateEntity() {
		return valueEntity_;
	}

	public IStatefulObject getParentObject() {
		return attribute_.getOwner();
	}

	public void commitState() {
		if (IStatefulObject.PRE_DELETED_NEW_OBJ.equals(state) || IStatefulObject.PRE_DELETED_STORED_OBJ.equals(state)) {
			attribute_.removeValue(this);
		}
		super.commitState();
	}

	public IValueModel getValueModel() {
		return valueModel_;
	}

	public IEntity addAttributeValue(URI attrType, String entityId) throws IdASException {
		throw new IdASException("");
	}

	public String toString() {
		String toStr = "";
		if (valueEntity_ != null) {
			toStr += valueEntity_.getEntityName();
		}
		else {
			toStr += "single";
			toStr += ", type :";
			try {
				toStr += attributeModel_.getType().toString();
			} catch (IdASModelException e) {
			}
		}
		
		return toStr;
	}

}
