/**
 * Copyright (c) 2008 Parity Communications, Inc. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Sergey Lyakhov - initial API and implementation
 */

package org.eclipse.higgins.idas.cp.hb.impl;

import java.net.URI;
import java.util.Iterator;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.idas.api.IValue;
import org.eclipse.higgins.idas.api.IEntity;
import org.eclipse.higgins.idas.api.ISimpleValue;
import org.eclipse.higgins.idas.api.ISingleValuedAttribute;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.api.InvalidTypeException;
import org.eclipse.higgins.idas.api.model.IAttributeModel;
import org.eclipse.higgins.idas.api.model.IEntityModel;
import org.eclipse.higgins.idas.api.model.ISimpleValueModel;
import org.eclipse.higgins.idas.cp.hb.IHibernateEntity;
import org.eclipse.higgins.idas.cp.hb.util.TypeResolver;

public class SingleValuedAttribute extends Attribute implements ISingleValuedAttribute {
	private static Log log = LogFactory.getLog(SingleValuedAttribute.class);

	protected SingleValuedAttribute(Context context, Entity entityOwner, IAttributeModel attModel) throws IdASException {
		super(context, entityOwner, attModel);
	}

	public IValue getValue() throws IdASException {
		Iterator itr = getValues();
		if (itr.hasNext()) {
			IValue res = (IValue) itr.next();
			if (itr.hasNext() == false)
				return res;
			else
				throw new IdASException("SingleValuedAttribute with type " + getType().toString() + " contains more than one value");
		} else
			return null;
	}

	public boolean isSingleValued() throws IdASException {
		return true;
	}

	public synchronized IEntity addComplexValue(URI type) throws IdASException, InvalidTypeException {
		IEntity oldValue = (IEntity)getValue();
		if (oldValue != null) {
//			throw new IdASException("SingleValuedAttribute already has value.");
			return oldValue;
		}
		if (attModel_.isSimple() == false) {
			context_.registerChangedSubject(entity_);
			IEntityModel vm = (IEntityModel)getValueModel(type);
			String attrId = context_.getTypeResolver().modelTypeToHibernateType(attModel_);
			String valueId = context_.getTypeResolver().modelTypeToHibernateType(vm);
			boolean isSingleValued = isSingleValued();
			IHibernateEntity valueEntity = getOwnerEntity().buildCollectionEntity(attrId, valueId, isSingleValued);
			Entity val = new Entity(context_, this, vm, valueEntity, false);
			values_.add(val);
			return val;
		} else
			throw new IdASException("Can not create complex value for simple attribute with type " + getType().toString());
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.idas.api.IAttribute#addSimpleValue(java.net.URI,
	 *      java.lang.Object)
	 */
	public synchronized ISimpleValue addSimpleValue(URI type, Object data) throws IdASException, InvalidTypeException {
		ISimpleValue oldVal = (ISimpleValue)getValue();
		if (oldVal != null) {
//			throw new IdASException("SingleValuedAttribute already has value.");
			oldVal.setData(data);
			return oldVal;
		}
		if (attModel_.isSimple() == true) {
			context_.registerChangedSubject(entity_);
			ISimpleValueModel vm = (ISimpleValueModel)getValueModel(type);
			if (attModel_.getAttributeMode() == IAttributeModel.SINGLE_VALUED_MODE) {
				SimpleValue sv = new SimpleValue(context_, this, null, vm, false);
				sv.setData(data);
				values_.add(sv);
				return sv;
			} else {
				String attrId = context_.getTypeResolver().modelTypeToHibernateType(attModel_);
				String valueId = attrId + TypeResolver.SIMPLE_VALUE_ENTITY_SUFIX;
				boolean isSingleValued = isSingleValued();
				IHibernateEntity valueEntity = getOwnerEntity().buildCollectionEntity(attrId, valueId, isSingleValued);
				SimpleValue sv = new SimpleValue(context_, this, valueEntity, vm, false);
				sv.setData(data);
				values_.add(sv);
				return sv;
			}
		} else
			throw new IdASException("Can not create simple value for complex attribute with type "
					+ getType().toString());
	}
}
