/**
 * Copyright (c) 2008 Parity Communications, Inc. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Sergey Lyakhov - initial API and implementation
 */

package org.eclipse.higgins.idas.cp.hb.impl;

import org.eclipse.higgins.idas.cp.hb.IStatefulObject;

public abstract class StatefulObject implements IStatefulObject {

	protected String state = NEW_OBJ;

	public StatefulObject() {
	}

	public StatefulObject(String state) {
		this.state = state;
	}

	public String getState() {
		return state;
	}

	public void setState(String state) {
		this.state = state;
	}

	protected void markChanged() {
		if (state == STORED_OBJ)
			state = CHANGED_OBJ;
	}

	protected void markDeleted() {
		if (state == NEW_OBJ)
			state = PRE_DELETED_NEW_OBJ;
		if (state == STORED_OBJ || state == CHANGED_OBJ)
			state = PRE_DELETED_STORED_OBJ;
	}

	public void commitState() {
		if (state == NEW_OBJ || state == CHANGED_OBJ)
			state = STORED_OBJ;
		else if (state == PRE_DELETED_NEW_OBJ || state == PRE_DELETED_STORED_OBJ)
			state = DELETED_OBJ;
	}

}
