/**
 * Copyright (c) 2009 Parity Communications, Inc. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Sergey Lyakhov - initial API and implementation
 */
package org.eclipse.higgins.idas.cp.hb.impl.entity;

import java.net.URI;
import java.nio.ByteBuffer;
import java.text.SimpleDateFormat;
import java.util.Date;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xerces.impl.dv.util.Base64;
import org.eclipse.higgins.idas.api.ITypedValue;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.cp.hb.IHibernateEntity;
import org.eclipse.higgins.idas.cp.hb.IHibernateEntityFactory;
import org.eclipse.higgins.idas.cp.hb.util.DatatypeMapper;
import org.hibernate.EntityMode;

public class Dom4jHibernateEntityFactory implements IHibernateEntityFactory {
	private static Log log = LogFactory.getLog(Dom4jHibernateEntityFactory.class);
	private static SimpleDateFormat dateFormat_ = new SimpleDateFormat("yyyy-MM-dd");
	private static SimpleDateFormat dateTimeFormat_ = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
	private static SimpleDateFormat timeFormat_ = new SimpleDateFormat("HH:mm:ss");

	public IHibernateEntity create(Object hibernateObject, String entityName) throws IdASException {
		// TODO Auto-generated method stub
		return null;
	}

	public Object hibernateToIdas(Object value, URI valueType) throws IdASException {
		String val = (String) value;
		if (val == null || val.trim().length() == 0)
			return null;
		else {
			try {
				String hbType = DatatypeMapper.getHibernateType(valueType.toString());
				if (DatatypeMapper.STRING_TYPE.equals(hbType)) {
					if (ITypedValue.ANYURI_TYPE_URI.equals(valueType))
						return new URI(val);
					else
						return val;
				}
				if (DatatypeMapper.DATE_TYPE.equals(hbType)) {
					Date date = dateFormat_.parse(val);
					return date;
				}
				if (DatatypeMapper.TEXT_TYPE.equals(hbType)) {
					if (ITypedValue.BASE64BINARY_TYPE_URI.equals(valueType)) {
						byte[] data = Base64.decode(val);
						if (data != null && data.length > 0) {
							ByteBuffer bb = ByteBuffer.allocate(data.length);
							bb.put(data);
							return bb;
						} else
							throw new IdASException("Invalid base64 value, can not decode");
					} else
						throw new IdASException("Unsupported mapping type");
				}
				if (DatatypeMapper.TIMESTAMP_TYPE.equals(hbType)) {
					Date date = dateTimeFormat_.parse(val);
					return date;
				}
				if (DatatypeMapper.TIME_TYPE.equals(hbType)) {
					Date date = timeFormat_.parse(val);
					return date;
				}
				if (DatatypeMapper.BINARY_TYPE.equals(hbType)) {
					byte[] bytes = Base64.decode(val);
					return bytes;
				}
				if (DatatypeMapper.INTEGER_TYPE.equals(hbType)) {
					Integer integer = Integer.valueOf(val);
					return integer;
				}
				if (DatatypeMapper.BOOLEAN_TYPE.equals(hbType)) {
					Boolean bool = Boolean.valueOf(val);
					return bool;
				}
				if (DatatypeMapper.DOUBLE_TYPE.equals(hbType)) {
					Double dbl = Double.valueOf(val);
					return dbl;
				}
				if (DatatypeMapper.FLOAT_TYPE.equals(hbType)) {
					Float flt = Float.valueOf(val);
					return flt;
				}
				if (DatatypeMapper.LONG_TYPE.equals(hbType)) {
					Long lng = Long.valueOf(val);
					return lng;
				}
				if (DatatypeMapper.SHORT_TYPE.equals(hbType)) {
					Short shrt = Short.valueOf(val);
					return shrt;
				}
				if (DatatypeMapper.LONG_TYPE.equals(hbType)) {
					Long lng = Long.valueOf(val);
					return lng;
				}
				if (DatatypeMapper.CHARACTER_TYPE.equals(hbType)) {
					return val;
				}
			} catch (Exception e) {
				log.error(e, e);
				if (e instanceof IdASException)
					throw (IdASException) e;
				else
					throw new IdASException(e);
			}
		}
		return null;
	}

	public Object idasToHibernate(Object obj, URI valueType) throws IdASException {
		if (obj == null)
			return null;
		else {
			String hbType = DatatypeMapper.getHibernateType(valueType.toString());
			if (obj instanceof Date) {
				Date value = (Date) obj;
				if (DatatypeMapper.DATE_TYPE.equals(hbType)) {
					return dateFormat_.format(value);
				} else if (DatatypeMapper.TIMESTAMP_TYPE.equals(hbType)) {
					return dateTimeFormat_.format(value);
				} else if (DatatypeMapper.TIME_TYPE.equals(hbType)) {
					return timeFormat_.format(value);
				}
			} else if (obj instanceof ByteBuffer) {
				ByteBuffer bb = (ByteBuffer) obj;
				return Base64.encode(bb.array());
			} else
				return obj.toString();
		}
		return null;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * org.eclipse.higgins.idas.cp.hb.IHibernateEntityFactory#getEntityMode()
	 */
	public EntityMode getEntityMode() {
		return EntityMode.DOM4J;
	}

}
