/**
 * Copyright (c) 2008 Parity Communications, Inc. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Sergey Lyakhov - initial API and implementation
 */
package org.eclipse.higgins.idas.cp.hb.util;

import java.util.ArrayList;
import java.util.Hashtable;

import org.eclipse.higgins.idas.api.ITypedValue;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.api.model.IdASModelException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DatatypeMapper {
	private static Log log = LogFactory.getLog(DatatypeMapper.class);
	public static final String STRING_TYPE = "string";
	public static final String BOOLEAN_TYPE = "boolean";
	public static final String INTEGER_TYPE = "integer";
	public static final String FLOAT_TYPE = "float";
	public static final String DOUBLE_TYPE = "double";
	public static final String LONG_TYPE = "long";
	public static final String SHORT_TYPE = "short";
	public static final String CHARACTER_TYPE = "character";
	public static final String BINARY_TYPE = "binary";
	public static final String DATE_TYPE = "date";
	public static final String TIMESTAMP_TYPE = "timestamp";
	public static final String TIME_TYPE = "time";
	public static final String TEXT_TYPE = "text";
	public static final String BLOB_TYPE = "blob";	
	
	private static Hashtable xmlToJavas_ = new Hashtable();
	private static Hashtable xmlToDefaultJava_ = new Hashtable();
	private static Hashtable xmlToHibernate_ = new Hashtable();

	public static String getJavatypeByXML(String xmlType) {
		if (xmlToDefaultJava_.contains(xmlType))
			return (String) xmlToDefaultJava_.get(xmlType);
		else
			return null;
	}

	public static boolean isCorrectType(String xmlType, Object value) throws IdASException {
		if (xmlType == null)
			throw new IdASModelException("Parameter \"xmlType\" is null.");
		if (value == null)
			return true;
		if (xmlToJavas_.containsKey(xmlType)) {
			ArrayList classes = (ArrayList) xmlToJavas_.get(xmlType);
			for (int i = 0, k = classes.size(); i < k; i++) {
				Class clazz = (Class)classes.get(i);
				if (clazz.isInstance(value))
					return true;
			}
			return false;
		} else
			throw new IdASModelException("Unknown XML type :" + xmlType);
	}

	public static String getHibernateType(String xmlType) throws IdASException {
		if (xmlType == null)
			throw new IdASModelException("Parameter \"xmlType\" is null.");
		if (xmlToHibernate_.containsKey(xmlType))
			return (String) xmlToHibernate_.get(xmlType);
		else
			throw new IdASModelException("Unknown XML type :" + xmlType);
	}

	static {
		String[][] str = ITypedValue.typeMap;
		for (int i = 0, k = str.length; i < k; i++) {
			String xmlName = str[i][0];
			String javaName = str[i][1];
			Class cls = null;
			try {
	            cls = Class.forName(javaName);
            } catch (ClassNotFoundException e) {
	            log.error(e,e);
            }
			ArrayList javaClasses = null;
			if (xmlToJavas_.containsKey(xmlName)) {
				javaClasses = (ArrayList) xmlToJavas_.get(xmlName);
			} else {
				javaClasses = new ArrayList();
				xmlToJavas_.put(xmlName, javaClasses);
			}
			if (javaClasses.contains(cls) == false)
				javaClasses.add(cls);
			if (xmlToDefaultJava_.contains(xmlName) == false)
				xmlToDefaultJava_.put(xmlName, javaName);
		}
		// / INIT hibernate mapping
		xmlToHibernate_.put(ITypedValue.STRING_ATTR_VALUE_TYPE_URI_STR, STRING_TYPE);
		xmlToHibernate_.put(ITypedValue.NORMALIZEDSTRING_ATTR_VALUE_TYPE_URI_STR, STRING_TYPE);
		xmlToHibernate_.put(ITypedValue.BOOLEAN_ATTR_VALUE_TYPE_URI_STR, BOOLEAN_TYPE);
		xmlToHibernate_.put(ITypedValue.DECIMAL_ATTR_VALUE_TYPE_URI_STR, INTEGER_TYPE);
		xmlToHibernate_.put(ITypedValue.INTEGER_ATTR_VALUE_TYPE_URI_STR, INTEGER_TYPE);
		xmlToHibernate_.put(ITypedValue.NONNEGATIVEINTEGER_ATTR_VALUE_TYPE_URI_STR, INTEGER_TYPE);
		xmlToHibernate_.put(ITypedValue.POSITIVEINTEGER_ATTR_VALUE_TYPE_URI_STR, INTEGER_TYPE);
		xmlToHibernate_.put(ITypedValue.NONPOSITIVEINTEGER_ATTR_VALUE_TYPE_URI_STR, INTEGER_TYPE);
		xmlToHibernate_.put(ITypedValue.NEGATIVEINTEGER_ATTR_VALUE_TYPE_URI_STR, INTEGER_TYPE);
		xmlToHibernate_.put(ITypedValue.FLOAT_ATTR_VALUE_TYPE_URI_STR, FLOAT_TYPE);
		xmlToHibernate_.put(ITypedValue.DOUBLE_ATTR_VALUE_TYPE_URI_STR, DOUBLE_TYPE);
		xmlToHibernate_.put(ITypedValue.LONG_ATTR_VALUE_TYPE_URI_STR, LONG_TYPE);
		xmlToHibernate_.put(ITypedValue.INT_ATTR_VALUE_TYPE_URI_STR, INTEGER_TYPE);
		xmlToHibernate_.put(ITypedValue.SHORT_ATTR_VALUE_TYPE_URI_STR, SHORT_TYPE);
		xmlToHibernate_.put(ITypedValue.BYTE_ATTR_VALUE_TYPE_URI_STR, CHARACTER_TYPE);
		xmlToHibernate_.put(ITypedValue.UNSIGNEDLONG_ATTR_VALUE_TYPE_URI_STR, INTEGER_TYPE);
		xmlToHibernate_.put(ITypedValue.UNSIGNEDINT_ATTR_VALUE_TYPE_URI_STR, INTEGER_TYPE);
		xmlToHibernate_.put(ITypedValue.UNSIGNEDSHORT_ATTR_VALUE_TYPE_URI_STR, INTEGER_TYPE);
		xmlToHibernate_.put(ITypedValue.UNSIGNEDBYTE_ATTR_VALUE_TYPE_URI_STR, INTEGER_TYPE);
		xmlToHibernate_.put(ITypedValue.BASE64BINARY_ATTR_VALUE_TYPE_URI_STR, BLOB_TYPE);
		xmlToHibernate_.put(ITypedValue.HEXBINARY_ATTR_VALUE_TYPE_URI_STR, BINARY_TYPE);
		xmlToHibernate_.put(ITypedValue.DATETIME_ATTR_VALUE_TYPE_URI_STR, TIMESTAMP_TYPE);
		xmlToHibernate_.put(ITypedValue.TIME_ATTR_VALUE_TYPE_URI_STR, TIME_TYPE);
		xmlToHibernate_.put(ITypedValue.DATE_ATTR_VALUE_TYPE_URI_STR, DATE_TYPE);
		xmlToHibernate_.put(ITypedValue.GYEARMONTH_ATTR_VALUE_TYPE_URI_STR, DATE_TYPE);
		xmlToHibernate_.put(ITypedValue.GYEAR_ATTR_VALUE_TYPE_URI_STR, DATE_TYPE);
		xmlToHibernate_.put(ITypedValue.GMONTHDAY_ATTR_VALUE_TYPE_URI_STR, DATE_TYPE);
		xmlToHibernate_.put(ITypedValue.GDAY_ATTR_VALUE_TYPE_URI_STR, DATE_TYPE);
		xmlToHibernate_.put(ITypedValue.GMONTH_ATTR_VALUE_TYPE_URI_STR, DATE_TYPE);
		xmlToHibernate_.put(ITypedValue.ANYURI_ATTR_VALUE_TYPE_URI_STR, STRING_TYPE);
		xmlToHibernate_.put(ITypedValue.TOKEN_ATTR_VALUE_TYPE_URI_STR, STRING_TYPE);
		xmlToHibernate_.put(ITypedValue.LANGUAGE_ATTR_VALUE_TYPE_URI_STR, STRING_TYPE);
		xmlToHibernate_.put(ITypedValue.NMTOKEN_ATTR_VALUE_TYPE_URI_STR, STRING_TYPE);
		xmlToHibernate_.put(ITypedValue.NAME_ATTR_VALUE_TYPE_URI_STR, STRING_TYPE);
		xmlToHibernate_.put(ITypedValue.NCNAME_ATTR_VALUE_TYPE_URI_STR, STRING_TYPE);
	}

}
