/**
 * Copyright (c) 2009 Parity Communications, Inc. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Sergey Lyakhov - initial API and implementation
 */
package org.eclipse.higgins.idas.cp.hb.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.eclipse.higgins.idas.api.IValue;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.cp.hb.IHibernateEntity;
import org.eclipse.higgins.idas.cp.hb.IStatefulObject;
import org.eclipse.higgins.idas.cp.hb.impl.Attribute;
import org.eclipse.higgins.idas.cp.hb.impl.Entity;
import org.eclipse.higgins.idas.cp.hb.impl.SimpleValue;
import org.hibernate.Session;

public class SessionContext {
	ArrayList newElements = null;
	ArrayList changedElements = null;
	ArrayList deletedElements = null;
	Session session;
	
	List entityList;

	public void updateEntity(Session session, List entities) throws IdASException {
		newElements = new ArrayList();
		changedElements = new ArrayList();
		deletedElements = new ArrayList();
		this.session = session;
		this.entityList = entities;
		processEntities();
		updateEntities();
	}

	private void updateEntities() throws IdASException {
		for (int i = newElements.size() - 1; i > -1; i--) {
			IStatefulObject se = (IStatefulObject) newElements.get(i);
			IHibernateEntity he = se.getHibernateEntity();
			session.save(he.getEntityName(), he.getEntityObject());
		}
		for (int i = deletedElements.size() - 1; i > -1; i--) {
			IStatefulObject se = (IStatefulObject) deletedElements.get(i);
			session.delete(se.getHibernateEntity().getEntityObject());
		}
		for (int i = changedElements.size() - 1; i > -1; i--) {
			IStatefulObject se = (IStatefulObject) changedElements.get(i);
			session.update(se.getHibernateEntity().getEntityObject());
		}
	}

	private void processEntities() throws IdASException {
		for (int i = 0, s = entityList.size(); i < s; i++) {
			Entity entity = (Entity)entityList.get(i);
			processSessionEntity(entity);
			Iterator attrs = entity.getAttributes();
			processAttributes(attrs);
		}
	}

	private void processAttributes(Iterator attrs) throws IdASException {
		while (attrs.hasNext()) {
			Attribute attr = (Attribute) attrs.next();
			Iterator vals = attr.getInternalValues().iterator();
			while (vals.hasNext()) {
				IValue val = (IValue) vals.next();
				if (val.isSimple()) {
					processSimpleValue((SimpleValue) val);
				} else {
//					processComplexValue((Entity) val);
				}
			}
		}
	}

//	private void processComplexValue(Entity val) throws IdASException {
//		processSessionEntity(val);
//		Iterator attrs = val.getAttributes();
//		processAttributes(attrs);
//	}

	private void processSimpleValue(SimpleValue sv) {
		if (sv.getHibernateEntity() != null) {
			// value of multivalued simple attribute has hibernate entity
			processSessionEntity(sv);
		}
	}

	private void processSessionEntity(IStatefulObject se) {
		IStatefulObject parent = se.getParentObject();
		if (IStatefulObject.NEW_OBJ.equals(se.getState())) {
			if (!newElements.contains(se)) {
				newElements.add(se);
				updateParent(parent);
			}
		}
		else if (IStatefulObject.PRE_DELETED_STORED_OBJ.equals(se.getState())) {
			if (!deletedElements.contains(se)) {
				deletedElements.add(se);
				updateParent(parent);
			}
		}
		else if (IStatefulObject.CHANGED_OBJ.equals(se.getState())) {
			if (!changedElements.contains(se)) {
				changedElements.add(se);
			}
		}
	}

	private void updateParent(IStatefulObject parent) {
		if (parent != null && IStatefulObject.STORED_OBJ.equals(parent.getState())) {
			if (!changedElements.contains(parent)) {
				changedElements.add(parent);
			}
		}
	}
	
}
