/**
 * Copyright (c) 2009 Parity Communications, Inc. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Sergey Lyakhov - initial API and implementation
 */
package org.eclipse.higgins.idas.cp.hb.util;

import java.net.URI;
import java.util.HashMap;

import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.api.model.IModel;
import org.eclipse.higgins.idas.api.model.IdASModelException;

public class TypeResolver {

	public static final String SIMPLE_VALUE_ENTITY_SUFIX = "_list";

	private HashMap modelType2HibernateType = new HashMap();

	private HashMap hibernateType2ModelType = new HashMap();

	private URI ppidOwnerEntityType;

	public TypeResolver() {
	}

	public String modelTypeToHibernateType(IModel model) throws IdASException {
		return modelTypeToHibernateType(model.getType());
	}

	public String modelTypeToHibernateType(URI modelType) throws IdASException {
		if (modelType2HibernateType.containsKey(modelType)) {
			return (String) modelType2HibernateType.get(modelType);
		} else
			throw new IdASException("Context model does not contain any model with type " + modelType);
	}

	public URI hibernateTypeToModelType(String hibernateType) throws IdASException {
		if (hibernateType2ModelType.containsKey(hibernateType)) {
			return (URI) hibernateType2ModelType.get(hibernateType);
		} else
			throw new IdASException("Can not find model by hibernate type " + hibernateType);
	}

	public URI getPpidOwnerEntityType() {
		return ppidOwnerEntityType;
	}

	public void setPpidOwnerEntityType(URI entityType) {
		ppidOwnerEntityType = entityType;
	}

	public String getHibernateType(IModel model) throws IdASModelException {
		URI modelType = model.getType();
		String hibernateType = escapeDbNameSymbols(model.getShortFormType());
		hibernateType2ModelType.put(hibernateType, modelType);
		modelType2HibernateType.put(modelType, hibernateType);
		return hibernateType;
	}

	private String escapeDbNameSymbols(String dbName) {
		return dbName.replaceAll(":", "_").replaceAll("-", "_");
	}

}
