/**
 * Copyright (c) 2007 Novell, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *		Tom Doman
 */

package org.eclipse.higgins.idas.cp.inmem;

import java.security.Provider;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
* @author tdoman@novell.com
*/

public final class InMemoryContextFactoryProvider extends Provider
{
	private Log	 log = LogFactory.getLog(InMemoryContextFactoryProvider.class.getName());
	private static final long serialVersionUID = 1L;

	public InMemoryContextFactoryProvider()
	{
		super("InMemoryHigginsProvider", 1.0, "InMemory provider for Higgins ContextFactory objects.");
		log.debug("InMemory Context Factory Provider instantiated");
		put("ContextFactory.Higgins.InMemory", "org.eclipse.higgins.idas.cp.inmem.InMemoryContextFactory");
	}
}
