/**
 * Copyright (c) 2006-2007 Novell, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *		Tom Doman
 *		Jim Sermersheim
 *		Duane Buss
 */

package org.eclipse.higgins.idas.cp.inmem;

import java.net.URI;
import java.util.HashMap;
import java.util.Iterator;

import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Logger;
import org.apache.log4j.varia.NullAppender;
import org.bandit.util.misc.CIStringKey;
import org.eclipse.higgins.idas.api.ContextNotOpenException;
import org.eclipse.higgins.idas.api.ContextOpenException;
import org.eclipse.higgins.idas.api.IContextId;
import org.eclipse.higgins.idas.api.IEntity;
import org.eclipse.higgins.idas.api.IFilter;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.api.InvalidEntityIDException;
import org.eclipse.higgins.idas.api.InvalidTypeException;
import org.eclipse.higgins.idas.api.NoSuchEntityException;
import org.eclipse.higgins.idas.api.NotImplementedException;
import org.eclipse.higgins.idas.api.EntityExistsException;
import org.eclipse.higgins.idas.spi.BasicContext;
import org.eclipse.higgins.idas.spi.IEntityContainer;
import org.eclipse.higgins.idas.spi.EntityNotification;

/**
 * An implementation of a <a href="http://www.eclipse.org/higgins/">Higgins</a>.
 * Context Provider which is intended for use when Entities are being
 * manufactored on the fly or need to be cached privatly.
 * 
 * Please see the Samples section for one usage of creating Entities
 * from SAML assertions, then allowing interfaces which require Entities
 * to manipulate the InMemory Entity.
 * 
 * @author jimse@novell.com
 * @author tdoman@novell.com
 * @author dbuss@novell.com
 */

public class InMemoryContext extends BasicContext implements IEntityContainer
{
	// private Logger _log = Logger.getLogger(InMemoryContext.class.getName());
	// private Hashtable<String, Object> _env;
//	private IContextId _contextID;
	private boolean _bIsOpen;
	private HashMap _idHashMap;

	/**
	 */
	public InMemoryContext(
			IContextId contextID) throws IdASException
	{
	//	_contextID = contextID;
		if (!Logger.getRootLogger().getAllAppenders().hasMoreElements())
			BasicConfigurator.configure(new NullAppender());
		// _env = new Hashtable<String, Object>();
		_bIsOpen = false;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.idas.api.IContext#open(java.lang.Object)
	 */
	public String open(
		Object unknown) throws IdASException
	{
		if (_bIsOpen)
			throw new ContextOpenException();

		_bIsOpen = true;

		// TODO: return entityID
		return null;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.idas.api.IContext#close()
	 */
	public void close() throws IdASException
	{
		if (!_bIsOpen)
			throw new ContextNotOpenException();

		if (_idHashMap != null)
			_idHashMap.clear();
		_idHashMap = null;
		_bIsOpen = false;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.idas.api.IContext#isOpen(java.lang.Object)
	 */
	public boolean isOpen(
		Object identity) throws IdASException
	{
		return _bIsOpen;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.idas.api.IContext#getSchema()
	 */
	public String getSchema() throws IdASException
	{
		if (!_bIsOpen)
			throw new ContextNotOpenException();

		throw new NotImplementedException();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.idas.api.IContext#exportData(java.lang.String,
	 *      java.lang.String)
	 */
	public String exportData(
		String arg0,
		String arg1) throws IdASException
	{
		throw new NotImplementedException();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.idas.api.IContext#importData(java.lang.String,
	 *      java.lang.String)
	 */
	public void importData(
		String arg0,
		String arg1) throws IdASException
	{
		throw new NotImplementedException();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.idas.api.IContext#getEntity(java.lang.String)
	 */
	public IEntity getEntity(
		String entityID) throws IdASException
	{
		return getEntity(entityID, null);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.idas.api.IContext#getEntity(java.lang.String,
	 *      java.util.Iterator)
	 */
	public IEntity getEntity(
		String entityID,
		Iterator attrSelectionList) throws IdASException
	{
		if (!_bIsOpen)
			throw new ContextNotOpenException();

		CIStringKey idKey = new CIStringKey(entityID);

		// TODO: filter things not in attrSelectionList
		if (_idHashMap == null)
			throw new NoSuchEntityException("No such entity: " + idKey);

		IEntity ds = (IEntity) _idHashMap.get(idKey);
		if (ds == null)
			throw new NoSuchEntityException("No such entity: " + idKey);
		return ds;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.idas.api.IContext#getEntities(org.eclipse.higgins.idas.api.IFilter)
	 */
	public Iterator getEntities(
		IFilter filter) throws IdASException
	{
		return getEntities(filter, null);
	}

	/**
	 */
	public Iterator getEntities(
		IFilter filter,
		Iterator attrSelectionList) throws IdASException
	{
		if (!_bIsOpen)
			throw new ContextNotOpenException();

		throw new NotImplementedException();
	}

	/*
	 * 
	 */
	private void _addEntity(
		String entityID,
		IEntity ds)
	{

		CIStringKey idKey = new CIStringKey(entityID);
		if (_idHashMap == null)
			_idHashMap = new HashMap();
		_idHashMap.put(idKey, ds);
	}

	/*
	 * (non-Javadoc)
	 * @see org.eclipse.higgins.idas.spi.BasicContext# addEntity(java.net.URI, java.lang.String)
	 */
	public IEntity addEntity(URI type, String entityID) throws IdASException, InvalidTypeException, InvalidEntityIDException, EntityExistsException 
	{
		if (!_bIsOpen)
			throw new ContextNotOpenException();
		
		IEntity ds = new InMemoryEntity(this, type, entityID);

		_addEntity(entityID, ds);
		return ds;
	}

	/*
	 * (non-Javadoc)
	 * @see org.eclipse.higgins.idas.spi.BasicContext#addEntity(org.eclipse.higgins.idas.api.IEntity)
	 */
	public IEntity addEntity(IEntity copyFrom) throws IdASException, EntityExistsException 
	{
		if (!_bIsOpen)
			throw new ContextNotOpenException();
		
		throw new NotImplementedException();
	}
	
	public void applyUpdates() throws IdASException
	{
		// Objects are in-mem and always updated real-time
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.idas.api.IContext#verifyEntityAttributes(java.lang.String,
	 *      java.util.Iterator)
	 */
	public boolean verifyEntityAttributes(
		String arg0,
		Iterator arg1) throws IdASException
	{
		if (!_bIsOpen)
			throw new ContextNotOpenException();

		throw new NotImplementedException();
	}

	public void updateNotification(EntityNotification entityNotif) throws IdASException {
		if (entityNotif.getAction().equals(EntityNotification.UPDATE_REMOVE)) {
			CIStringKey idKey = new CIStringKey(entityNotif.getEntity().getEntityID());
			if (_idHashMap != null)
				_idHashMap.remove(idKey);
		}
		// AFAIK, we don't need to deal with any other update notifications
	}
}
