/**
 * Copyright (c) 2006-2007 Novell, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *		Tom Doman
 *		Jim Sermersheim
 *		Duane Buss
 */

package org.eclipse.higgins.idas.cp.inmem;

import java.net.URI;
import java.util.Iterator;

import org.eclipse.higgins.idas.api.IEntity;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.api.NotImplementedException;
import org.eclipse.higgins.idas.api.model.IEntityModel;
import org.eclipse.higgins.idas.spi.AttributeNotification;
import org.eclipse.higgins.idas.spi.BasicEntity;
import org.eclipse.higgins.idas.spi.IEntityContainer;
import org.eclipse.higgins.idas.spi.MetadataNotification;
import org.eclipse.higgins.idas.spi.EntityNotification;

/**
* An implementation of a 
* <a href="http://www.eclipse.org/higgins/">Higgins</a>.
*  Entity for the InMemory/Mapping Context Provider
*  which is intended for use when Entities 
*  are being manufactured on the fly or need to be cached privately.  
*  
* Please see the Samples section for one usage of creating Entities 
* from SAML assertions, then allowing interfaces which require 
* Entities to manipulate the InMemory Entity.

* @author jimse@novell.com
* @author tdoman@novell.com
* @author dbuss@novell.com
*/

public class InMemoryEntity extends BasicEntity implements IEntity
{
	private IEntityContainer _container;
	
	public InMemoryEntity(
			InMemoryContext container,
			URI type,
			String entityId
		) throws IdASException
	{
		super(container, type, entityId);
		_container = container;
	}
	
	/**
	 */
	public InMemoryEntity(
		InMemoryContext container,
		URI type,
		String entityID,
		Iterator attributes,
		Iterator metadata) throws IdASException
	{
		super(container, type, entityID, attributes, metadata);
		_container = container;
	}

	public void remove() throws IdASException {
		EntityNotification entityNotif = new EntityNotification(this, EntityNotification.UPDATE_REMOVE, null, null);
		_container.updateNotification(entityNotif);
	}

	public void updateNotification(AttributeNotification attrNotif) throws IdASException {
		// AFAIK, everything is happening in memory, so no notifications need to happen
	}

	public void updateNotification(MetadataNotification metaNotif) throws IdASException {
		// AFAIK, everything is happening in memory, so no notifications need to happen
	}

}
