/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.idas.cp.jena2.impl;

import com.hp.hpl.jena.ontology.OntDocumentManager;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.idas.api.IContext;
import org.eclipse.higgins.idas.api.IContextFactory;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.cp.jena2.IContextConfiguration;
import org.eclipse.higgins.idas.cp.jena2.IFactoryConfiguration;
import org.eclipse.higgins.idas.model.impl.ContextModel;

public abstract class AbstractContextFactory
implements IContextFactory {
    private static Log log = LogFactory.getLog((Class)(class$org$eclipse$higgins$idas$cp$jena2$impl$AbstractContextFactory == null ? (class$org$eclipse$higgins$idas$cp$jena2$impl$AbstractContextFactory = AbstractContextFactory.class$("org.eclipse.higgins.idas.cp.jena2.impl.AbstractContextFactory")) : class$org$eclipse$higgins$idas$cp$jena2$impl$AbstractContextFactory));
    protected String id = null;
    protected String name = null;
    protected String policy = null;
    protected File configFile = null;
    protected IFactoryConfiguration config = null;
    protected String cacheLocation = null;
    protected OntDocumentManager documentManager = null;
    private static HashMap models = new HashMap();
    static /* synthetic */ Class class$org$eclipse$higgins$idas$cp$jena2$impl$AbstractContextFactory;

    protected AbstractContextFactory(String id, String name) throws IdASException {
        log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.AbstractContextFactory::AbstractContextFactory");
        this.setID(id);
        this.setName(name);
    }

    public String getID() throws IdASException {
        log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.AbstractContextFactory::getID");
        return this.id;
    }

    protected void setID(String id) {
        log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.AbstractContextFactory::setID");
        this.id = id;
    }

    public String getName() throws IdASException {
        log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.AbstractContextFactory::getName");
        if (this.config != null) {
            return this.name;
        }
        throw new IdASException("Factory hasn't been initialized yet.");
    }

    protected void setName(String name) {
        log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.AbstractContextFactory::setName");
        this.name = name;
    }

    public void initialize(File configFile) throws IdASException {
    }

    public void destroyContext(URI contextID) throws IdASException {
        log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.AbstractContextFactory::destroyContext");
        if (this.config != null) {
            if (this.config.getContextConfig(contextID) != null) {
                this.config.removeContextConfig(contextID);
            }
        } else {
            throw new IdASException("Factory hasn't been initialized yet.");
        }
    }

    public List getConfigPropNames() throws IdASException {
        log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.AbstractContextFactory::getConfigPropNames");
        if (this.config != null) {
            ArrayList<String> list = new ArrayList<String>();
            Enumeration<?> e = this.config.getDefaultProperties().propertyNames();
            while (e.hasMoreElements()) {
                String s = (String)e.nextElement();
                list.add(s);
            }
            return list;
        }
        throw new IdASException("Factory hasn't been initialized yet.");
    }

    public Properties getDefaultConfig() throws IdASException {
        log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.AbstractContextFactory::getDefaultConfig");
        if (this.config != null) {
            return this.config.getDefaultProperties();
        }
        throw new IdASException("Factory hasn't been initialized yet.");
    }

    public boolean canCreate(URI contextID, Properties configData) throws IdASException {
        log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.AbstractContextFactory::canCreate(URI, Properties)");
        if (this.config != null) {
            if (this.config.getContextConfig(contextID) != null) {
                throw new IdASException("Context " + contextID + " is already configured with different configuration data.");
            }
            return this.isValidProperties(configData);
        }
        throw new IdASException("Factory hasn't been initialized yet.");
    }

    public boolean canCreate(URI contextID) throws IdASException {
        log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.AbstractContextFactory::canCreate(URI)");
        if (this.config != null) {
            return this.config.getContextConfig(contextID) != null;
        }
        throw new IdASException("Factory hasn't been initialized yet.");
    }

    protected abstract IContext createContext(IContextConfiguration var1) throws IdASException;

    public IContext createContext(URI contextID, Properties configData) throws IdASException {
        log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.AbstractContextFactory::createContext(URI, Properties)");
        IContext ctx = null;
        if (this.config != null) {
            IContextConfiguration cfg = this.config.getContextConfig(contextID);
            if (cfg != null) {
                throw new IdASException("Context " + contextID + " is already configured with different configuration data.");
            }
            if (!this.isValidProperties(configData)) {
                throw new IdASException("Context " + contextID + " couldn't be created - invalid configuration data.");
            }
            cfg = this.config.createContextConfig(contextID, configData);
            ctx = this.createContext(cfg);
            if (ctx != null) {
                this.config.setContextConfig(cfg);
                this.config.save(this.configFile);
            }
        } else {
            throw new IdASException("Factory hasn't been initialized yet.");
        }
        return ctx;
    }

    public IContext createContext(URI contextID) throws IdASException {
        IContextConfiguration cfg;
        log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.AbstractContextFactory::createContext(URI)");
        IContext ctx = null;
        if (this.config != null) {
            cfg = this.config.getContextConfig(contextID);
            if (cfg == null) {
                // empty if block
            }
            if (cfg == null) {
                throw new IdASException("Context " + contextID + "couldn't be created - can't find configuration data.");
            }
        } else {
            throw new IdASException("Factory hasn't been initialized properly.");
        }
        ctx = this.createContext(cfg);
        return ctx;
    }

    public Iterator getContexts(String filter) throws IdASException {
        log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.AbstractContextFactory::getContexts");
        if (this.config != null) {
            return this.config.getContextIDs().iterator();
        }
        throw new IdASException("Factory hasn't been initialized properly.");
    }

    public String getPolicy() throws IdASException {
        log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.AbstractContextFactory::getPolicy");
        return this.policy;
    }

    public void setPolicy(String policy) throws IdASException {
        log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.AbstractContextFactory::setPolicy");
        this.policy = policy;
    }

    protected boolean isValidProperties(Properties props) {
        log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.AbstractContextFactory::isValidProperties");
        boolean res = false;
        if (this.config != null) {
            res = true;
            Properties defaults = this.config.getDefaultProperties();
            Iterator<Object> itr = props.keySet().iterator();
            while (itr.hasNext()) {
                if (defaults.containsKey(itr.next())) continue;
                res = false;
                break;
            }
        }
        return res;
    }

    public static synchronized ContextModel getContextModel(String schemaResource, String schemaURI) throws IdASException {
        if (models.containsKey(schemaURI)) {
            return (ContextModel)models.get(schemaURI);
        }
        ContextModel cm = AbstractContextFactory.createContextModel(schemaResource, schemaURI);
        models.put(schemaURI, cm);
        return cm;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static synchronized ContextModel createContextModel(String schemaResource, String schemaURI) throws IdASException {
        Object schemaURL;
        InputStream is = null;
        OntModel model = null;
        AbstractContextFactory.initHiggisBaseModel();
        try {
            try {
                File fileSchema;
                is = Thread.currentThread().getContextClassLoader().getResourceAsStream(schemaResource);
                if (is == null && (fileSchema = new File(schemaResource)).exists() && fileSchema.isFile()) {
                    is = new FileInputStream(fileSchema);
                }
                if (is == null) {
                    schemaURL = new URL(schemaResource);
                    is = ((URL)schemaURL).openStream();
                }
                if (is == null) {
                    schemaURL = new URL(schemaURI);
                    is = ((URL)schemaURL).openStream();
                }
                if (is == null) {
                    throw new IdASException("Can not get schema input stream");
                }
                model = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
                model.read(is, schemaURI);
                schemaURL = new ContextModel(model, new URI(schemaURI));
            }
            catch (IdASException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IdASException((Throwable)e);
            }
            Object var6_7 = null;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            try {
                if (is == null) throw throwable;
                is.close();
                throw throwable;
            }
            catch (IOException e) {
                throw throwable;
            }
        }
        try {}
        catch (IOException e) {
            // empty catch block
            return schemaURL;
        }
        if (is == null) return schemaURL;
        is.close();
        return schemaURL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static synchronized void initHiggisBaseModel() throws IdASException {
        InputStream is;
        block8: {
            OntDocumentManager dm = OntDocumentManager.getInstance();
            if (dm.getModel("http://www.eclipse.org/higgins/ontologies/2008/6/higgins") != null) return;
            is = null;
            is = Thread.currentThread().getContextClassLoader().getResourceAsStream("org/eclipse/higgins/idas/cp/model/higgins.owl");
            if (is == null) break block8;
            OntModel modelHiggins = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
            modelHiggins.read(is, "http://www.eclipse.org/higgins/ontologies/2008/6/higgins");
            if (modelHiggins.isEmpty()) break block8;
            dm.addModel("http://www.eclipse.org/higgins/ontologies/2008/6/higgins", (Model)modelHiggins);
        }
        Object var4_4 = null;
        if (is == null) return;
        try {
            is.close();
            return;
        }
        catch (IOException e2) {}
        return;
        {
            catch (Exception e) {
                log.warn((Object)e, (Throwable)e);
                Object var4_5 = null;
                if (is == null) return;
                try {
                    is.close();
                    return;
                }
                catch (IOException e2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            if (is == null) throw throwable;
            try {
                is.close();
                throw throwable;
            }
            catch (IOException e2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

