/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.idas.cp.jena2.impl;

import com.hp.hpl.jena.ontology.Individual;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntProperty;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.NodeIterator;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.idas.api.IAttribute;
import org.eclipse.higgins.idas.api.IAttributeValue;
import org.eclipse.higgins.idas.api.IComplexAttrValue;
import org.eclipse.higgins.idas.api.IExtension;
import org.eclipse.higgins.idas.api.IHasAttributes;
import org.eclipse.higgins.idas.api.ISimpleAttrValue;
import org.eclipse.higgins.idas.api.ISingleValuedAttribute;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.api.InvalidTypeException;
import org.eclipse.higgins.idas.api.NotSingleValuedAttributeException;
import org.eclipse.higgins.idas.api.UnhandledExtensionException;
import org.eclipse.higgins.idas.api.model.IAttributeModel;
import org.eclipse.higgins.idas.api.model.IAttributeValueModel;
import org.eclipse.higgins.idas.api.model.IdASModelException;
import org.eclipse.higgins.idas.cp.jena2.impl.ComplexValue;
import org.eclipse.higgins.idas.cp.jena2.impl.Context;
import org.eclipse.higgins.idas.cp.jena2.impl.Entity;
import org.eclipse.higgins.idas.cp.jena2.impl.SimpleValue;
import org.eclipse.higgins.idas.cp.jena2.util.ModelUtils;

public class Attribute
implements IAttribute {
    private Log log = LogFactory.getLog((Class)(class$org$eclipse$higgins$idas$cp$jena2$impl$Attribute == null ? (class$org$eclipse$higgins$idas$cp$jena2$impl$Attribute = Attribute.class$("org.eclipse.higgins.idas.cp.jena2.impl.Attribute")) : class$org$eclipse$higgins$idas$cp$jena2$impl$Attribute));
    protected OntProperty property_ = null;
    protected Context context_ = null;
    protected IAttributeModel attModel_ = null;
    protected OntClass ownerClass_ = null;
    protected OntClass complexValueClass_ = null;
    protected boolean isSimple_ = false;
    protected Entity subject_ = null;
    protected Individual owner_ = null;
    static /* synthetic */ Class class$org$eclipse$higgins$idas$cp$jena2$impl$Attribute;
    static /* synthetic */ Class class$com$hp$hpl$jena$rdf$model$Literal;
    static /* synthetic */ Class class$com$hp$hpl$jena$ontology$Individual;

    protected Attribute(Context context, Entity subject, OntProperty property, IAttributeModel model) throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.Attribute::Attribute(..., Entity, ...)");
        if (subject == null) {
            throw new IdASException("Parameter \"subject\" is null.");
        }
        this.subject_ = subject;
        this.init(context, subject.getSubjectIndividual(), property, model);
    }

    protected Attribute(Context context, ComplexValue valueOwner, OntProperty property, IAttributeModel model) throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.Attribute::Attribute(..., ComplexValue, ...)");
        if (valueOwner == null) {
            throw new IdASException("Parameter \"valueOwner\" is null.");
        }
        this.subject_ = valueOwner.getSubjectOwner();
        this.init(context, valueOwner.getValueIndividual(), property, model);
    }

    private void init(Context context, Individual owner, OntProperty property, IAttributeModel model) throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.Attribute::init");
        if (context == null) {
            throw new IdASException("Parameter \"context\" is null.");
        }
        if (owner == null) {
            throw new IdASException("Parameter \"owner\" is null.");
        }
        if (property == null) {
            throw new IdASException("Parameter \"property\" is null.");
        }
        this.context_ = context;
        this.owner_ = owner;
        this.property_ = property;
        this.ownerClass_ = this.context_.getOntClass(this.owner_.getRDFType().getURI());
        this.attModel_ = model;
        this.isSimple_ = this.attModel_.getValueModel().isSimple();
    }

    protected OntClass getComplexValueClass() throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.Attribute::getComplexValueClass");
        if (this.complexValueClass_ == null) {
            IAttributeValueModel valueModel = this.attModel_.getValueModel();
            if (valueModel.isSimple()) {
                throw new IdASModelException("Attribute " + this.attModel_.getType().toString() + " is not complex.");
            }
            String cvClassURI = valueModel.getType().toString();
            this.complexValueClass_ = this.context_.getOntClass(cvClassURI);
            if (this.complexValueClass_ == null) {
                throw new IdASException("Can not find class with URI " + cvClassURI);
            }
        }
        return this.complexValueClass_;
    }

    public Individual getOwner() {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.Attribute::getOwner");
        return this.owner_;
    }

    public OntClass getOwnerClass() {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.Attribute::getOwnerClass");
        return this.ownerClass_;
    }

    public Entity getSubjectOwner() {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.Attribute::getSubjectOwner");
        return this.subject_;
    }

    public Entity getAttributeProperty() {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.Attribute::getSubjectOwner");
        return this.subject_;
    }

    public IComplexAttrValue addComplexValue(URI type) throws IdASException, InvalidTypeException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.Attribute::addComplexValue");
        if (!this.isSimple_) {
            OntClass cvClass = this.getComplexValueClass();
            this.context_.registerChangedSubject(this.subject_);
            Individual newValue = this.context_.getModel().createIndividual((Resource)cvClass);
            this.owner_.addProperty((Property)this.property_, (RDFNode)newValue);
            return new ComplexValue(this.context_, this, newValue, this.property_);
        }
        throw new IdASException("Can not create complex value for simple attribute with type " + this.getAttrID().toString());
    }

    public ISimpleAttrValue addSimpleValue(URI type, Object data) throws IdASException, InvalidTypeException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.Attribute::addSimpleValue");
        if (this.isSimple_) {
            this.context_.registerChangedSubject(this.subject_);
            SimpleValue sv = new SimpleValue(this.context_, this, this.owner_, this.property_.asDatatypeProperty(), null);
            sv.setData(data);
            return sv;
        }
        throw new IdASException("Can not create simple value for complex attribute with type " + this.getAttrID().toString());
    }

    public IAttributeValue addValue(URI type) throws IdASException, InvalidTypeException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.Attribute::addValue(URI)");
        if (this.isSimple_) {
            return this.addSimpleValue(type, null);
        }
        return this.addComplexValue(type);
    }

    public IAttributeValue addValue(IAttributeValue copyFrom) throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.Attribute::addValue");
        if (copyFrom == null) {
            throw new IdASException("Parameter \"copyFrom\" is null.");
        }
        URI newType = copyFrom.getDataType();
        if (newType == null) {
            throw new IdASException("Type of passed value \"copyFrom\" is null.");
        }
        if (!newType.equals(this.getAttrID())) {
            throw new IdASException("Can not create value with type " + newType.toString() + " for attribute with type " + this.getAttrID().toString());
        }
        if (this.isSimple_) {
            if (copyFrom instanceof ISimpleAttrValue) {
                ISimpleAttrValue from = (ISimpleAttrValue)copyFrom;
                ISimpleAttrValue newVal = this.addSimpleValue(newType, from.getData());
                return newVal;
            }
            throw new IdASException("Passed value \"copyFrom\" with type " + newType.toString() + " is not an instance of ISimpleValue");
        }
        if (copyFrom instanceof IComplexAttrValue) {
            IComplexAttrValue from = (IComplexAttrValue)copyFrom;
            IComplexAttrValue newVal = this.addComplexValue(newType);
            Iterator itrAttr = from.getAttributes();
            if (itrAttr != null) {
                while (itrAttr.hasNext()) {
                    IAttribute attr = (IAttribute)itrAttr.next();
                    newVal.addAttribute(attr);
                }
            }
            return newVal;
        }
        throw new IdASException("Passed value \"copyFrom\" with type " + newType.toString() + " is not an instance of IComplexValue");
    }

    public URI getAttrID() throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.Attribute::getAttrID");
        return this.attModel_.getType();
    }

    public IAttributeModel getModel() throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.Attribute::getModel");
        return this.attModel_;
    }

    public Iterator getValues() throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.Attribute::getValues");
        ArrayList<Object> list = new ArrayList<Object>();
        NodeIterator itr = this.owner_.listPropertyValues((Property)this.property_);
        if (this.isSimple_) {
            while (itr.hasNext()) {
                RDFNode node = itr.nextNode();
                if (node == null || !node.isLiteral()) continue;
                Literal lt = (Literal)node.as(class$com$hp$hpl$jena$rdf$model$Literal == null ? Attribute.class$("com.hp.hpl.jena.rdf.model.Literal") : class$com$hp$hpl$jena$rdf$model$Literal);
                SimpleValue sv = new SimpleValue(this.context_, this, this.owner_, this.property_.asDatatypeProperty(), lt);
                list.add(sv);
            }
        } else {
            while (itr.hasNext()) {
                RDFNode node = itr.nextNode();
                if (node == null || node.isLiteral()) continue;
                Individual ind = (Individual)node.as(class$com$hp$hpl$jena$ontology$Individual == null ? Attribute.class$("com.hp.hpl.jena.ontology.Individual") : class$com$hp$hpl$jena$ontology$Individual);
                OntClass cls = this.context_.getOntClass(ind.getRDFType().getURI());
                ComplexValue cv = new ComplexValue(this.context_, this, ind, this.property_);
                list.add(cv);
            }
        }
        return list.iterator();
    }

    public Iterator getValues(IExtension[] extensions) throws IdASException {
        if (extensions != null) {
            for (int index = 0; index < extensions.length; ++index) {
                if (!extensions[index].failIfUnsupported()) continue;
                throw new UnhandledExtensionException(extensions[index].getClass().getName() + " not supported");
            }
        }
        return this.getValues();
    }

    public boolean isSingleValued() throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.Attribute::isSingleValued");
        return false;
    }

    public void remove() throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.Attribute::remove");
        ArrayList<RDFNode> list = new ArrayList<RDFNode>();
        NodeIterator itr = this.owner_.listPropertyValues((Property)this.property_);
        while (itr.hasNext()) {
            RDFNode node = itr.nextNode();
            list.add(node);
        }
        for (int i = 0; i < list.size(); ++i) {
            RDFNode node = (RDFNode)list.get(i);
            this.owner_.removeProperty((Property)this.property_, node);
            if (node.isLiteral()) continue;
            Individual ind = (Individual)node.as(class$com$hp$hpl$jena$ontology$Individual == null ? Attribute.class$("com.hp.hpl.jena.ontology.Individual") : class$com$hp$hpl$jena$ontology$Individual);
            ModelUtils.removeIndividual(this.context_, ind);
        }
    }

    public boolean equals(IAttribute attr) throws IdASException {
        return false;
    }

    public IAttribute addAttribute(URI attrID) throws IdASException, InvalidTypeException {
        return null;
    }

    public IAttribute addAttribute(IAttribute copyFrom) throws IdASException {
        return null;
    }

    public boolean equals(IHasAttributes attributes) throws IdASException {
        return false;
    }

    public IAttribute getAttribute(URI attrID) throws IdASException {
        return null;
    }

    public Iterator getAttributes() throws IdASException {
        return null;
    }

    public ISingleValuedAttribute getSingleValuedAttribute(URI attrID) throws IdASException, NotSingleValuedAttributeException {
        return null;
    }

    public void removeAttribute(URI attrID) throws IdASException {
    }

    public void removeAttributeValue(URI attrID, Object value) throws IdASException {
    }

    public void removeAttributeValue(IAttribute attr) throws IdASException {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

