/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.idas.cp.jena2.impl;

import com.hp.hpl.jena.ontology.Individual;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntProperty;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.idas.api.IAttribute;
import org.eclipse.higgins.idas.api.IAttributeValue;
import org.eclipse.higgins.idas.api.IComplexAttrValue;
import org.eclipse.higgins.idas.api.IHasAttributes;
import org.eclipse.higgins.idas.api.ISingleValuedAttribute;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.api.InvalidTypeException;
import org.eclipse.higgins.idas.api.NotImplementedException;
import org.eclipse.higgins.idas.api.model.IAttributeComplexValueModel;
import org.eclipse.higgins.idas.api.model.IAttributeModel;
import org.eclipse.higgins.idas.api.model.IEntityModel;
import org.eclipse.higgins.idas.cp.jena2.impl.Attribute;
import org.eclipse.higgins.idas.cp.jena2.impl.Context;
import org.eclipse.higgins.idas.cp.jena2.impl.Entity;
import org.eclipse.higgins.idas.cp.jena2.impl.SingleValuedAttribute;
import org.eclipse.higgins.idas.cp.jena2.util.ModelUtils;
import org.eclipse.higgins.idas.model.impl.AttributeModel;

public class ComplexValue
implements IComplexAttrValue {
    private Log log = LogFactory.getLog((Class)(class$org$eclipse$higgins$idas$cp$jena2$impl$ComplexValue == null ? (class$org$eclipse$higgins$idas$cp$jena2$impl$ComplexValue = ComplexValue.class$("org.eclipse.higgins.idas.cp.jena2.impl.ComplexValue")) : class$org$eclipse$higgins$idas$cp$jena2$impl$ComplexValue));
    protected OntProperty property_ = null;
    protected Context context_ = null;
    protected Attribute attribute_ = null;
    protected Entity subject_ = null;
    protected Individual value_ = null;
    protected OntClass valueClass_ = null;
    protected IAttributeComplexValueModel valueModel_ = null;
    protected Individual ownerOfAttribute_ = null;
    protected URI type_ = null;
    static /* synthetic */ Class class$org$eclipse$higgins$idas$cp$jena2$impl$ComplexValue;

    public ComplexValue(Context context, Attribute attribute, Individual container, OntProperty attributeProperty) throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.ComplexValue::ComplexValue");
        if (context == null) {
            throw new IdASException("Parameter \"context\" is null.");
        }
        if (attribute == null) {
            throw new IdASException("Parameter \"attribute\" is null.");
        }
        if (container == null) {
            throw new IdASException("Parameter \"container\" is null.");
        }
        this.context_ = context;
        this.attribute_ = attribute;
        this.value_ = container;
        this.ownerOfAttribute_ = attribute.getOwner();
        this.subject_ = attribute.getSubjectOwner();
        this.property_ = attributeProperty;
        this.valueModel_ = (IAttributeComplexValueModel)this.attribute_.getModel().getValueModel();
        String valueModelClass = this.valueModel_.getType().toString();
        this.valueClass_ = this.context_.getOntClass(valueModelClass);
        if (this.valueClass_ == null) {
            throw new IdASException("Could not find ontology class with type = " + valueModelClass);
        }
    }

    public Entity getSubjectOwner() {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.ComplexValue::getSubjectOwner");
        return this.subject_;
    }

    public URI getDataType() throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.ComplexValue::getType");
        return this.getValueType();
    }

    public URI getValueType() throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.ComplexValue::getValueType");
        if (this.type_ == null) {
            this.type_ = URI.create(this.valueClass_.getURI());
        }
        return this.type_;
    }

    public boolean isSimple() throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.ComplexValue::isSimple");
        return false;
    }

    public void remove() throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.ComplexValue::remove");
        this.context_.registerChangedSubject(this.subject_);
        this.ownerOfAttribute_.removeProperty((Property)this.property_, (RDFNode)this.value_);
        ModelUtils.removeIndividual(this.context_, this.value_);
    }

    public IAttribute addAttribute(URI attrID) throws IdASException, InvalidTypeException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.ComplexValue::addAttribute(URI)");
        return this.getAttribute(attrID);
    }

    public IAttribute addAttribute(IAttribute copyFrom) throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.ComplexValue::addAttribute");
        if (copyFrom == null) {
            throw new IdASException("Parameter \"copyFrom\" is null.");
        }
        IAttribute newAttr = this.getAttribute(copyFrom.getAttrID());
        Iterator itrVal = copyFrom.getValues();
        this.context_.registerChangedSubject(this.subject_);
        while (itrVal.hasNext()) {
            IAttributeValue value = (IAttributeValue)itrVal.next();
            newAttr.addValue(value);
        }
        return newAttr;
    }

    public IAttribute getAttribute(URI attrID) throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.Entity::getAttribute");
        if (attrID == null) {
            throw new IdASException("Parameter \"attrID\" is null.");
        }
        String uri = attrID.toString();
        IAttributeModel am = this.valueModel_.getAttributeModel(attrID);
        if (am == null) {
            throw new IdASException("Unsupported attribute " + uri + "for entity with type " + this.type_.toString());
        }
        OntProperty op = this.context_.getOntProperty(uri);
        int maxCardinality = ModelUtils.getMaxCardinality(this.context_, this.valueClass_, op);
        if (maxCardinality == 1) {
            return new SingleValuedAttribute(this.context_, this, op, am);
        }
        return new Attribute(this.context_, this, op, am);
    }

    public Iterator getAttributes() throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.Entity::getAttributes");
        ArrayList<Attribute> attrs = new ArrayList<Attribute>();
        Iterator itr = this.valueModel_.getAttributeModels();
        while (itr.hasNext()) {
            AttributeModel attrModel = (AttributeModel)itr.next();
            URI attrType = attrModel.getType();
            if (attrType == null) {
                throw new IdASException("Can not get the type of attribute model for Entity with type " + this.valueClass_.getURI());
            }
            OntProperty property = this.context_.getModel().getOntProperty(attrType.toString());
            if (property == null) {
                throw new IdASException("Can not get object property with type " + attrType);
            }
            int maxCardinality = ModelUtils.getMaxCardinality(this.context_, this.valueClass_, property);
            if (maxCardinality == 1) {
                attrs.add(new SingleValuedAttribute(this.context_, this, property, (IAttributeModel)attrModel));
                continue;
            }
            attrs.add(new Attribute(this.context_, this, property, (IAttributeModel)attrModel));
        }
        return attrs.iterator();
    }

    public Individual getValueIndividual() throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.ComplexValue::getValueIndividual");
        return this.value_;
    }

    public OntClass getValueClass() throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.ComplexValue::getValueClass");
        return this.valueClass_;
    }

    public IAttributeComplexValueModel getValueModel() throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.ComplexValue::getValueModel");
        return this.valueModel_;
    }

    public ISingleValuedAttribute getSingleValuedAttribute(URI attrID) throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.ComplexValue::getSingleValuedAttribute");
        String idURI = attrID.toString();
        IAttribute attr = this.getAttribute(attrID);
        if (attr == null) {
            return null;
        }
        if (!(attr instanceof ISingleValuedAttribute)) {
            throw new IdASException("Attribute " + idURI + " is not an instance of ISingleValuedAttribute");
        }
        return (ISingleValuedAttribute)attr;
    }

    public boolean equals(IAttributeValue value) throws IdASException {
        throw new NotImplementedException();
    }

    public boolean equals(IHasAttributes attributes) throws IdASException {
        throw new NotImplementedException();
    }

    public void removeAttribute(URI attrID) throws IdASException {
        throw new NotImplementedException();
    }

    public void removeAttributeValue(URI attrID, Object value) throws IdASException {
        throw new NotImplementedException();
    }

    public void removeAttributeValue(IAttribute attr) throws IdASException {
        throw new NotImplementedException();
    }

    public IEntityModel getModel() throws IdASException {
        return this.valueModel_;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

