/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.idas.cp.jena2.impl.filter;

import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.idas.api.BadFilterException;
import org.eclipse.higgins.idas.api.IFilter;
import org.eclipse.higgins.idas.api.IFilterAssertion;
import org.eclipse.higgins.idas.api.IFilterAttributeAssertion;
import org.eclipse.higgins.idas.api.IFilterEntityIDAssertion;
import org.eclipse.higgins.idas.api.IFilterEntityTypeAssertion;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.cp.jena2.impl.Context;
import org.eclipse.higgins.idas.cp.jena2.impl.filter.CompoundCondition;
import org.eclipse.higgins.idas.cp.jena2.impl.filter.FilterAssertion;
import org.eclipse.higgins.idas.cp.jena2.impl.filter.FilterAttributeAssertion;
import org.eclipse.higgins.idas.cp.jena2.impl.filter.FilterContext;
import org.eclipse.higgins.idas.cp.jena2.impl.filter.FilterEntityIDAssertion;
import org.eclipse.higgins.idas.cp.jena2.impl.filter.GraphPattern;
import org.eclipse.higgins.idas.cp.jena2.impl.filter.ICondition;

public class Filter
implements IFilter {
    private Log log = LogFactory.getLog((Class)(class$org$eclipse$higgins$idas$cp$jena2$impl$filter$Filter == null ? (class$org$eclipse$higgins$idas$cp$jena2$impl$filter$Filter = Filter.class$("org.eclipse.higgins.idas.cp.jena2.impl.filter.Filter")) : class$org$eclipse$higgins$idas$cp$jena2$impl$filter$Filter));
    private IFilterAssertion assertion_ = null;
    private String operator_ = null;
    private ArrayList filters_ = null;
    private Context idasContext_ = null;
    private ICondition condition_ = null;
    static /* synthetic */ Class class$org$eclipse$higgins$idas$cp$jena2$impl$filter$Filter;

    public Filter(Context context) throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.filter.Filter::Filter");
        if (context == null) {
            throw new IdASException("Parameter \"context\" is null");
        }
        this.idasContext_ = context;
    }

    public void setAssertion(IFilterAssertion assertion) throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.filter.Filter::setAssertion");
        if (!(assertion instanceof FilterAssertion)) {
            throw new BadFilterException("FilterAssertion created by another context provider implementation cannot be added");
        }
        if ("urn:eclipse.higgins.idas.OP_AND".equals(this.operator_) || "urn:eclipse.higgins.idas.OP_OR".equals(this.operator_) || this.filters_ != null) {
            throw new BadFilterException("Assertion cannot be added when operator or filter is present");
        }
        this.assertion_ = assertion;
    }

    public IFilterAssertion getAssertion() throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.filter.Filter::getAssertion");
        return this.assertion_;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setOperator(String operator) throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.filter.Filter::setOperator");
        if ("urn:eclipse.higgins.idas.OP_NOT".equals(operator)) {
            this.operator_ = operator;
            return;
        } else {
            if (!"urn:eclipse.higgins.idas.OP_AND".equals(operator) && !"urn:eclipse.higgins.idas.OP_OR".equals(operator)) throw new BadFilterException("Unexpected operator: " + operator);
            if (this.assertion_ != null) throw new BadFilterException("Operators \"OR\" or \"AND\" cannot be added when assertion is present");
            this.operator_ = operator;
        }
    }

    public String getOperator() throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.filter.Filter::getOperator");
        return this.operator_;
    }

    public void addFilter(IFilter filter) throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.filter.Filter::addFilter(IFilter)");
        if (this.assertion_ == null) {
            if (this.filters_ == null) {
                this.filters_ = new ArrayList();
            }
            if (!(filter instanceof Filter)) {
                throw new BadFilterException("Filter created by another context provider implementation cannot be added");
            }
        } else {
            throw new BadFilterException("Filter cannot be added when assertion is present");
        }
        this.filters_.add(filter);
    }

    public void addFilter(IFilterAssertion filterAssertion) throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.filter.Filter::addFilter(IFilterAssertion)");
        if (!(filterAssertion instanceof FilterAssertion)) {
            throw new BadFilterException("FilterAssertion created by another context provider implementation cannot be added");
        }
        Filter filter = new Filter(this.idasContext_);
        filter.setAssertion(filterAssertion);
        this.addFilter(filter);
    }

    public ArrayList getFilters() throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.filter.Filter::getFilters");
        return this.filters_;
    }

    public IFilterAttributeAssertion createAttributeAssertion() throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.filter.Filter::IFilterAttributeAssertion");
        return new FilterAttributeAssertion(this.idasContext_);
    }

    public IFilterEntityIDAssertion createNodeIDAssertion() throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.filter.Filter::createNodeIDAssertion");
        return new FilterEntityIDAssertion(this.idasContext_);
    }

    public IFilterEntityTypeAssertion createTypeAssertion() throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.filter.Filter::createTypeAssertion");
        return null;
    }

    public ICondition getCondition() throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.filter.Filter::getCondition");
        if (this.condition_ == null) {
            throw new IdASException("Can't return condition. Filter should be initialized before.");
        }
        return this.condition_;
    }

    public void init(FilterContext filterContext) throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.filter.Filter::init");
        if (this.assertion_ == null) {
            if (this.filters_ == null || this.filters_.size() == 0) {
                throw new IdASException("Filter doesn't contain any filter/assertion");
            }
            int size = this.filters_.size();
            CompoundCondition condition = new CompoundCondition(this.operator_);
            for (int i = 0; i < size; ++i) {
                Filter filter = (Filter)this.filters_.get(i);
                filter.init(filterContext);
                condition.addCondition(filter.getCondition());
                this.condition_ = condition;
            }
        } else {
            FilterAssertion assertion = (FilterAssertion)this.assertion_;
            assertion.init(filterContext);
            this.condition_ = assertion.getCondition();
        }
    }

    public void initAsAttributeMetadataFilter(GraphPattern root, FilterContext filterContext) throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.filter.Filter::initAsAttributeMetadataFilter");
        if (this.assertion_ == null) {
            if (this.filters_ == null || this.filters_.size() == 0) {
                throw new IdASException("Filter doesn't contain any filters/assertion");
            }
            int size = this.filters_.size();
            for (int i = 0; i < size; ++i) {
                CompoundCondition condition = new CompoundCondition(this.operator_);
                Filter filter = (Filter)this.filters_.get(i);
                filter.initAsAttributeMetadataFilter(root, filterContext);
                condition.addCondition(filter.getCondition());
                this.condition_ = condition;
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

