/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.idas.cp.jena2.util;

import com.hp.hpl.jena.ontology.CardinalityRestriction;
import com.hp.hpl.jena.ontology.Individual;
import com.hp.hpl.jena.ontology.MaxCardinalityRestriction;
import com.hp.hpl.jena.ontology.MinCardinalityRestriction;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntProperty;
import com.hp.hpl.jena.ontology.Restriction;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.api.model.IAttributeComplexValueModel;
import org.eclipse.higgins.idas.api.model.IAttributeModel;
import org.eclipse.higgins.idas.api.model.IEntityModel;
import org.eclipse.higgins.idas.cp.jena2.IJenaContext;
import org.eclipse.higgins.idas.cp.jena2.impl.Attribute;
import org.eclipse.higgins.idas.cp.jena2.impl.ComplexValue;
import org.eclipse.higgins.idas.cp.jena2.impl.Context;
import org.eclipse.higgins.idas.cp.jena2.impl.Entity;
import org.eclipse.higgins.idas.cp.jena2.impl.SimpleValue;

public class ModelUtils {
    private static Log log = LogFactory.getLog((Class)(class$org$eclipse$higgins$idas$cp$jena2$util$ModelUtils == null ? (class$org$eclipse$higgins$idas$cp$jena2$util$ModelUtils = ModelUtils.class$("org.eclipse.higgins.idas.cp.jena2.util.ModelUtils")) : class$org$eclipse$higgins$idas$cp$jena2$util$ModelUtils));
    static /* synthetic */ Class class$org$eclipse$higgins$idas$cp$jena2$util$ModelUtils;
    static /* synthetic */ Class class$com$hp$hpl$jena$ontology$Individual;
    static /* synthetic */ Class class$com$hp$hpl$jena$rdf$model$Literal;
    static /* synthetic */ Class class$org$eclipse$higgins$idas$cp$jena2$impl$Attribute;

    public static boolean isClassRelative(OntClass ancestor, OntClass descendant) throws IdASException {
        log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.util.ModelUtils::isClassRelative");
        if (ancestor.equals(descendant)) {
            return true;
        }
        try {
            ExtendedIterator itr = descendant.listSuperClasses();
            while (itr.hasNext()) {
                OntClass cls = (OntClass)itr.next();
                if (!ModelUtils.isClassRelative(ancestor, cls)) continue;
                return true;
            }
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new IdASException(e.getMessage());
        }
        return false;
    }

    public static boolean isPropertyRelative(OntProperty ancestor, OntProperty descendant) throws IdASException {
        log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.util.ModelUtils::isPropertyRelative");
        try {
            for (OntProperty tmpDescendant = descendant; tmpDescendant != null; tmpDescendant = tmpDescendant.getSuperProperty()) {
                if (!tmpDescendant.hasSuperProperty((Property)ancestor, false)) continue;
                return true;
            }
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new IdASException(e.getMessage());
        }
        return false;
    }

    private static void fillListSuperClasses(List list, OntClass cls) {
        log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.util.ModelUtils::fillListSuperClasses");
        if (cls != null && !cls.isRestriction()) {
            list.add(cls);
        }
        ExtendedIterator ei = cls.listSuperClasses();
        while (ei.hasNext()) {
            ModelUtils.fillListSuperClasses(list, (OntClass)ei.next());
        }
    }

    private static void fillListSubClasses(List list, OntClass cls) {
        log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.util.ModelUtils::fillListSubClasses");
        if (cls != null && !cls.isRestriction()) {
            list.add(cls);
        }
        ExtendedIterator ei = cls.listSubClasses();
        while (ei.hasNext()) {
            ModelUtils.fillListSubClasses(list, (OntClass)ei.next());
        }
    }

    public static List getListSubClasses(Context context, OntClass ownerClass) {
        log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.util.ModelUtils::getListSubClasses");
        ArrayList classesList = new ArrayList();
        ModelUtils.fillListSubClasses(classesList, ownerClass);
        return classesList;
    }

    public static List getListSuperClasses(IJenaContext context, OntClass ownerClass) {
        log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.util.ModelUtils::getListSuperClasses");
        ArrayList classesList = new ArrayList();
        ModelUtils.fillListSuperClasses(classesList, ownerClass);
        return classesList;
    }

    public static boolean isAttributeOfEntity(Context context, OntProperty property) throws IdASException {
        OntClass entity = context.getModelNoException().getOntClass("http://www.eclipse.org/higgins/ontologies/2008/6/higgins#Entity");
        ExtendedIterator ei = property.listDomain();
        while (ei.hasNext()) {
            OntClass domain;
            Object node = ei.next();
            if (!(node instanceof OntClass) || !ModelUtils.isClassRelative(entity, domain = (OntClass)node)) continue;
            return true;
        }
        return false;
    }

    public static boolean isPropertyOfClass(Context context, OntClass ownerClass, OntProperty property) {
        log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.util.ModelUtils::isPropertyOfClass");
        ArrayList classesList = new ArrayList();
        ModelUtils.fillListSuperClasses(classesList, ownerClass);
        for (int i = 0; i < classesList.size(); ++i) {
            OntClass ontClass = (OntClass)classesList.get(i);
            ExtendedIterator ei = property.listDomain();
            while (ei.hasNext()) {
                Object node = ei.next();
                if (!(node instanceof OntClass)) continue;
                OntClass domain = (OntClass)node;
                if (!ontClass.getURI().equals(domain.getURI())) continue;
                return true;
            }
        }
        return false;
    }

    public static Individual getSubjectByID(Context context, String cuid) throws IdASException {
        log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.util.ModelUtils::getSubjectByID");
        Individual digitalSubject = null;
        String queryString = "PREFIX  higgins: <http://www.eclipse.org/higgins/ontologies/2008/6/higgins#> \nPREFIX  xsd: <http://www.w3.org/2001/XMLSchema#> \nSELECT ?ds \n WHERE { \n ?ds higgins:entityId   \"" + cuid + "\"^^xsd:string}";
        Query query = QueryFactory.create((String)queryString);
        QueryExecution qexec = QueryExecutionFactory.create((Query)query, (Model)context.getModel());
        try {
            ResultSet results = qexec.execSelect();
            if (results.hasNext()) {
                QuerySolution soln = results.nextSolution();
                RDFNode a = soln.get("ds");
                digitalSubject = (Individual)a.as(class$com$hp$hpl$jena$ontology$Individual == null ? (class$com$hp$hpl$jena$ontology$Individual = ModelUtils.class$("com.hp.hpl.jena.ontology.Individual")) : class$com$hp$hpl$jena$ontology$Individual);
            }
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new IdASException(e.getMessage());
        }
        finally {
            qexec.close();
        }
        return digitalSubject;
    }

    public static void removeIndividual(Context context, Individual ind) throws IdASException {
        Individual child;
        String type;
        log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.util.ModelUtils::removeIndividual");
        String string = type = ind.getRDFType() != null ? ind.getRDFType().getURI() : null;
        if (type == null) {
            throw new IdASException("Indiividual doesn't have RDF type");
        }
        StmtIterator si = ind.listProperties();
        ArrayList<Statement> stmts = new ArrayList<Statement>();
        ArrayList<Individual> individuals = new ArrayList<Individual>();
        while (si.hasNext()) {
            Statement st = si.nextStatement();
            RDFNode node = st.getObject();
            if (node.isLiteral()) {
                stmts.add(st);
                continue;
            }
            if (!node.isResource()) continue;
            child = null;
            try {
                child = (Individual)node.as(class$com$hp$hpl$jena$ontology$Individual == null ? ModelUtils.class$("com.hp.hpl.jena.ontology.Individual") : class$com$hp$hpl$jena$ontology$Individual);
            }
            catch (ClassCastException e) {
                throw new IdASException(e.getMessage());
            }
            if (child == null || type.equals(child.getURI())) continue;
            individuals.add(child);
        }
        Iterator itrStmt = stmts.iterator();
        while (itrStmt.hasNext()) {
            Statement st = (Statement)itrStmt.next();
            context.getModel().remove(st);
        }
        Iterator itrIndv = individuals.iterator();
        while (itrIndv.hasNext()) {
            child = (Individual)itrIndv.next();
            ModelUtils.removeIndividual(context, child);
        }
        ind.remove();
    }

    public static int getMaxCardinality(Context context, OntClass cls, OntProperty attr) throws IdASException {
        log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.util.ModelUtils::getMaxCardinality");
        ExtendedIterator itr = cls.listSuperClasses();
        while (itr.hasNext()) {
            OntClass c = (OntClass)itr.next();
            if (c.isRestriction()) {
                Restriction r = c.asRestriction();
                if (!r.onProperty((Property)attr)) continue;
                if (r.isCardinalityRestriction()) {
                    CardinalityRestriction cr = r.asCardinalityRestriction();
                    return cr.getCardinality();
                }
                if (!r.isMaxCardinalityRestriction()) continue;
                MaxCardinalityRestriction cr = r.asMaxCardinalityRestriction();
                return cr.getMaxCardinality();
            }
            int res = ModelUtils.getMaxCardinality(context, c, attr);
            if (res == -1) continue;
            return res;
        }
        return -1;
    }

    public static int getMinCardinality(Context context, OntClass cls, OntProperty attr) throws IdASException {
        log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.util.ModelUtils::getMinCardinality");
        ExtendedIterator itr = cls.listSuperClasses(true);
        while (itr.hasNext()) {
            Restriction r;
            OntClass c = (OntClass)itr.next();
            if (!c.isRestriction() || !(r = c.asRestriction()).onProperty((Property)attr)) continue;
            if (r.isCardinalityRestriction()) {
                CardinalityRestriction cr = r.asCardinalityRestriction();
                return cr.getCardinality();
            }
            if (!r.isMinCardinalityRestriction()) continue;
            MinCardinalityRestriction cr = r.asMinCardinalityRestriction();
            return cr.getMinCardinality();
        }
        return -1;
    }

    public static void setUserToken(Context context, Individual subjectInd, String userToken) throws IdASException {
        log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.util.ModelUtils::setUserToken");
        OntProperty tokenProp = context.getOntProperty("http://www.eclipse.org/higgins/authentication#userToken");
        if (userToken == null || userToken.length() == 0) {
            RDFNode node = subjectInd.getPropertyValue((Property)tokenProp);
            subjectInd.removeProperty((Property)tokenProp, node);
        } else {
            Literal ltr = context.getModel().createLiteral(userToken);
            subjectInd.setPropertyValue((Property)tokenProp, (RDFNode)ltr);
        }
    }

    public static String getUserToken(Context context, Individual subjectInd) throws IdASException {
        log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.util.ModelUtils::getUserToken");
        OntProperty tokenProp = context.getOntProperty("http://www.eclipse.org/higgins/authentication#userToken");
        RDFNode tokenNode = subjectInd.getPropertyValue((Property)tokenProp);
        if (tokenNode != null) {
            if (tokenNode.isLiteral()) {
                Literal ltr = (Literal)tokenNode.as(class$com$hp$hpl$jena$rdf$model$Literal == null ? (class$com$hp$hpl$jena$rdf$model$Literal = ModelUtils.class$("com.hp.hpl.jena.rdf.model.Literal")) : class$com$hp$hpl$jena$rdf$model$Literal);
                Object obj = ltr.getValue();
                if (obj != null) {
                    return obj.toString();
                }
            } else {
                throw new IdASException("Property http://www.eclipse.org/higgins/authentication#userToken contains non-literal value.");
            }
        }
        return null;
    }

    public static String generateUniqueID(Context context) {
        log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.util.ModelUtils::generateUniqueID");
        String rnd = String.valueOf(Math.random()).substring(0);
        return String.valueOf(System.currentTimeMillis()) + rnd;
    }

    public static void validateSubject(Context context, Entity subj) throws IdASException {
        log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.util.ModelUtils::validateSubject");
        log.debug((Object)("ContextURI = " + context.getNS() + ", subject type = " + subj.getEntityType()));
        if (subj == null) {
            throw new IdASException("Parameter \"subj\" is null.");
        }
        Iterator attributeModels = null;
        IEntityModel subjModel = subj.getModel();
        if (subjModel != null) {
            attributeModels = subjModel.getAttributeModels();
        }
        Iterator itrAttr = subj.getAttributes();
        ModelUtils.validateAttributes(context, itrAttr, attributeModels);
    }

    public static void validateAttributes(Context context, Iterator attributes, Iterator attributeModels) throws IdASException {
        log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.util.ModelUtils::validateAttributes");
        ArrayList<String> attrIDs = new ArrayList<String>();
        while (attributes.hasNext()) {
            Object obj = attributes.next();
            if (!(obj instanceof Attribute)) {
                throw new IdASException("Instance of " + (class$org$eclipse$higgins$idas$cp$jena2$impl$Attribute == null ? (class$org$eclipse$higgins$idas$cp$jena2$impl$Attribute = ModelUtils.class$("org.eclipse.higgins.idas.cp.jena2.impl.Attribute")) : class$org$eclipse$higgins$idas$cp$jena2$impl$Attribute).getName() + " expected, " + obj.getClass().getName() + " found.");
            }
            Attribute attr = (Attribute)obj;
            ModelUtils.validateAttribute(context, attr);
            attrIDs.add(attr.getAttrID().toString());
        }
    }

    public static boolean isFunctionalProperty(Context context, String attributeType) throws IdASException {
        log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.util.ModelUtils::isFunctionalProperty");
        OntProperty op = context.getOntProperty(attributeType);
        return op != null && op.isFunctionalProperty();
    }

    public static void checkCardinality(Context context, Attribute attr, int realValuesCount) throws IdASException {
        log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.util.ModelUtils::checkCardinality");
        IAttributeModel am = attr.getModel();
        int min = am.getMinCardinality();
        int max = am.getMaxCardinality();
        if (min != 0 && realValuesCount < min) {
            throw new IdASException("Wrong cardinality. Real values count = " + realValuesCount + " min cardinality = " + min);
        }
        if (max != 0 && realValuesCount > max) {
            throw new IdASException("Wrong cardinality. Real values count = " + realValuesCount + " max cardinality = " + max);
        }
    }

    public static void validateAttribute(Context context, Attribute attr) throws IdASException {
        log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.util.ModelUtils::validateAttribute");
        URI type = attr.getAttrID();
        if (type == null) {
            throw new IdASException("Type(ID) of attribute is null.");
        }
        String typeStr = type.toString();
        int valuesCount = 0;
        Iterator itr = attr.getValues();
        while (itr.hasNext()) {
            ++valuesCount;
            Object obj = itr.next();
            if (obj instanceof SimpleValue) {
                boolean isFunctionalProperty = ModelUtils.isFunctionalProperty(context, typeStr);
                ModelUtils.validateSimpleValue(context, (SimpleValue)obj, isFunctionalProperty);
                continue;
            }
            if (obj instanceof ComplexValue) {
                ModelUtils.validateComplexValue(context, (ComplexValue)obj);
                continue;
            }
            if (obj == null) {
                throw new IdASException("Value of attribute is null.");
            }
            throw new IdASException("Unexpected class of value of attribute : " + obj.getClass().getName());
        }
        ModelUtils.checkCardinality(context, attr, valuesCount);
    }

    public static void validateComplexValue(Context context, ComplexValue val) throws IdASException {
        log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.util.ModelUtils::validateComplexValue");
        if (val != null) {
            Iterator attributeModels = null;
            IAttributeComplexValueModel valueModel = (IAttributeComplexValueModel)val.getModel();
            if (valueModel != null) {
                attributeModels = valueModel.getAttributeModels();
            }
            Iterator itrAttr = val.getAttributes();
            ModelUtils.validateAttributes(context, itrAttr, attributeModels);
        }
    }

    public static void validateSimpleValue(Context context, SimpleValue val, boolean isFunctionalProperty) throws IdASException {
        log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.util.ModelUtils::validateSimpleValue");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

