/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.idas.model.impl;

import com.hp.hpl.jena.ontology.CardinalityRestriction;
import com.hp.hpl.jena.ontology.DatatypeProperty;
import com.hp.hpl.jena.ontology.ObjectProperty;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntProperty;
import com.hp.hpl.jena.ontology.OntResource;
import com.hp.hpl.jena.ontology.Restriction;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.api.model.IAttributeComplexValueModel;
import org.eclipse.higgins.idas.api.model.IAttributeModel;
import org.eclipse.higgins.idas.api.model.IDisplayData;
import org.eclipse.higgins.idas.api.model.IEntityModel;
import org.eclipse.higgins.idas.api.model.IdASModelException;
import org.eclipse.higgins.idas.model.impl.AttributeModel;
import org.eclipse.higgins.idas.model.impl.ContextModel;
import org.eclipse.higgins.idas.model.impl.ModelUtils;

public class AttributeComplexValueModel
implements IAttributeComplexValueModel {
    private Log log = LogFactory.getLog((Class)(class$org$eclipse$higgins$idas$model$impl$AttributeComplexValueModel == null ? (class$org$eclipse$higgins$idas$model$impl$AttributeComplexValueModel = AttributeComplexValueModel.class$("org.eclipse.higgins.idas.model.impl.AttributeComplexValueModel")) : class$org$eclipse$higgins$idas$model$impl$AttributeComplexValueModel));
    private URI type_ = null;
    private String parentType_ = null;
    private List allAttrList_ = null;
    private List ownAttrList_ = null;
    private List inheritedAttrList_ = null;
    private Hashtable attrMap_ = null;
    private ContextModel ctx_ = null;
    private OntClass valueClass_ = null;
    private ObjectProperty attr_ = null;
    private String modelID_ = null;
    private AttributeModel parent_ = null;
    private HashMap attrToMinCardinality_ = null;
    private HashMap attrToMaxCardinality_ = null;
    static /* synthetic */ Class class$org$eclipse$higgins$idas$model$impl$AttributeComplexValueModel;
    static /* synthetic */ Class class$com$hp$hpl$jena$ontology$OntClass;

    public AttributeComplexValueModel(ContextModel ctx, AttributeModel parent, ObjectProperty attr) throws IdASException {
        this.ctx_ = ctx;
        this.parent_ = parent;
        this.attr_ = attr;
        this.initialize();
        this.ctx_.registerBlankEntityModel(this);
    }

    private void initialize() throws IdASException {
        this.initType();
        this.initAttributes();
        this.initSubType();
        this.modelID_ = ModelUtils.getModelShortName(this.ctx_.getOntModel(), (OntResource)this.valueClass_);
        this.initCardinality();
    }

    private void initSubType() throws IdASException {
        OntClass cls = this.valueClass_.getSuperClass();
        this.parentType_ = cls != null ? cls.getURI() : null;
    }

    private void initType() throws IdASException {
        try {
            OntResource range = this.attr_.getRange();
            if (!range.isClass()) {
                throw new IdASException("Couldn't get range class for attribute property: " + this.attr_.getURI());
            }
            this.valueClass_ = (OntClass)range.as(class$com$hp$hpl$jena$ontology$OntClass == null ? (class$com$hp$hpl$jena$ontology$OntClass = AttributeComplexValueModel.class$("com.hp.hpl.jena.ontology.OntClass")) : class$com$hp$hpl$jena$ontology$OntClass);
            this.type_ = new URI(this.valueClass_.getURI());
        }
        catch (URISyntaxException e) {
            this.log.error((Object)e);
            throw new IdASModelException("The attributeValue class " + this.valueClass_.getURI() + " is not valid URI", (Throwable)e);
        }
    }

    private void initAttributes() throws IdASException {
        this.attrMap_ = new Hashtable();
        this.allAttrList_ = new ArrayList();
        ArrayList own = ModelUtils.getOwnPropertiesByDomain(this.ctx_.getOntModel(), this.valueClass_);
        this.ownAttrList_ = this.initAttributes(own);
        ArrayList inherited = ModelUtils.getInheritedPropertiesByDomain(this.ctx_.getOntModel(), this.valueClass_);
        this.inheritedAttrList_ = this.initAttributes(inherited);
        this.allAttrList_.addAll(this.ownAttrList_);
        this.allAttrList_.addAll(this.inheritedAttrList_);
    }

    private ArrayList initAttributes(ArrayList properties) throws IdASException {
        ArrayList<AttributeModel> attributeModels = new ArrayList<AttributeModel>();
        OntModel mdl = this.ctx_.getOntModel();
        int size = properties.size();
        for (int i = 0; i < size; ++i) {
            OntProperty p = (OntProperty)properties.get(i);
            AttributeModel m = null;
            if (p.isDatatypeProperty()) {
                DatatypeProperty dp = p.asDatatypeProperty();
                m = new AttributeModel(this.ctx_, dp, this);
            } else {
                if (!p.isObjectProperty()) continue;
                ObjectProperty op = p.asObjectProperty();
                m = new AttributeModel(this.ctx_, op, this);
            }
            attributeModels.add(m);
            this.attrMap_.put(m.getType(), m);
        }
        return attributeModels;
    }

    public Iterator getAttributes() {
        return this.allAttrList_.iterator();
    }

    public Iterator getAttributeModels() {
        return this.getAttributes();
    }

    public Iterator getOwnAttributeModels() {
        return this.ownAttrList_.iterator();
    }

    public Iterator getInheritedAttributeModels() {
        return this.inheritedAttrList_.iterator();
    }

    public boolean isSimple() {
        return false;
    }

    public URI getType() {
        return this.type_;
    }

    public IAttributeModel getAttributeModel(URI type) {
        if (type != null) {
            return (IAttributeModel)this.attrMap_.get(type);
        }
        return null;
    }

    public int getMaxCardinality() {
        return -1;
    }

    public Iterator getMetadataModels() {
        return null;
    }

    public int getMinCardinality() {
        return -1;
    }

    public OntClass getOntClass() {
        return this.valueClass_;
    }

    public String getParentType() {
        return this.parentType_;
    }

    public String getId() {
        return this.modelID_;
    }

    public int getMinCardinality(String attrType) {
        if (this.attrToMinCardinality_.containsKey(attrType)) {
            Integer i = (Integer)this.attrToMinCardinality_.get(attrType);
            return i;
        }
        return 0;
    }

    public int getMaxCardinality(String attrType) {
        if (this.attrToMaxCardinality_.containsKey(attrType)) {
            Integer i = (Integer)this.attrToMaxCardinality_.get(attrType);
            return i;
        }
        return 0;
    }

    private void initCardinality() throws IdASException {
        this.attrToMinCardinality_ = new HashMap();
        this.attrToMaxCardinality_ = new HashMap();
        ExtendedIterator itr = this.valueClass_.listSuperClasses(true);
        while (itr.hasNext()) {
            Integer cardinality;
            CardinalityRestriction cr;
            Restriction r;
            OntProperty prop;
            OntClass c = (OntClass)itr.next();
            if (!c.isRestriction() || (prop = (r = c.asRestriction()).getOnProperty()) == null) continue;
            String propType = prop.getURI();
            if (r.isCardinalityRestriction()) {
                cr = r.asCardinalityRestriction();
                cardinality = new Integer(cr.getCardinality());
                this.attrToMinCardinality_.put(propType, cardinality);
                this.attrToMaxCardinality_.put(propType, cardinality);
                continue;
            }
            if (r.isMaxCardinalityRestriction()) {
                cr = r.asMaxCardinalityRestriction();
                cardinality = new Integer(cr.getMaxCardinality());
                this.attrToMaxCardinality_.put(propType, cardinality);
                continue;
            }
            if (!r.isMinCardinalityRestriction()) continue;
            cr = r.asMinCardinalityRestriction();
            cardinality = new Integer(cr.getMinCardinality());
            this.attrToMinCardinality_.put(propType, cardinality);
        }
    }

    public boolean isBlankNode() {
        return true;
    }

    public IEntityModel getParentEntity() {
        return null;
    }

    public List getSubEntities() {
        return null;
    }

    public IDisplayData getDisplayData() throws IdASException {
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

