/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.idas.model.impl;

import com.hp.hpl.jena.ontology.CardinalityRestriction;
import com.hp.hpl.jena.ontology.DatatypeProperty;
import com.hp.hpl.jena.ontology.ObjectProperty;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntProperty;
import com.hp.hpl.jena.ontology.OntResource;
import com.hp.hpl.jena.ontology.Restriction;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.api.model.IAttributeModel;
import org.eclipse.higgins.idas.api.model.IAttributeValueModel;
import org.eclipse.higgins.idas.api.model.IDisplayData;
import org.eclipse.higgins.idas.api.model.IModel;
import org.eclipse.higgins.idas.model.impl.AttributeComplexValueModel;
import org.eclipse.higgins.idas.model.impl.ContextModel;
import org.eclipse.higgins.idas.model.impl.EntityModel;
import org.eclipse.higgins.idas.model.impl.ModelUtils;
import org.eclipse.higgins.idas.model.impl.SimpleValueModel;

public class AttributeModel
implements IAttributeModel {
    private Log log_ = LogFactory.getLog((Class)(class$org$eclipse$higgins$idas$model$impl$AttributeModel == null ? (class$org$eclipse$higgins$idas$model$impl$AttributeModel = AttributeModel.class$("org.eclipse.higgins.idas.model.impl.AttributeModel")) : class$org$eclipse$higgins$idas$model$impl$AttributeModel));
    private URI type_ = null;
    private boolean isDirect_ = false;
    private boolean isSimple_ = false;
    private IAttributeValueModel value_ = null;
    private ContextModel ctx_ = null;
    private OntProperty attr_ = null;
    private IModel parent_ = null;
    private OntClass owner_ = null;
    private String shortName_ = null;
    private int maxCardinality_ = 0;
    private int minCardinality_ = 0;
    static /* synthetic */ Class class$org$eclipse$higgins$idas$model$impl$AttributeModel;

    public AttributeModel(ContextModel ctx, DatatypeProperty dp, EntityModel parent) throws IdASException {
        this.ctx_ = ctx;
        this.attr_ = dp;
        this.parent_ = parent;
        this.owner_ = parent.getOntClass();
        this.isDirect_ = true;
        this.isSimple_ = true;
        this.initialize();
    }

    public AttributeModel(ContextModel ctx, DatatypeProperty dp, AttributeComplexValueModel parent) throws IdASException {
        this.ctx_ = ctx;
        this.attr_ = dp;
        this.parent_ = parent;
        this.owner_ = parent.getOntClass();
        this.isDirect_ = false;
        this.isSimple_ = true;
        this.initialize();
    }

    public AttributeModel(ContextModel ctx, ObjectProperty op, EntityModel parent) throws IdASException {
        this.ctx_ = ctx;
        this.attr_ = op;
        this.parent_ = parent;
        this.owner_ = parent.getOntClass();
        this.isDirect_ = true;
        this.isSimple_ = false;
        this.initialize();
    }

    public AttributeModel(ContextModel ctx, ObjectProperty op, AttributeComplexValueModel parent) throws IdASException {
        this.ctx_ = ctx;
        this.attr_ = op;
        this.parent_ = parent;
        this.owner_ = parent.getOntClass();
        this.isDirect_ = false;
        this.isSimple_ = false;
        this.initialize();
    }

    private void initialize() throws IdASException {
        if ("http://www.eclipse.org/higgins/authentication#PPID".equals(this.attr_.getURI())) {
            this.shortName_ = "PPID";
            if (this.isDirect_) {
                EntityModel oldOwner;
                OntClass oldEntityClass;
                AttributeModel oldAM = this.ctx_.getPPIDAttribute();
                if (oldAM != null && ModelUtils.isClassRelative(this.owner_, oldEntityClass = (oldOwner = (EntityModel)oldAM.getOwner()).getOntClass())) {
                    this.ctx_.setPPIDAttribute(this);
                }
                this.ctx_.setPPIDAttribute(this);
            }
        } else {
            this.shortName_ = ModelUtils.getModelShortName(this.ctx_.getOntModel(), (OntResource)this.attr_);
        }
        this.initType();
        this.initValue();
        this.initCardinality();
    }

    private void initType() throws IdASException {
        try {
            this.type_ = new URI(this.attr_.getURI());
        }
        catch (URISyntaxException e) {
            this.log_.error((Object)e);
            throw new IdASException((Throwable)e);
        }
    }

    private void initValue() throws IdASException {
        this.value_ = this.isSimple_ ? new SimpleValueModel(this.ctx_, this, this.attr_.asDatatypeProperty()) : new AttributeComplexValueModel(this.ctx_, this, this.attr_.asObjectProperty());
    }

    public URI getType() {
        return this.type_;
    }

    public boolean isDirect() {
        return this.isDirect_;
    }

    public int getMaxCardinality() {
        return this.maxCardinality_;
    }

    public int getMinCardinality() {
        return this.minCardinality_;
    }

    private void initCardinality() throws IdASException {
        ExtendedIterator itr = this.owner_.listSuperClasses(true);
        while (itr.hasNext()) {
            CardinalityRestriction cr;
            Restriction r;
            OntClass c = (OntClass)itr.next();
            if (!c.isRestriction() || !(r = c.asRestriction()).onProperty((Property)this.attr_)) continue;
            if (r.isCardinalityRestriction()) {
                cr = r.asCardinalityRestriction();
                this.minCardinality_ = cr.getCardinality();
                this.maxCardinality_ = cr.getCardinality();
                continue;
            }
            if (r.isMaxCardinalityRestriction()) {
                cr = r.asMaxCardinalityRestriction();
                this.maxCardinality_ = cr.getMaxCardinality();
                continue;
            }
            if (!r.isMinCardinalityRestriction()) continue;
            cr = r.asMinCardinalityRestriction();
            this.minCardinality_ = cr.getMinCardinality();
        }
    }

    public Iterator getMetadataModels() {
        return null;
    }

    public IAttributeValueModel getValueModel() {
        return this.value_;
    }

    public String getId() {
        return this.shortName_;
    }

    public boolean isSimple() {
        return this.isSimple_;
    }

    public IModel getOwner() {
        return this.parent_;
    }

    public IDisplayData getDisplayData() throws IdASException {
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

