/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.idas.model.impl;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.ontology.DataRange;
import com.hp.hpl.jena.ontology.DatatypeProperty;
import com.hp.hpl.jena.ontology.OntProperty;
import com.hp.hpl.jena.ontology.OntResource;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.api.model.IdASModelException;
import org.eclipse.higgins.idas.model.impl.SimpleValueModel;

public class XMLValueModel {
    private Log log = LogFactory.getLog((Class)(class$org$eclipse$higgins$idas$model$impl$XMLValueModel == null ? (class$org$eclipse$higgins$idas$model$impl$XMLValueModel = XMLValueModel.class$("org.eclipse.higgins.idas.model.impl.XMLValueModel")) : class$org$eclipse$higgins$idas$model$impl$XMLValueModel));
    private URI type_ = null;
    private boolean isOneOf_ = false;
    private List oneOf_ = null;
    private String pattern_ = null;
    private int length_ = -1;
    private int minLength_ = -1;
    private int maxLength_ = -1;
    private int totalDigits_ = -1;
    private int fractionDigits_ = -1;
    private DatatypeProperty attrProp_ = null;
    private SimpleValueModel parent_ = null;
    static /* synthetic */ Class class$org$eclipse$higgins$idas$model$impl$XMLValueModel;
    static /* synthetic */ Class class$com$hp$hpl$jena$rdf$model$Literal;
    static /* synthetic */ Class class$com$hp$hpl$jena$rdf$model$Resource;

    public XMLValueModel(DatatypeProperty prop, SimpleValueModel parent) throws IdASException {
        this.parent_ = parent;
        this.attrProp_ = prop;
        this.initialize();
    }

    private void initialize() throws IdASException {
        this.initRange();
        if (this.type_ == null) {
            throw new IdASException("Can not parse xml type of simple attribute " + this.parent_.getAttribute().getType());
        }
    }

    private void initRange() throws IdASException {
        this.initRange((OntProperty)this.attrProp_);
    }

    private void initRange(OntProperty prop) throws IdASException {
        OntResource r = prop.getRange();
        if (r != null) {
            if (r.isDataRange()) {
                this.initAsOWL1_0(r);
            } else {
                Resource res = r.getRDFType();
                if (res != null) {
                    this.initAsOWL1_1(r);
                } else {
                    this.initType(r.getURI());
                }
            }
        } else {
            ExtendedIterator itr = prop.listSubProperties();
            while (itr.hasNext()) {
                OntProperty p = (OntProperty)itr.next();
                this.initRange(p);
            }
        }
    }

    private void initAsOWL1_0(OntResource r) throws IdASException {
        this.oneOf_ = new ArrayList();
        DataRange dr = r.asDataRange();
        this.isOneOf_ = true;
        ExtendedIterator itr = dr.listOneOf();
        while (itr.hasNext()) {
            Literal l = (Literal)itr.next();
            RDFDatatype t = l.getDatatype();
            this.initType(t.getURI());
            this.oneOf_.add(l.getValue());
        }
    }

    private void initAsOWL1_1(OntResource r) throws IdASException {
        StmtIterator itr = r.listProperties();
        while (itr.hasNext()) {
            Statement st = itr.nextStatement();
            RDFNode node = st.getObject();
            Literal val = node.isLiteral() ? (Literal)node.as(class$com$hp$hpl$jena$rdf$model$Literal == null ? XMLValueModel.class$("com.hp.hpl.jena.rdf.model.Literal") : class$com$hp$hpl$jena$rdf$model$Literal) : null;
            String prop = st.getPredicate().getURI();
            if ("http://www.w3.org/2006/12/owl11#onDataRange".equals(prop)) {
                if (!node.isResource()) continue;
                Resource res = (Resource)node.as(class$com$hp$hpl$jena$rdf$model$Resource == null ? XMLValueModel.class$("com.hp.hpl.jena.rdf.model.Resource") : class$com$hp$hpl$jena$rdf$model$Resource);
                this.initType(res.getURI());
                continue;
            }
            if ("http://www.w3.org/2006/12/owl11#pattern".equals(prop)) {
                this.pattern_ = val.getString();
                continue;
            }
            if ("http://www.w3.org/2006/12/owl11#maxLength".equals(prop)) {
                try {
                    this.maxLength_ = val.getInt();
                }
                catch (Exception e) {
                    this.log.error((Object)("Can not parse maxLength for property " + this.parent_.getType()), (Throwable)e);
                }
                continue;
            }
            if ("http://www.w3.org/2006/12/owl11#".equals(prop)) {
                try {
                    this.totalDigits_ = val.getInt();
                }
                catch (Exception e) {
                    this.log.error((Object)("Can not parse totalDigits for property " + this.parent_.getType()), (Throwable)e);
                }
                continue;
            }
            if (!"http://www.w3.org/2006/12/owl11#fractionDigits".equals(prop)) continue;
            try {
                this.fractionDigits_ = val.getInt();
            }
            catch (Exception e) {
                this.log.error((Object)("Can not parse fractionDigits for property " + this.parent_.getType()), (Throwable)e);
            }
        }
    }

    private void initType(String typeUri) throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.model.impl.XMLValueModel::initType");
        if (this.type_ == null) {
            try {
                this.type_ = new URI(typeUri);
            }
            catch (Exception e) {
                this.log.error((Object)e);
                throw new IdASException((Throwable)e);
            }
        } else if (!typeUri.equals(this.type_)) {
            throw new IdASModelException("Datatype mismatch for enumerated values: Property=" + this.attrProp_.getURI() + " Datatype1=" + this.type_.toString() + " Datatype2=" + typeUri);
        }
    }

    public boolean isOneOf() {
        return this.isOneOf_;
    }

    public List getOneOf() {
        return this.oneOf_;
    }

    public URI getType() {
        return this.type_;
    }

    public String getPattern() {
        return this.pattern_;
    }

    public int getLength() {
        return this.length_;
    }

    public int getMinLength() {
        return this.minLength_;
    }

    public int getMaxLength() {
        return this.maxLength_;
    }

    public int getTotalDigits() {
        return this.totalDigits_;
    }

    public int getFractionDigits() {
        return this.fractionDigits_;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

