/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.idas.cp.jndi;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.higgins.configuration.api.IConfigurableComponent;
import org.eclipse.higgins.configuration.api.ISettingDescriptor;
import org.eclipse.higgins.configuration.common.SettingDescriptor;
import org.eclipse.higgins.idas.api.IContext;
import org.eclipse.higgins.idas.api.IContextFactory;
import org.eclipse.higgins.idas.api.IContextId;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.api.NotImplementedException;
import org.eclipse.higgins.idas.cp.jndi.JNDIContext;
import org.eclipse.higgins.idas.spi.BasicAttributeSet;

public class JNDIContextFactory
extends BasicAttributeSet
implements IContextFactory,
IConfigurableComponent {
    private ISettingDescriptor _contextFactoryDescriptor = null;
    private List _contextTypesList = null;
    private String _contextFactoryClassName = null;

    public String getName() throws IdASException {
        return "Higgins JNDI Context Provider";
    }

    public Iterator getContexts(String filter) throws IdASException {
        throw new NotImplementedException();
    }

    public IContext createContext(IContextId contextID) throws IdASException {
        return new JNDIContext(contextID);
    }

    public String getPolicy() throws IdASException {
        throw new NotImplementedException();
    }

    public void setPolicy(String arg0) throws IdASException {
        throw new NotImplementedException();
    }

    public void configure(Map mapGlobalSettings, String strComponentName, Map mapComponentSettings, ISettingDescriptor componentDescriptor, ISettingDescriptor globalDescriptor) throws Exception {
        if (mapComponentSettings != null) {
            this._contextFactoryClassName = (String)mapComponentSettings.get("Instance");
            this._contextTypesList = (List)mapComponentSettings.get("ContextTypes");
        }
        this._contextFactoryDescriptor = componentDescriptor;
    }

    public ISettingDescriptor getComponentDescriptor() {
        return this._contextFactoryDescriptor;
    }

    public List getTypes() throws IdASException {
        return this._contextTypesList;
    }

    public ISettingDescriptor getContextDescriptor(String contextIdName) throws IdASException {
        SettingDescriptor settingDescriptor = new SettingDescriptor(contextIdName, "htf:map");
        settingDescriptor.addSubSetting("ContextId", "xsd:string");
        ISettingDescriptor typesDescriptor = settingDescriptor.addSubSetting("ContextTypes", "htf:list");
        int i = 0;
        while (i < this._contextTypesList.size()) {
            typesDescriptor.addSubSetting("JNDIContextType", "xsd:string");
            ++i;
        }
        ISettingDescriptor connectionDescriptor = settingDescriptor.addSubSetting("Connection", "htf:map");
        ISettingDescriptor addrDescriptor = connectionDescriptor.addSubSetting("AddressList", "htf:list");
        addrDescriptor.addSubSetting("Address", "xsd:string");
        connectionDescriptor.addSubSetting("ConnectionType", "xsd:string");
        connectionDescriptor.addSubSetting("jndiProvider", "xsd:string");
        connectionDescriptor.addSubSetting("searchBase", "xsd:string");
        ISettingDescriptor policyDescriptor = settingDescriptor.addSubSetting("JSPolicyAction", "htf:map");
        policyDescriptor.addSubSetting("consumerAIDToProvider", "htf:jscriptexec");
        policyDescriptor.addSubSetting("providerAIDToConsumer", "htf:jscriptexec");
        policyDescriptor.addSubSetting("consumerEntityTypeToProvider", "htf:jscriptexec");
        policyDescriptor.addSubSetting("providerEntityTypeToConsumer", "htf:jscriptexec");
        return settingDescriptor;
    }
}

