/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.idas.cp.jspolicy;

import java.lang.reflect.Constructor;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Appender;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Logger;
import org.apache.log4j.varia.NullAppender;
import org.eclipse.higgins.idas.api.ContextNotOpenException;
import org.eclipse.higgins.idas.api.ContextOpenException;
import org.eclipse.higgins.idas.api.IAttribute;
import org.eclipse.higgins.idas.api.IAuthNAttributesMaterials;
import org.eclipse.higgins.idas.api.IContext;
import org.eclipse.higgins.idas.api.IContextFactory;
import org.eclipse.higgins.idas.api.IContextId;
import org.eclipse.higgins.idas.api.IFilter;
import org.eclipse.higgins.idas.api.IMetadata;
import org.eclipse.higgins.idas.api.INode;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.api.InvalidNodeIDException;
import org.eclipse.higgins.idas.api.InvalidTypeException;
import org.eclipse.higgins.idas.api.NodeExistsException;
import org.eclipse.higgins.idas.api.NotImplementedException;
import org.eclipse.higgins.idas.api.model.IContextModel;
import org.eclipse.higgins.idas.cp.jspolicy.JSPolicyNode;
import org.eclipse.higgins.idas.registry.IdASRegistry;
import org.eclipse.higgins.idas.spi.BasicContext;
import org.eclipse.higgins.util.idas.cp.BasicAttributePDPIter;
import org.eclipse.higgins.util.idas.cp.IAttributePDPs;
import org.eclipse.higgins.util.idas.cp.IMetadataPDPs;
import org.eclipse.higgins.util.idas.cp.jscript.JScriptCPAttributePDPs;
import org.eclipse.higgins.util.idas.cp.jscript.JScriptCPMetadataPDPs;
import org.eclipse.higgins.util.jscript.JScriptException;
import org.eclipse.higgins.util.jscript.JScriptExec;
import org.eclipse.higgins.util.jscript.JScriptExecHelper;

public class JSPolicyContext
extends BasicContext {
    public static final String connectionType = "org.eclipse.higgins.idas.cp.jspolicy";
    public static final String consumerNodeIDToProvider = "consumerNodeIDToProvider";
    public static final String providerNodeIDToConsumer = "providerNodeIDToConsumer";
    private JScriptExec _consumerNodeIDToProviderExec;
    private JScriptExec _providerNodeIDToConsumerExec;
    public static final String consumerMIDToProvider = "consumerMIDToProvider";
    public static final String providerMIDToConsumer = "providerMIDToConsumer";
    public static final String consumerAIDToProvider = "consumerAIDToProvider";
    public static final String providerAIDToConsumer = "providerAIDToConsumer";
    public static final String consumerMTypeToProvider = "consumerMTypeToProvider";
    public static final String providerMTypeToConsumer = "providerMTypeToConsumer";
    public static final String consumerATypeToProvider = "consumerATypeToProvider";
    public static final String providerATypeToConsumer = "providerATypeToConsumer";
    public static final String consumerNodeTypeToProvider = "consumerNodeTypeToProvider";
    public static final String providerNodeTypeToConsumer = "providerNodeTypeToConsumer";
    private JScriptExec _consumerNodeTypeToProviderExec;
    private JScriptExec _providerNodeTypeToConsumerExec;
    public static final String consumerAValueToProvider = "consumerAValueToProvider";
    public static final String consumerMValueToProvider = "consumerMValueToProvider";
    public static final String providerAValueToConsumer = "providerAValueToConsumer";
    public static final String providerMValueToConsumer = "providerMValueToConsumer";
    public static final String consumerOpenValueToProvider = "consumerOpenValueToProvider";
    public static final String consumerOpenAIDToProvider = "consumerOpenAIDToProvider";
    public static final String consumerOpenContextRefToProvider = "consumerOpenContextRefToProvider";
    private JScriptExec _consumerOpenContextRefToProviderExec;
    public static final String genericParamName = "PARAM";
    public static final String genericParamName2 = "PARAM2";
    public static final String genericResultName = "RESULT";
    public static final String consumerIDParamName = "consumerID";
    public static final String providerIDParamName = "providerID";
    public static final String consumerTypeParamName = "consumerType";
    public static final String providerTypeParamName = "providerType";
    public static final String consumerContext = "consumerContext";
    public static final String providerContext = "providerContext";
    public static final String attrPDPCache = "attrPDPCache";
    public static final String attrMetadataPDPCache = "attrMetadataPDPCache";
    public static final String getSchema = "getSchema";
    public static final String setSchema = "setSchema";
    public static final String exportData = "exportData ";
    private JScriptExec _getSchemaExec;
    private JScriptExec _setSchemaExec;
    private JScriptExec _exportDataExec;
    private IContextId _contextID;
    private Map _contextSettings;
    private boolean _bIsOpen;
    private boolean _providerContextOwned;
    private IContext _providerContext;
    private JScriptCPMetadataPDPs _dsMetadataPDPs;
    private JScriptCPAttributePDPs _attributePDP;
    private JScriptCPMetadataPDPs _attributeValueMetadataPDP;
    private JScriptCPMetadataPDPs _attributeMetadataPDP;
    private JScriptCPAttributePDPs _openPDPs;

    protected JSPolicyContext(IContextId contextIDs) throws IdASException {
        if (!Logger.getRootLogger().getAllAppenders().hasMoreElements()) {
            BasicConfigurator.configure((Appender)new NullAppender());
        }
        this._contextID = contextIDs;
        this._contextSettings = this._contextID.getConfiguration();
        this._bIsOpen = false;
        this._providerContext = null;
        this._providerContextOwned = false;
        Map jsPolicySettings = (Map)this._contextSettings.get("JSPolicyAction");
        if (jsPolicySettings != null) {
            this._consumerNodeIDToProviderExec = (JScriptExec)jsPolicySettings.get(consumerNodeIDToProvider);
            this._providerNodeIDToConsumerExec = (JScriptExec)jsPolicySettings.get(providerNodeIDToConsumer);
            this._consumerNodeTypeToProviderExec = (JScriptExec)jsPolicySettings.get(consumerNodeTypeToProvider);
            this._providerNodeTypeToConsumerExec = (JScriptExec)jsPolicySettings.get(providerNodeTypeToConsumer);
            this._consumerOpenContextRefToProviderExec = (JScriptExec)jsPolicySettings.get(consumerOpenContextRefToProvider);
            this._getSchemaExec = (JScriptExec)jsPolicySettings.get(getSchema);
            this._setSchemaExec = (JScriptExec)jsPolicySettings.get(setSchema);
            this._exportDataExec = (JScriptExec)jsPolicySettings.get(exportData);
            this._attributeValueMetadataPDP = this._dsMetadataPDPs = new JScriptCPMetadataPDPs((JScriptExec)jsPolicySettings.get(consumerMIDToProvider), (JScriptExec)jsPolicySettings.get(providerMIDToConsumer), (JScriptExec)jsPolicySettings.get(consumerMTypeToProvider), (JScriptExec)jsPolicySettings.get(providerMTypeToConsumer), (JScriptExec)jsPolicySettings.get(consumerMValueToProvider), (JScriptExec)jsPolicySettings.get(providerMValueToConsumer), false);
            this._attributeMetadataPDP = this._dsMetadataPDPs;
            this._attributePDP = new JScriptCPAttributePDPs((JScriptExec)jsPolicySettings.get(consumerAIDToProvider), (JScriptExec)jsPolicySettings.get(providerAIDToConsumer), (JScriptExec)jsPolicySettings.get(consumerATypeToProvider), (JScriptExec)jsPolicySettings.get(providerATypeToConsumer), (JScriptExec)jsPolicySettings.get(consumerAValueToProvider), (JScriptExec)jsPolicySettings.get(providerAValueToConsumer), false);
            this._openPDPs = new JScriptCPAttributePDPs((JScriptExec)jsPolicySettings.get(consumerOpenAIDToProvider), null, null, null, (JScriptExec)jsPolicySettings.get(consumerOpenValueToProvider), null, true);
        }
    }

    public String open(Object identity) throws IdASException {
        String nodeID = null;
        if (this._bIsOpen) {
            throw new ContextOpenException();
        }
        if (identity instanceof IContext) {
            this._providerContext = (IContext)identity;
            this._providerContextOwned = false;
        } else if (identity instanceof IAuthNAttributesMaterials) {
            IdASRegistry reg = IdASRegistry.getInstance();
            try {
                IContextId providerContextID = (IContextId)this._consumerOpenContextRefToProviderExec.evaluate(genericParamName, (Object)this._contextID);
                List factories = reg.getContextFactories(providerContextID);
                Iterator itr = factories.iterator();
                while (itr.hasNext()) {
                    IContextFactory factory = (IContextFactory)itr.next();
                    this._providerContext = factory.createContext(providerContextID);
                    if (this._providerContext == null) continue;
                    break;
                }
                if (this._providerContext == null) {
                    throw new IdASException("Unable to open Context  identity : " + identity.toString() + "  context ID : " + this._contextID.toString());
                }
                Class<?> c = identity.getClass();
                BasicAttributePDPIter props = new BasicAttributePDPIter((IAttributePDPs)this._openPDPs, null, null, ((IAuthNAttributesMaterials)identity).getAttributes(), false);
                Object[] params = new Object[]{props};
                Object newIdentity = null;
                Constructor<?>[] cons = c.getConstructors();
                for (int iPos = 0; iPos < cons.length; ++iPos) {
                    Class<?>[] potentialParams = cons[iPos].getParameterTypes();
                    if (potentialParams.length != 1 || !potentialParams[0].isAssignableFrom(Class.forName("java.util.Iterator"))) continue;
                    newIdentity = cons[iPos].newInstance(params);
                    break;
                }
                nodeID = newIdentity != null ? this.providerNodeIDToConsumer(this._providerContext.open(newIdentity)) : this.providerNodeIDToConsumer(this._providerContext.open(identity));
            }
            catch (Exception e) {
                throw new IdASException((Throwable)e);
            }
            this._providerContextOwned = true;
        }
        this._bIsOpen = true;
        return nodeID;
    }

    public void close() throws IdASException {
        if (!this._bIsOpen) {
            throw new ContextNotOpenException();
        }
        this._bIsOpen = false;
        if (this._providerContext != null && this._providerContextOwned) {
            this._providerContext.close();
        }
        this._providerContext = null;
        this._providerContextOwned = false;
    }

    public boolean isOpen(Object identity) throws IdASException {
        if (!this._bIsOpen || this._providerContext == null) {
            return false;
        }
        return this._providerContext.isOpen(identity);
    }

    public INode getNode(String nodeID, Iterator consumerSelectionList) throws IdASException {
        if (!this._bIsOpen || this._providerContext == null) {
            throw new ContextNotOpenException();
        }
        HashSet<URI> providerSelectionList = null;
        if (consumerSelectionList != null) {
            providerSelectionList = new HashSet<URI>();
            while (consumerSelectionList.hasNext()) {
                URI consumerAttrName = (URI)consumerSelectionList.next();
                if (this._attributePDP != null) {
                    Iterator itr = this._attributePDP.consumerIDToProviders(consumerAttrName);
                    while (itr.hasNext()) {
                        Object obj = itr.next();
                        if (obj instanceof URI) {
                            providerSelectionList.add((URI)obj);
                            continue;
                        }
                        if (obj instanceof String) {
                            try {
                                providerSelectionList.add(new URI((String)obj));
                                continue;
                            }
                            catch (URISyntaxException e) {
                                throw new IdASException((Throwable)e);
                            }
                        }
                        throw new IdASException("Illegal object type returned from mapping, consumer URI, got: " + obj.getClass().toString());
                    }
                    continue;
                }
                providerSelectionList.add(consumerAttrName);
            }
        }
        return new JSPolicyNode(this._dsMetadataPDPs, this._attributePDP, this._attributeMetadataPDP, this._attributeMetadataPDP, this, this._providerContext.getNode(this.consumerNodeIDToProvider(nodeID), providerSelectionList != null ? providerSelectionList.iterator() : null), nodeID, null);
    }

    public INode getNode(String nodeID) throws IdASException {
        return this.getNode(nodeID, null);
    }

    public INode addNode(URI nodeType, String nodeID) throws IdASException, InvalidTypeException, InvalidNodeIDException, NodeExistsException {
        if (!this._bIsOpen || this._providerContext == null) {
            throw new ContextNotOpenException();
        }
        INode providerDS = this._providerContext.addNode(this.consumerNodeTypeToProvider(nodeType), this.consumerNodeIDToProvider(nodeID));
        return new JSPolicyNode(this._dsMetadataPDPs, this._attributePDP, this._attributeMetadataPDP, this._attributeMetadataPDP, this, providerDS, nodeID, nodeType);
    }

    public INode addNode(INode copyFrom) throws IdASException, NodeExistsException {
        JSPolicyNode consumerDS = (JSPolicyNode)this.addNode(copyFrom.getNodeType(), copyFrom.getNodeID());
        Iterator itr = copyFrom.getAttributes();
        while (itr != null && itr.hasNext()) {
            consumerDS.addAttribute((IAttribute)itr.next());
        }
        itr = copyFrom.getMetadataSet();
        while (itr != null && itr.hasNext()) {
            consumerDS.addMetadata((IMetadata)itr.next());
        }
        return consumerDS;
    }

    public String exportData(String filter, String representationFormat) throws IdASException {
        if (!this._bIsOpen) {
            throw new ContextNotOpenException();
        }
        if (this._exportDataExec != null) {
            Object value;
            String[] paramNames = new String[]{genericParamName, genericParamName2, consumerContext, providerContext, attrPDPCache, attrMetadataPDPCache};
            Object[] params = new Object[]{filter, representationFormat, this, this._providerContext, this._attributePDP, this._attributeMetadataPDP};
            try {
                value = this._exportDataExec.evaluate(paramNames, params);
            }
            catch (JScriptException e) {
                throw new IdASException((Throwable)e);
            }
            return (String)value;
        }
        return this._providerContext.exportData(filter, representationFormat);
    }

    public void importData(String filter, String representationFormat) throws IdASException {
        if (!this._bIsOpen) {
            throw new ContextNotOpenException();
        }
        throw new NotImplementedException();
    }

    public String getSchema() throws IdASException {
        if (!this._bIsOpen) {
            throw new ContextNotOpenException();
        }
        if (this._getSchemaExec != null) {
            Object value;
            String[] paramNames = new String[]{genericParamName, consumerContext, providerContext, attrPDPCache, attrMetadataPDPCache};
            Object[] params = new Object[]{this._providerContext.getSchema(), this, this._providerContext, this._attributePDP, this._attributeMetadataPDP};
            try {
                value = this._getSchemaExec.evaluate(paramNames, params);
            }
            catch (JScriptException e) {
                throw new IdASException((Throwable)e);
            }
            return (String)value;
        }
        return this._providerContext.getSchema();
    }

    public void setSchema(String schema) throws IdASException {
        if (!this._bIsOpen) {
            throw new ContextNotOpenException();
        }
        if (this._setSchemaExec == null) {
            this._providerContext.setSchema(schema);
        }
    }

    public Iterator getNodes(IFilter filter) throws IdASException {
        return this.getNodes(filter, null);
    }

    public Iterator getNodes(IFilter filter, Iterator consumerSelectionList) throws IdASException {
        if (!this._bIsOpen) {
            throw new ContextNotOpenException();
        }
        throw new NotImplementedException();
    }

    public boolean verifyNodeAttributes(String nodeID, Iterator attributes) throws IdASException {
        if (!this._bIsOpen) {
            throw new ContextNotOpenException();
        }
        return this._providerContext.verifyNodeAttributes(this.consumerNodeIDToProvider(nodeID), (Iterator)new BasicAttributePDPIter((IAttributePDPs)this._attributePDP, (IMetadataPDPs)this._attributeMetadataPDP, (IMetadataPDPs)this._attributeValueMetadataPDP, attributes, false));
    }

    public IContextModel getContextModel() throws IdASException {
        throw new NotImplementedException();
    }

    protected String consumerNodeIDToProvider(String nodeID) throws IdASException {
        try {
            return JScriptExecHelper.transformString((JScriptExec)this._consumerNodeIDToProviderExec, (String)consumerIDParamName, (String)nodeID);
        }
        catch (JScriptException e) {
            throw new IdASException((Throwable)e);
        }
    }

    protected String providerNodeIDToConsumer(String nodeID) throws IdASException {
        try {
            return JScriptExecHelper.transformString((JScriptExec)this._providerNodeIDToConsumerExec, (String)providerIDParamName, (String)nodeID);
        }
        catch (JScriptException e) {
            throw new IdASException((Throwable)e);
        }
    }

    protected URI consumerNodeTypeToProvider(URI type) throws IdASException {
        try {
            return JScriptExecHelper.transformURI((JScriptExec)this._consumerNodeTypeToProviderExec, (String)consumerTypeParamName, (URI)type);
        }
        catch (JScriptException e) {
            throw new IdASException((Throwable)e);
        }
    }

    protected URI providerNodeTypeToConsumer(URI type) throws IdASException {
        try {
            return JScriptExecHelper.transformURI((JScriptExec)this._providerNodeTypeToConsumerExec, (String)providerTypeParamName, (URI)type);
        }
        catch (JScriptException e) {
            throw new IdASException((Throwable)e);
        }
    }
}

