/**
 * Copyright (c) 2008 Parity Communications, Inc. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Sergey Lyakhov - initial API and implementation
 */

package org.eclipse.higgins.idas.cp.model.impl;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.api.model.IAttributeModel;
import org.eclipse.higgins.idas.api.model.IContextModel;
import org.eclipse.higgins.idas.api.model.IEntityModel;
import org.eclipse.higgins.idas.api.model.IModel;
import org.eclipse.higgins.idas.api.model.IdASModelException;
import org.eclipse.higgins.idas.cp.model.util.ContextBuilder;
import org.eclipse.higgins.idas.cp.model.util.HigginsVocabulary;

import com.hp.hpl.jena.ontology.OntModel;

public class ContextModel implements IContextModel {

//	private static Log log = LogFactory.getLog(ContextModel.class);

	private URI baseURI;

	private String shortType;

	private HashMap<String, EntityModel> entityByType;

	private HashMap<String, AttributeModel> attributeByType;

	private IEntityModel context;

//	public ContextModel(OntModel model, URI baseURI) throws IdASException, URISyntaxException {
	public ContextModel(OntModel model) throws IdASException, URISyntaxException {

// TEST
		URI baseURI = new URI ("urn:test");
// TEST

		this.baseURI = baseURI;
		ContextBuilder cb = new ContextBuilder(model);
		cb.buildContext();
		entityByType = cb.getEntityModels();
		context = entityByType.remove(HigginsVocabulary.Context);
		attributeByType = cb.getAttributeModels();
		shortType = model.shortForm(baseURI.toString());
	}

	public AttributeModel getPPIDAttribute() {
		return null;
	}

	public IEntityModel getEntityModel(URI entityType) {
		return entityByType.get(entityType.toString());
	}

	public List<IEntityModel> getEntityModels() {
		return new ArrayList<IEntityModel>(entityByType.values());
	}

	public IModel getModel(URI type) {
		if (type == null)
			return null;
		IModel model = entityByType.get(type.toString());
		if (model == null) {
			model = attributeByType.get(type.toString());
		}
		return model;
	}

	public String getShortFormType() {
		return shortType;
	}

	public URI getType() {
		return baseURI;
	}

	public IAttributeModel getAttributeModel(URI attrID) throws IdASModelException {
		return context.getAttributeModel(attrID);
	}

	public List<IAttributeModel> getAttributeModels() throws IdASModelException {
		return context.getAttributeModels();
	}

	public List<IAttributeModel> getInheritedAttributeModels() throws IdASModelException {
		return context.getInheritedAttributeModels();
	}

	public int getMaxCardinality(URI attributeType) throws IdASModelException {
		return context.getMaxCardinality(attributeType);
	}

	public int getMinCardinality(URI attributeType) throws IdASModelException {
		return context.getMinCardinality(attributeType);
	}

	public List<IAttributeModel> getOwnAttributeModels() throws IdASModelException {
		return context.getOwnAttributeModels();
	}

}
