/**
 * Copyright (c) 2008 Parity Communications, Inc. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Sergey Lyakhov - initial API and implementation
 */

package org.eclipse.higgins.idas.cp.model.impl;

import java.net.URI;
import java.nio.ByteBuffer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xerces.impl.dv.util.Base64;
import org.eclipse.higgins.idas.api.ITypedValue;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.api.model.ISimpleValueModel;
import org.eclipse.higgins.idas.api.model.IdASModelException;

public class SimpleValueModel implements ISimpleValueModel {
	private static SimpleDateFormat dateFormat_ = new SimpleDateFormat("yyyy-MM-dd");

	private static SimpleDateFormat dateTimeFormat_ = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

	private static SimpleDateFormat timeFormat_ = new SimpleDateFormat("HH:mm:ss");

	private static Log log = LogFactory.getLog(SimpleValueModel.class);

	private boolean isUnique = false;

	private URI type = null;

	private String shortType = null;

	private boolean isOneOf = false;

	private List<Object> oneOf = null;

	private String pattern = null;

	private int length = -1;

	private int minLength = -1;

	private int maxLength = -1;

	private int totalDigits = -1;

	private int fractionDigits = -1;

	private static final HashMap<String, ArrayList<Class>> xmlToJavas_ = new HashMap<String, ArrayList<Class>>();

	public int getFractionDigits() {
		return fractionDigits;
	}

	public int getLength() {
		return length;
	}

	public int getMaxLength() {
		return maxLength;
	}

	public int getMinLength() {
		return minLength;
	}

	public List<Object> getOneOf() {
		return oneOf;
	}

	public String getPattern() {
		return pattern;
	}

	public int getTotalDigits() {
		return totalDigits;
	}

	public boolean isOneOf() {
		return isOneOf;
	}

	public boolean isUnique() {
		return isUnique;
	}

	public boolean isSimple() {
		return true;
	}

	public String getShortFormType() {
		return shortType;
	}

	public URI getType() {
		return type;
	}

	public void setShortFormType(String shortType) {
		this.shortType = shortType;
	}

	public void setFractionDigits(int fractionDigits) {
		this.fractionDigits = fractionDigits;
	}

	public void setOneOf(boolean isOneOf) {
		this.isOneOf = isOneOf;
	}

	public void setUnique(boolean isUnique) {
		this.isUnique = isUnique;
	}

	public void setLength(int length) {
		this.length = length;
	}

	public void setMaxLength(int maxLength) {
		this.maxLength = maxLength;
	}

	public void setMinLength(int minLength) {
		this.minLength = minLength;
	}

	public void setOneOf(List<Object> oneOf) {
		this.oneOf = oneOf;
	}

	public void setPattern(String pattern) {
		this.pattern = pattern;
	}

	public void setTotalDigits(int totalDigits) {
		this.totalDigits = totalDigits;
	}

	public void setType(URI type) {
		this.type = type;
	}


	
	
	
	
	
	
	
	
	
	
	
	
	
//	public SimpleValueModel(ContextModel ctx, AttributeModel parent, DatatypeProperty property) throws IdASException {
//		this.ctx = ctx;
//		this.parent = parent;
//		this.property = property;
//		initialize();
//	}
//
//	private void initialize() throws IdASException {
//		initRange();
//		initIsUnique();
//		if (type == null)
//			throw new IdASException("Can not parse xml type of simple attribute " + parent.getType());
//	}
//
//	private void initRange() throws IdASException {
//		initRange(property);
//	}
//
//	private void initRange(OntProperty prop) throws IdASException {
//		OntResource r = prop.getRange();
//		if (r != null) {
//			if (r.isDataRange()) {
//				initAsOWL1_0(r);
//			} else {
//				Resource res = r.getRDFType();
//				if (res != null)
//					initAsOWL1_1(r);
//				else
//					initType(r.getURI());
//			}
//		} else {
//			Iterator itr = prop.listSubProperties();
//			while (itr.hasNext()) {
//				OntProperty p = (OntProperty) itr.next();
//				initRange(p);
//			}
//		}
//	}
//
//	private void initAsOWL1_0(OntResource r) throws IdASException {
//		oneOf = new ArrayList();
//		DataRange dr = r.asDataRange();
//		isOneOf = true;
//		for (Iterator itr = dr.listOneOf(); itr.hasNext();) {
//			Literal l = (Literal) itr.next();
//			RDFDatatype t = l.getDatatype();
//			initType(t.getURI());
//			oneOf.add(l.getValue());
//		}
//	}
//
//	private void initAsOWL1_1(OntResource r) throws IdASException {
//		StmtIterator itr = r.listProperties();
//		while (itr.hasNext()) {
//			Statement st = itr.nextStatement();
//			RDFNode node = st.getObject();
//			Literal val = node.isLiteral() ? (Literal) node.as(Literal.class) : null;
//			String prop = st.getPredicate().getURI();
//			if (HigginsVocabulary.OWL11_onDataRange.equals(prop)) {
//				if (node.isResource()) {
//					Resource res = (Resource) node.as(Resource.class);
//					initType(res.getURI());
//				}
//			} else if (HigginsVocabulary.OWL11_pattern.equals(prop)) {
//				pattern = val.getString();
//			} else if (HigginsVocabulary.OWL11_maxLength.equals(prop)) {
//				try {
//					maxLength = val.getInt();
//				} catch (Exception e) {
//					log.error("Can not parse maxLength for property " + parent.getType(), e);
//				}
//			} else if (HigginsVocabulary.OWL11_totalDigits.equals(prop)) {
//				try {
//					totalDigits = val.getInt();
//				} catch (Exception e) {
//					log.error("Can not parse totalDigits for property " + parent.getType(), e);
//				}
//			} else if (HigginsVocabulary.OWL11_fractionDigits.equals(prop)) {
//				try {
//					fractionDigits = val.getInt();
//				} catch (Exception e) {
//					log.error("Can not parse fractionDigits for property " + parent.getType(), e);
//				}
//			}
//		}
//	}
//
//	private void initType(String typeUri) throws IdASException {
//		if (type == null) {
//			try {
//				type = new URI(typeUri);
//			} catch (Exception e) {
//				log.error(e);
//				throw new IdASException(e);
//			}
//		} else if (typeUri.equals(type) == false) {
//			throw new IdASModelException("Datatype mismatch for enumerated values: Property=" + property.getURI() + " Datatype1=" + type.toString()
//					+ " Datatype2=" + typeUri);
//		}
//	}
//
//	private void initIsUnique() throws IdASException {
//		isUnique = property.isFunctionalProperty();
//	}
//
//	public boolean isSimple() {
//		return true;
//	}
//
	public boolean isValid(String lexicalForm) {
		try {
			Object value = toValueForm(lexicalForm);
			return isValidValue(value);
		} catch (IdASModelException e) {
			return false;
		}
	}

	public boolean isValidValue(Object valueForm) {
		try {
			return isCorrectType(valueForm);
		} catch (IdASException e) {
			log.error(e, e);
			return false;
		}
	}

	public String toLexicalForm(Object value) throws IdASModelException {
		if (value == null)
			return null;
		if (isCorrectType(value)) {
			try {
				return valueToString(value);
			} catch (Exception e) {
				throw new IdASModelException(e);
			}
		} else
			throw new IdASModelException("Incorrect type");
	}

	private String valueToString(Object obj) throws Exception {
		if (obj == null)
			return null;
		else {
			if (obj instanceof Date) {
				Date value = (Date) obj;
				if (ITypedValue.DATE_ATTR_VALUE_TYPE_URI_STR.equals(type)) {
					return dateFormat_.format(value);
				} else if (ITypedValue.DATETIME_ATTR_VALUE_TYPE_URI_STR.equals(type)) {
					return dateTimeFormat_.format(value);
				} else if (ITypedValue.TIME_ATTR_VALUE_TYPE_URI_STR.equals(type)) {
					return timeFormat_.format(value);
				}
			} else if (obj instanceof ByteBuffer) {
				ByteBuffer bb = (ByteBuffer) obj;
				return Base64.encode(bb.array());
			} else
				return obj.toString();
		}
		return null;
	}

	public Object toValueForm(String lexicalForm) throws IdASModelException {
		try {
			return objValue(lexicalForm);
		} catch (IdASModelException e) {
			throw e;
		} catch (Exception e) {
			throw new IdASModelException(e);
		}
	}

	private Object objValue(String lexicalForm) throws Exception {
		if (lexicalForm == null || lexicalForm.trim().length() == 0)
			return null;
		else {
			if (ITypedValue.STRING_ATTR_VALUE_TYPE_URI_STR.equals(type) || ITypedValue.NORMALIZEDSTRING_ATTR_VALUE_URI_STR.equals(type))
				return lexicalForm;
			if (ITypedValue.ANYURI_ATTR_VALUE_TYPE_URI_STR.equals(type))
				return new URI(lexicalForm);
			if (ITypedValue.BASE64BINARY_ATTR_VALUE_TYPE_URI_STR.equals(type) || ITypedValue.BYTE_ATTR_VALUE_TYPE_URI_STR.equals(type)) {
				byte[] data = Base64.decode(lexicalForm);
				ByteBuffer bb = ByteBuffer.allocate(data.length);
				bb.put(data);
				return bb;
			}
			if (ITypedValue.DATE_ATTR_VALUE_TYPE_URI_STR.equals(type))
				return dateFormat_.parse(lexicalForm);
			if (ITypedValue.DATETIME_ATTR_VALUE_TYPE_URI_STR.equals(type))
				return dateTimeFormat_.parse(lexicalForm);
			if (ITypedValue.TIME_ATTR_VALUE_TYPE_URI_STR.equals(type))
				return timeFormat_.parse(lexicalForm);
			if (ITypedValue.BOOLEAN_ATTR_VALUE_TYPE_URI_STR.equals(type))
				return Boolean.valueOf(lexicalForm);
			if (ITypedValue.BOOLEAN_ATTR_VALUE_TYPE_URI_STR.equals(type))
				return Boolean.valueOf(lexicalForm);
			if (ITypedValue.INT_ATTR_VALUE_TYPE_URI_STR.equals(type))
				return Integer.valueOf(lexicalForm);
			if (ITypedValue.DOUBLE_ATTR_VALUE_TYPE_URI_STR.equals(type))
				return Double.valueOf(lexicalForm);
			if (ITypedValue.FLOAT_ATTR_VALUE_TYPE_URI_STR.equals(type))
				return Float.valueOf(lexicalForm);
			if (ITypedValue.LONG_ATTR_VALUE_TYPE_URI_STR.equals(type))
				return Long.valueOf(lexicalForm);
			if (ITypedValue.SHORT_ATTR_VALUE_TYPE_URI_STR.equals(type))
				return Short.valueOf(lexicalForm);
			throw new IdASModelException("Mapping is not implemented for xml type " + type);
		}
	}

	private boolean isCorrectType(Object value) throws IdASModelException {
		if (value == null)
			return true;
		String xmlType = type.toString();
		if (xmlToJavas_.containsKey(xmlType)) {
			ArrayList classes = (ArrayList) xmlToJavas_.get(xmlType);
			for (int i = 0, k = classes.size(); i < k; i++) {
				Class clazz = (Class) classes.get(i);
				if (clazz.isInstance(value))
					return true;
			}
			return false;
		} else
			throw new IdASModelException("Unknown XML type :" + xmlType);
	}

	static {
		String[][] str = ITypedValue.typeMap;
		for (int i = 0, k = str.length; i < k; i++) {
			String xmlName = str[i][0];
			String javaName = str[i][1];
			Class cls = null;
			try {
				cls = Class.forName(javaName);
			} catch (ClassNotFoundException e) {
				e.printStackTrace();
			}
			ArrayList<Class> javaClasses = null;
			if (xmlToJavas_.containsKey(xmlName))
				javaClasses = xmlToJavas_.get(xmlName);
			else
				javaClasses = new ArrayList<Class>();
			xmlToJavas_.put(xmlName, javaClasses);
			javaClasses.add(cls);
		}
	}

	@Override
	public int hashCode() {
		final int PRIME = 31;
		int result = 1;
		result = PRIME * result + ((type == null) ? 0 : type.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		final SimpleValueModel other = (SimpleValueModel) obj;
		if (type == null) {
			if (other.type != null)
				return false;
		} else if (!type.equals(other.type))
			return false;
		return true;
	}

}
