/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.idas.cp.model;

import com.hp.hpl.jena.ontology.OntDocumentManager;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.cache.CacheProviderFactory;
import org.eclipse.higgins.cache.api.ICache;
import org.eclipse.higgins.cache.api.ICacheKey;
import org.eclipse.higgins.cache.api.key.CacheKey;
import org.eclipse.higgins.cache.nocache.NOCache;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.cp.model.impl.ContextModel;

public class ContextModelFactory {
    private static ContextModelFactory instance = new ContextModelFactory();
    private static ICache contextModelCache = CacheProviderFactory.getCacheProvider().getCache("ContextModelFactory.ContextModels");
    private static boolean isNoCache = contextModelCache instanceof NOCache;
    private Object cacheLock = "";
    private static Log log = LogFactory.getLog(ContextModelFactory.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void initSchema(String resourceName, String schemaURI) {
        block7: {
            OntDocumentManager odm = OntDocumentManager.getInstance();
            if (odm.getModel(schemaURI) == null) {
                try {
                    OntModel cachedModel = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
                    InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(resourceName);
                    if (is == null) break block7;
                    try {
                        cachedModel.read(is, schemaURI);
                    }
                    finally {
                        is.close();
                    }
                    if (!cachedModel.isEmpty()) {
                        odm.addModel(schemaURI, (Model)cachedModel);
                    }
                }
                catch (Exception e) {
                    log.error((Object)e, (Throwable)e);
                }
            }
        }
    }

    public static synchronized ContextModelFactory getInstance() {
        if (instance == null) {
            instance = new ContextModelFactory();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContextModel getContextModel(URI schemaURI, String fileName) throws IdASException {
        if (isNoCache) {
            return this.initContextModel(fileName);
        }
        Object object = this.cacheLock;
        synchronized (object) {
            CacheKey key = new CacheKey(schemaURI.toString());
            if (contextModelCache.isKeyInCache((ICacheKey)key)) {
                return (ContextModel)contextModelCache.get((ICacheKey)key);
            }
            ContextModel cm = this.initContextModel(fileName);
            contextModelCache.put((ICacheKey)key, (Object)cm);
            return cm;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ContextModel initContextModel(String fileName) throws IdASException {
        try {
            ContextModelFactory.initSchema("higgins.owl", "http://www.eclipse.org/higgins/ontologies/2008/6/higgins");
            OntModel model = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
            InputStream is = this.getClass().getResourceAsStream(fileName);
            if (is == null) {
                is = new FileInputStream(fileName);
            }
            try {
                model.read(is, null);
            }
            finally {
                is.close();
            }
            ContextModel cm = new ContextModel(model);
            model.close();
            return cm;
        }
        catch (Exception e) {
            throw new IdASException((Throwable)e);
        }
    }
}

