/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.idas.cp.model.impl;

import com.hp.hpl.jena.ontology.DatatypeProperty;
import com.hp.hpl.jena.ontology.ObjectProperty;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntProperty;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.higgins.idas.api.model.IAttributeModel;
import org.eclipse.higgins.idas.api.model.IEntityModel;
import org.eclipse.higgins.idas.api.model.IHasAttributeModel;
import org.eclipse.higgins.idas.api.model.IValueModel;
import org.eclipse.higgins.idas.api.model.IdASModelException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeModel
implements IAttributeModel {
    private URI type;
    private boolean isSimple;
    private ArrayList<IValueModel> ownValues;
    private String shortType;
    private ArrayList<IHasAttributeModel> owners;
    private String attributeMode;
    private ArrayList<IAttributeModel> subAttributes;
    private IAttributeModel superAttribute;

    public AttributeModel(OntModel model, DatatypeProperty property) throws URISyntaxException {
        this(model, (OntProperty)property);
        this.isSimple = true;
    }

    public AttributeModel(OntModel model, ObjectProperty property) throws URISyntaxException {
        this(model, (OntProperty)property);
        this.isSimple = false;
    }

    private AttributeModel(OntModel model, OntProperty property) throws URISyntaxException {
        this.type = new URI(property.getURI());
        this.shortType = model.shortForm(property.getURI());
        this.owners = new ArrayList();
        this.subAttributes = new ArrayList();
        this.ownValues = new ArrayList();
    }

    private void populateAllSubEntities(ArrayList<IHasAttributeModel> all, IEntityModel superEntity) throws IdASModelException {
        for (IEntityModel subEntity : superEntity.getSubEntityModels()) {
            all.add((IHasAttributeModel)subEntity);
            this.populateAllSubEntities(all, subEntity);
        }
    }

    private ArrayList<IHasAttributeModel> populateOwnersHierarchy(Iterator<IHasAttributeModel> hasAttrs) throws IdASModelException {
        ArrayList<IHasAttributeModel> all = new ArrayList<IHasAttributeModel>();
        while (hasAttrs.hasNext()) {
            IHasAttributeModel hasAttr = hasAttrs.next();
            all.add(hasAttr);
            if (!(hasAttr instanceof IEntityModel)) continue;
            this.populateAllSubEntities(all, (IEntityModel)hasAttr);
        }
        return all;
    }

    public String getAttributeMode() throws IdASModelException {
        boolean multyValuesMode = false;
        boolean singleValueMode = false;
        ArrayList<IHasAttributeModel> ownersHierarchy = this.populateOwnersHierarchy(this.owners.iterator());
        for (IHasAttributeModel ham : ownersHierarchy) {
            int max = ham.getMaxCardinality(this.type);
            if (max == 1) {
                singleValueMode = true;
                continue;
            }
            multyValuesMode = true;
        }
        if (singleValueMode && multyValuesMode) {
            return "MIXED_MODE";
        }
        if (singleValueMode) {
            return "SINGLE_VALUED_MODE";
        }
        return "MULTY_VALUED_MODE";
    }

    public List<IHasAttributeModel> getOwners() {
        return this.owners;
    }

    public void addOwner(IHasAttributeModel owner) {
        this.owners.add(owner);
    }

    public IValueModel getValueModel() throws IdASModelException {
        List<IValueModel> values = this.getValueModels();
        switch (values.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return values.get(0);
            }
        }
        throw new IdASModelException("Attribute model has more than one value model.");
    }

    public List<IValueModel> getValueModels() throws IdASModelException {
        HashSet<IValueModel> hs = new HashSet<IValueModel>();
        hs.addAll(this.getInheretedValueModels());
        hs.addAll(this.getOwnValueModels());
        return new ArrayList<IValueModel>(hs);
    }

    public boolean isSimple() {
        return this.isSimple;
    }

    public String getShortFormType() {
        return this.shortType;
    }

    public URI getType() {
        return this.type;
    }

    public List<IAttributeModel> getSubAttributes() {
        return this.subAttributes;
    }

    public IAttributeModel getSuperAttribute() {
        return this.superAttribute;
    }

    public List<IValueModel> getInheretedValueModels() throws IdASModelException {
        if (this.superAttribute != null) {
            return this.superAttribute.getValueModels();
        }
        return Collections.emptyList();
    }

    public List<IValueModel> getOwnValueModels() {
        return this.ownValues;
    }

    public void addOwnValueModel(IValueModel model) {
        this.ownValues.add(model);
    }

    public void addSubAttributeModel(IAttributeModel model) {
        this.subAttributes.add(model);
    }

    public void setSuperAttributeModel(IAttributeModel model) {
        this.superAttribute = model;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AttributeModel other = (AttributeModel)obj;
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }
}

