/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.idas.cp.model.impl;

import com.hp.hpl.jena.ontology.OntModel;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.api.model.IAttributeModel;
import org.eclipse.higgins.idas.api.model.IContextModel;
import org.eclipse.higgins.idas.api.model.IEntityModel;
import org.eclipse.higgins.idas.api.model.IModel;
import org.eclipse.higgins.idas.api.model.IdASModelException;
import org.eclipse.higgins.idas.cp.model.impl.AttributeModel;
import org.eclipse.higgins.idas.cp.model.impl.EntityModel;
import org.eclipse.higgins.idas.cp.model.util.ContextBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextModel
implements IContextModel {
    private URI baseURI;
    private String shortType;
    private HashMap<String, EntityModel> entityByType;
    private HashMap<String, AttributeModel> attributeByType;
    private IEntityModel context;

    public ContextModel(OntModel model) throws IdASException, URISyntaxException {
        URI baseURI;
        this.baseURI = baseURI = new URI("urn:test");
        ContextBuilder cb = new ContextBuilder(model);
        cb.buildContext();
        this.entityByType = cb.getEntityModels();
        this.context = this.entityByType.remove("http://www.eclipse.org/higgins/ontologies/2008/6/higgins#Context");
        this.attributeByType = cb.getAttributeModels();
        this.shortType = model.shortForm(baseURI.toString());
    }

    public AttributeModel getPPIDAttribute() {
        return null;
    }

    public IEntityModel getEntityModel(URI entityType) {
        return this.entityByType.get(entityType.toString());
    }

    public List<IEntityModel> getEntityModels() {
        return new ArrayList<IEntityModel>(this.entityByType.values());
    }

    public IModel getModel(URI type) {
        if (type == null) {
            return null;
        }
        IModel model = (IModel)this.entityByType.get(type.toString());
        if (model == null) {
            model = (IModel)this.attributeByType.get(type.toString());
        }
        return model;
    }

    public String getShortFormType() {
        return this.shortType;
    }

    public URI getType() {
        return this.baseURI;
    }

    public IAttributeModel getAttributeModel(URI attrID) throws IdASModelException {
        return this.context.getAttributeModel(attrID);
    }

    public List<IAttributeModel> getAttributeModels() throws IdASModelException {
        return this.context.getAttributeModels();
    }

    public List<IAttributeModel> getInheritedAttributeModels() throws IdASModelException {
        return this.context.getInheritedAttributeModels();
    }

    public int getMaxCardinality(URI attributeType) throws IdASModelException {
        return this.context.getMaxCardinality(attributeType);
    }

    public int getMinCardinality(URI attributeType) throws IdASModelException {
        return this.context.getMinCardinality(attributeType);
    }

    public List<IAttributeModel> getOwnAttributeModels() throws IdASModelException {
        return this.context.getOwnAttributeModels();
    }
}

