/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.idas.cp.model.impl;

import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.api.model.IAttributeModel;
import org.eclipse.higgins.idas.api.model.IEntityModel;
import org.eclipse.higgins.idas.api.model.IdASModelException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityModel
implements IEntityModel {
    private URI type;
    private HashMap<URI, IAttributeModel> ownAttributes;
    private HashMap<URI, Integer> minCardinalityMap;
    private HashMap<URI, Integer> maxCardinalityMap;
    private String shortType;
    private EntityModel superModel;
    private ArrayList<IEntityModel> subModels;

    public EntityModel(OntModel model, OntClass entityClass) throws IdASException {
        this.type = URI.create(entityClass.getURI());
        this.shortType = model.shortForm(entityClass.getURI());
        this.ownAttributes = new HashMap();
        this.minCardinalityMap = new HashMap();
        this.maxCardinalityMap = new HashMap();
        this.subModels = new ArrayList();
    }

    public List<IEntityModel> getSubEntityModels() {
        return this.subModels;
    }

    public IEntityModel getSuperEntityModel() {
        return this.superModel;
    }

    public boolean isSimple() {
        return false;
    }

    public String getShortFormType() {
        return this.shortType;
    }

    public URI getType() {
        return this.type;
    }

    public IAttributeModel getAttributeModel(URI attrID) {
        IAttributeModel res = this.ownAttributes.get(attrID);
        if (res == null && this.superModel != null) {
            res = this.superModel.getAttributeModel(attrID);
        }
        return res;
    }

    public List<IAttributeModel> getAttributeModels() {
        HashSet<IAttributeModel> attrs = new HashSet<IAttributeModel>();
        attrs.addAll(this.getInheritedAttributeModels());
        attrs.addAll(this.getOwnAttributeModels());
        return new ArrayList<IAttributeModel>(attrs);
    }

    public List<IAttributeModel> getInheritedAttributeModels() {
        if (this.superModel == null) {
            return Collections.emptyList();
        }
        return this.superModel.getAttributeModels();
    }

    public List<IAttributeModel> getOwnAttributeModels() {
        return new ArrayList<IAttributeModel>(this.ownAttributes.values());
    }

    public Integer getCurrentEntityMaxCardinality(URI attributeType) {
        return this.maxCardinalityMap.get(attributeType);
    }

    public Integer getCurrentEntityMinCardinality(URI attributeType) {
        return this.minCardinalityMap.get(attributeType);
    }

    public int getMaxCardinality(URI attributeType) {
        Integer crd = this.getCurrentEntityMaxCardinality(attributeType);
        if (crd == null && this.superModel != null) {
            crd = this.superModel.getCurrentEntityMaxCardinality(attributeType);
        }
        return crd != null ? crd : 0;
    }

    public int getMinCardinality(URI attributeType) {
        Integer crd = this.getCurrentEntityMinCardinality(attributeType);
        if (crd == null && this.superModel != null) {
            crd = this.superModel.getCurrentEntityMinCardinality(attributeType);
        }
        return crd != null ? crd : 0;
    }

    public void addSubEntityModel(EntityModel subEntity) {
        this.subModels.add(subEntity);
    }

    public void setSuperEntityModel(EntityModel superEntity) {
        this.superModel = superEntity;
    }

    public void addAttribute(IAttributeModel attribute) throws IdASModelException {
        this.ownAttributes.put(attribute.getType(), attribute);
    }

    public void addMaxCardinality(URI attrType, int maxCardinality) {
        this.maxCardinalityMap.put(attrType, new Integer(maxCardinality));
    }

    public void addMinCardinality(URI attrType, int minCardinality) {
        this.minCardinalityMap.put(attrType, new Integer(minCardinality));
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EntityModel other = (EntityModel)obj;
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }
}

