/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.idas.cp.model.impl;

import java.net.URI;
import java.nio.ByteBuffer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xerces.impl.dv.util.Base64;
import org.eclipse.higgins.idas.api.ITypedValue;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.api.model.ISimpleValueModel;
import org.eclipse.higgins.idas.api.model.IdASModelException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleValueModel
implements ISimpleValueModel {
    private static SimpleDateFormat dateFormat_ = new SimpleDateFormat("yyyy-MM-dd");
    private static SimpleDateFormat dateTimeFormat_ = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static SimpleDateFormat timeFormat_ = new SimpleDateFormat("HH:mm:ss");
    private static Log log = LogFactory.getLog(SimpleValueModel.class);
    private boolean isUnique = false;
    private URI type = null;
    private String shortType = null;
    private boolean isOneOf = false;
    private List<Object> oneOf = null;
    private String pattern = null;
    private int length = -1;
    private int minLength = -1;
    private int maxLength = -1;
    private int totalDigits = -1;
    private int fractionDigits = -1;
    private static final HashMap<String, ArrayList<Class>> xmlToJavas_ = new HashMap();

    public int getFractionDigits() {
        return this.fractionDigits;
    }

    public int getLength() {
        return this.length;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public int getMinLength() {
        return this.minLength;
    }

    public List<Object> getOneOf() {
        return this.oneOf;
    }

    public String getPattern() {
        return this.pattern;
    }

    public int getTotalDigits() {
        return this.totalDigits;
    }

    public boolean isOneOf() {
        return this.isOneOf;
    }

    public boolean isUnique() {
        return this.isUnique;
    }

    public boolean isSimple() {
        return true;
    }

    public String getShortFormType() {
        return this.shortType;
    }

    public URI getType() {
        return this.type;
    }

    public void setShortFormType(String shortType) {
        this.shortType = shortType;
    }

    public void setFractionDigits(int fractionDigits) {
        this.fractionDigits = fractionDigits;
    }

    public void setOneOf(boolean isOneOf) {
        this.isOneOf = isOneOf;
    }

    public void setUnique(boolean isUnique) {
        this.isUnique = isUnique;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
    }

    public void setMinLength(int minLength) {
        this.minLength = minLength;
    }

    public void setOneOf(List<Object> oneOf) {
        this.oneOf = oneOf;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public void setTotalDigits(int totalDigits) {
        this.totalDigits = totalDigits;
    }

    public void setType(URI type) {
        this.type = type;
    }

    public boolean isValid(String lexicalForm) {
        try {
            Object value = this.toValueForm(lexicalForm);
            return this.isValidValue(value);
        }
        catch (IdASModelException e) {
            return false;
        }
    }

    public boolean isValidValue(Object valueForm) {
        try {
            return this.isCorrectType(valueForm);
        }
        catch (IdASException e) {
            log.error((Object)e, (Throwable)e);
            return false;
        }
    }

    public String toLexicalForm(Object value) throws IdASModelException {
        if (value == null) {
            return null;
        }
        if (this.isCorrectType(value)) {
            try {
                return this.valueToString(value);
            }
            catch (Exception e) {
                throw new IdASModelException((Throwable)e);
            }
        }
        throw new IdASModelException("Incorrect type");
    }

    private String valueToString(Object obj) throws Exception {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Date) {
            Date value = (Date)obj;
            if ("http://www.w3.org/2001/XMLSchema#date".equals(this.type)) {
                return dateFormat_.format(value);
            }
            if ("http://www.w3.org/2001/XMLSchema#dateTime".equals(this.type)) {
                return dateTimeFormat_.format(value);
            }
            if ("http://www.w3.org/2001/XMLSchema#time".equals(this.type)) {
                return timeFormat_.format(value);
            }
        } else {
            if (obj instanceof ByteBuffer) {
                ByteBuffer bb = (ByteBuffer)obj;
                return Base64.encode((byte[])bb.array());
            }
            return obj.toString();
        }
        return null;
    }

    public Object toValueForm(String lexicalForm) throws IdASModelException {
        try {
            return this.objValue(lexicalForm);
        }
        catch (IdASModelException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IdASModelException((Throwable)e);
        }
    }

    private Object objValue(String lexicalForm) throws Exception {
        if (lexicalForm == null || lexicalForm.trim().length() == 0) {
            return null;
        }
        if ("http://www.w3.org/2001/XMLSchema#string".equals(this.type) || "http://www.eclipse.org/higgins/ontologies/2008/6/higgins#normalizedStringSimpleValue".equals(this.type)) {
            return lexicalForm;
        }
        if ("http://www.w3.org/2001/XMLSchema#anyURI".equals(this.type)) {
            return new URI(lexicalForm);
        }
        if ("http://www.w3.org/2001/XMLSchema#base64Binary".equals(this.type) || "http://www.w3.org/2001/XMLSchema#byte".equals(this.type)) {
            byte[] data = Base64.decode((String)lexicalForm);
            ByteBuffer bb = ByteBuffer.allocate(data.length);
            bb.put(data);
            return bb;
        }
        if ("http://www.w3.org/2001/XMLSchema#date".equals(this.type)) {
            return dateFormat_.parse(lexicalForm);
        }
        if ("http://www.w3.org/2001/XMLSchema#dateTime".equals(this.type)) {
            return dateTimeFormat_.parse(lexicalForm);
        }
        if ("http://www.w3.org/2001/XMLSchema#time".equals(this.type)) {
            return timeFormat_.parse(lexicalForm);
        }
        if ("http://www.w3.org/2001/XMLSchema#boolean".equals(this.type)) {
            return Boolean.valueOf(lexicalForm);
        }
        if ("http://www.w3.org/2001/XMLSchema#boolean".equals(this.type)) {
            return Boolean.valueOf(lexicalForm);
        }
        if ("http://www.w3.org/2001/XMLSchema#int".equals(this.type)) {
            return Integer.valueOf(lexicalForm);
        }
        if ("http://www.w3.org/2001/XMLSchema#double".equals(this.type)) {
            return Double.valueOf(lexicalForm);
        }
        if ("http://www.w3.org/2001/XMLSchema#float".equals(this.type)) {
            return Float.valueOf(lexicalForm);
        }
        if ("http://www.w3.org/2001/XMLSchema#long".equals(this.type)) {
            return Long.valueOf(lexicalForm);
        }
        if ("http://www.w3.org/2001/XMLSchema#short".equals(this.type)) {
            return Short.valueOf(lexicalForm);
        }
        throw new IdASModelException("Mapping is not implemented for xml type " + this.type);
    }

    private boolean isCorrectType(Object value) throws IdASModelException {
        if (value == null) {
            return true;
        }
        String xmlType = this.type.toString();
        if (xmlToJavas_.containsKey(xmlType)) {
            ArrayList<Class> classes = xmlToJavas_.get(xmlType);
            int k = classes.size();
            for (int i = 0; i < k; ++i) {
                Class clazz = classes.get(i);
                if (!clazz.isInstance(value)) continue;
                return true;
            }
            return false;
        }
        throw new IdASModelException("Unknown XML type :" + xmlType);
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SimpleValueModel other = (SimpleValueModel)obj;
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }

    static {
        String[][] str = ITypedValue.typeMap;
        int k = str.length;
        for (int i = 0; i < k; ++i) {
            String xmlName = str[i][0];
            String javaName = str[i][1];
            Class<?> cls = null;
            try {
                cls = Class.forName(javaName);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            ArrayList<Object> javaClasses = null;
            javaClasses = xmlToJavas_.containsKey(xmlName) ? xmlToJavas_.get(xmlName) : new ArrayList();
            xmlToJavas_.put(xmlName, javaClasses);
            javaClasses.add(cls);
        }
    }
}

