/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.idas.cp.model.util;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.ontology.CardinalityRestriction;
import com.hp.hpl.jena.ontology.DataRange;
import com.hp.hpl.jena.ontology.DatatypeProperty;
import com.hp.hpl.jena.ontology.ObjectProperty;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntProperty;
import com.hp.hpl.jena.ontology.OntResource;
import com.hp.hpl.jena.ontology.Restriction;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.RDFList;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.api.model.IAttributeModel;
import org.eclipse.higgins.idas.api.model.IEntityModel;
import org.eclipse.higgins.idas.api.model.IHasAttributeModel;
import org.eclipse.higgins.idas.api.model.IModel;
import org.eclipse.higgins.idas.api.model.IValueModel;
import org.eclipse.higgins.idas.api.model.IdASModelException;
import org.eclipse.higgins.idas.cp.model.impl.AttributeModel;
import org.eclipse.higgins.idas.cp.model.impl.EntityModel;
import org.eclipse.higgins.idas.cp.model.impl.SimpleValueModel;
import org.eclipse.higgins.idas.cp.model.util.HigginsVocabulary;
import org.eclipse.higgins.idas.cp.model.util.ModelUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextBuilder {
    private static Log log = LogFactory.getLog(ContextBuilder.class);
    OntModel model;
    HigginsVocabulary vocabulary;
    HashMap<String, EntityModel> entityByType = new HashMap();
    HashMap<String, AttributeModel> attributeByType = new HashMap();

    public ContextBuilder(OntModel model) throws IdASException, URISyntaxException {
        this.model = model;
        this.vocabulary = new HigginsVocabulary(model);
    }

    public void buildContext() throws IdASException, URISyntaxException {
        log.trace((Object)"ContextBuilder.buildContext()");
        this.parseEntities();
        this.buildEntiesHierarchy();
        this.parseSimpleAttributes();
        this.parseComplexAttributes();
        this.buildAttributesHierarchy();
        this.linkEntiesToAttributes();
        if (log.isDebugEnabled()) {
            this.printEntitiesDebugInfo();
        }
    }

    public HashMap<String, EntityModel> getEntityModels() {
        return this.entityByType;
    }

    public HashMap<String, AttributeModel> getAttributeModels() {
        return this.attributeByType;
    }

    private void parseEntities() throws IdASException {
        ExtendedIterator classes = this.model.listNamedClasses();
        log.debug((Object)"Initialize entities : ");
        while (classes.hasNext()) {
            OntClass cls = (OntClass)classes.next();
            log.debug((Object)("\t" + cls.getURI()));
            EntityModel em = new EntityModel(this.model, cls);
            this.entityByType.put(cls.getURI(), em);
        }
    }

    private void buildEntiesHierarchy() throws URISyntaxException, IdASException {
        ExtendedIterator classes = this.model.listNamedClasses();
        while (classes.hasNext()) {
            OntClass cls = (OntClass)classes.next();
            EntityModel model = this.entityByType.get(cls.getURI());
            this.setSuperEntityModel(cls, model);
            this.setSubEntityModels(cls, model);
            this.initCardinality(cls, model);
        }
    }

    private void setSuperEntityModel(OntClass cls, EntityModel model) throws IdASException {
        OntClass parent = ModelUtils.getSuperClass(cls);
        if (parent != null) {
            if (!"http://www.w3.org/2002/07/owl#Thing".equals(parent.getURI())) {
                EntityModel superEntity = this.entityByType.get(parent.getURI());
                model.setSuperEntityModel(superEntity);
            }
        }
    }

    private void setSubEntityModels(OntClass cls, EntityModel model) {
        ExtendedIterator subItr = cls.listSubClasses();
        while (subItr.hasNext()) {
            OntClass subClass = (OntClass)subItr.next();
            String subType = subClass.getURI();
            EntityModel subModel = this.entityByType.get(subType);
            model.addSubEntityModel(subModel);
        }
    }

    private void initCardinality(OntClass cls, EntityModel model) throws URISyntaxException, IdASModelException {
        ExtendedIterator itr = cls.listSuperClasses();
        while (itr.hasNext()) {
            CardinalityRestriction cr;
            OntClass c = (OntClass)itr.next();
            if (!c.isRestriction()) continue;
            Restriction r = c.asRestriction();
            OntProperty onProp = r.getOnProperty();
            if (onProp == null) {
                throw new IdASModelException("Class " + cls.getURI() + " contains restriction to incorrect property.");
            }
            URI attrType = new URI(onProp.getURI());
            if (r.isCardinalityRestriction()) {
                cr = r.asCardinalityRestriction();
                int crdValue = cr.getCardinality();
                model.addMaxCardinality(attrType, crdValue);
                model.addMinCardinality(attrType, crdValue);
                continue;
            }
            if (r.isMaxCardinalityRestriction()) {
                cr = r.asMaxCardinalityRestriction();
                model.addMaxCardinality(attrType, cr.getMaxCardinality());
                continue;
            }
            if (!r.isMinCardinalityRestriction()) continue;
            cr = r.asMinCardinalityRestriction();
            model.addMinCardinality(attrType, cr.getMinCardinality());
        }
    }

    private void parseComplexAttributes() throws URISyntaxException {
        log.debug((Object)"Initialize complex attributes:");
        ExtendedIterator objProps = this.model.listObjectProperties();
        while (objProps.hasNext()) {
            ObjectProperty prop = (ObjectProperty)objProps.next();
            if (log.isDebugEnabled()) {
                log.debug((Object)("\t\t" + prop.getURI()));
            }
            AttributeModel attr = new AttributeModel(this.model, prop);
            this.attributeByType.put(prop.getURI(), attr);
        }
    }

    private void parseSimpleAttributes() throws URISyntaxException {
        log.debug((Object)"Initialize simple attributes:");
        ExtendedIterator dtProps = this.model.listDatatypeProperties();
        while (dtProps.hasNext()) {
            DatatypeProperty prop = (DatatypeProperty)dtProps.next();
            if (log.isDebugEnabled()) {
                log.debug((Object)("\t\t" + prop.getURI()));
            }
            AttributeModel attr = new AttributeModel(this.model, prop);
            this.attributeByType.put(prop.getURI(), attr);
        }
    }

    private void buildAttributesHierarchy() {
        ExtendedIterator props = this.model.listOntProperties();
        while (props.hasNext()) {
            OntProperty prop = (OntProperty)props.next();
            AttributeModel attr = this.attributeByType.get(prop.getURI());
            OntProperty superProp = prop.getSuperProperty();
            if (superProp == null) continue;
            AttributeModel superAttr = this.attributeByType.get(superProp.getURI());
            attr.setSuperAttributeModel(superAttr);
        }
    }

    private void setAttributeOwners(Iterator props) throws IdASModelException {
        while (props.hasNext()) {
            OntProperty prop = (OntProperty)props.next();
            String attrType = prop.getURI();
            AttributeModel attr = this.attributeByType.get(attrType);
            ExtendedIterator domens = prop.listDomain();
            while (domens.hasNext()) {
                Object obj = domens.next();
                if (!(obj instanceof OntClass)) continue;
                OntClass domain = (OntClass)obj;
                String entityType = domain.getURI();
                EntityModel ownerEntity = this.entityByType.get(entityType);
                if (ownerEntity == null) {
                    throw new IdASModelException("Property " + attrType + " has non-existent domain class " + entityType);
                }
                attr.addOwner((IHasAttributeModel)ownerEntity);
                ownerEntity.addAttribute(attr);
            }
        }
    }

    private void linkEntiesToAttributes() throws IdASModelException {
        this.setAttributeOwners((Iterator)this.model.listDatatypeProperties());
        this.setAttributeOwners((Iterator)this.model.listObjectProperties());
        this.linkComplexValues();
        this.buildSimpleValues();
    }

    private void linkComplexValues() throws IdASModelException {
        ExtendedIterator props = this.model.listObjectProperties();
        while (props.hasNext()) {
            ObjectProperty prop = (ObjectProperty)props.next();
            AttributeModel attr = this.attributeByType.get(prop.getURI());
            ExtendedIterator ranges = prop.listRange();
            while (ranges.hasNext()) {
                OntResource range = (OntResource)ranges.next();
                if (range.isClass()) {
                    String entityType = range.getURI();
                    EntityModel em = this.entityByType.get(entityType);
                    attr.addOwnValueModel((IValueModel)em);
                    continue;
                }
                throw new IdASModelException("Property " + prop.getURI() + " has wrong range.");
            }
        }
    }

    private void buildSimpleValues() throws IdASModelException {
        ExtendedIterator props = this.model.listDatatypeProperties();
        while (props.hasNext()) {
            OntProperty prop = (OntProperty)props.next();
            String attrType = prop.getURI();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Build simple value(s) for attribute " + attrType));
            }
            AttributeModel attr = this.attributeByType.get(attrType);
            ExtendedIterator ranges = prop.listRange();
            while (ranges.hasNext()) {
                OntResource range = (OntResource)ranges.next();
                SimpleValueModel sv = this.initByRange(prop.getURI(), range);
                attr.addOwnValueModel((IValueModel)sv);
            }
        }
    }

    private SimpleValueModel initByRange(String attrType, OntResource range) throws IdASModelException {
        if (range.isDataRange()) {
            return this.initAsOWL1_0(attrType, range);
        }
        Resource res = range.getRDFType();
        if (res != null) {
            return this.initAsOWL1_1(attrType, range);
        }
        SimpleValueModel sv = new SimpleValueModel();
        this.initType(attrType, sv, range.getURI());
        return sv;
    }

    private SimpleValueModel initAsOWL1_0(String attrType, OntResource r) throws IdASModelException {
        SimpleValueModel sv = new SimpleValueModel();
        sv.setOneOf(true);
        ArrayList<Object> oneOf = new ArrayList<Object>();
        sv.setOneOf(oneOf);
        DataRange dr = r.asDataRange();
        RDFList rdfList = dr.getOneOf();
        ExtendedIterator itr = dr.listOneOf();
        while (itr.hasNext()) {
            Literal l = (Literal)itr.next();
            RDFDatatype t = l.getDatatype();
            this.initType(attrType, sv, t.getURI());
            oneOf.add(l.getValue());
        }
        return sv;
    }

    private SimpleValueModel initAsOWL1_1(String attrType, OntResource r) throws IdASModelException {
        SimpleValueModel sv = new SimpleValueModel();
        StmtIterator itr = r.listProperties();
        while (itr.hasNext()) {
            Statement st = itr.nextStatement();
            RDFNode node = st.getObject();
            Literal val = node.isLiteral() ? (Literal)node.as(Literal.class) : null;
            String prop = st.getPredicate().getURI();
            if ("http://www.w3.org/2006/12/owl11#onDataRange".equals(prop)) {
                if (!node.isResource()) continue;
                Resource res = (Resource)node.as(Resource.class);
                this.initType(attrType, sv, res.getURI());
                continue;
            }
            if ("http://www.w3.org/2006/12/owl11#pattern".equals(prop)) {
                sv.setPattern(val.getString());
                continue;
            }
            if ("http://www.w3.org/2006/12/owl11#maxLength".equals(prop)) {
                try {
                    sv.setMaxLength(val.getInt());
                }
                catch (Exception e) {
                    log.error((Object)("Can not parse maxLength for property " + attrType), (Throwable)e);
                }
                continue;
            }
            if ("http://www.w3.org/2006/12/owl11#minLength".equals(prop)) {
                try {
                    sv.setMinLength(val.getInt());
                }
                catch (Exception e) {
                    log.error((Object)("Can not parse maxLength for property " + attrType), (Throwable)e);
                }
                continue;
            }
            if ("http://www.w3.org/2006/12/owl11#length".equals(prop)) {
                try {
                    sv.setLength(val.getInt());
                }
                catch (Exception e) {
                    log.error((Object)("Can not parse maxLength for property " + attrType), (Throwable)e);
                }
                continue;
            }
            if ("http://www.w3.org/2006/12/owl11#".equals(prop)) {
                try {
                    sv.setTotalDigits(val.getInt());
                }
                catch (Exception e) {
                    log.error((Object)("Can not parse totalDigits for property " + attrType), (Throwable)e);
                }
                continue;
            }
            if (!"http://www.w3.org/2006/12/owl11#fractionDigits".equals(prop)) continue;
            try {
                sv.setFractionDigits(val.getInt());
            }
            catch (Exception e) {
                log.error((Object)("Can not parse fractionDigits for property " + attrType), (Throwable)e);
            }
        }
        return sv;
    }

    private void initType(String attrType, SimpleValueModel sv, String typeUri) throws IdASModelException {
        URI type = sv.getType();
        if (type == null) {
            try {
                type = new URI(typeUri);
                sv.setType(type);
                String shortType = this.model.shortForm(typeUri);
                sv.setShortFormType(shortType);
            }
            catch (Exception e) {
                throw new IdASModelException((Throwable)e);
            }
        } else if (!typeUri.equals(type.toString())) {
            throw new IdASModelException("Datatype mismatch for enumerated values: Property=" + attrType + " Datatype1=" + type.toString() + " Datatype2=" + typeUri);
        }
    }

    private void printEntitiesDebugInfo() throws IdASException {
        ArrayList<EntityModel> entityList = new ArrayList<EntityModel>(this.entityByType.values());
        Collections.sort(entityList, new ModelComparator());
        int size = entityList.size();
        for (int i = 0; i < size; ++i) {
            EntityModel em = entityList.get(i);
            log.debug((Object)("ENTITY # " + (i + 1)));
            log.debug((Object)("\ttype: " + em.getType().toString()));
            log.debug((Object)("\tsuper entity : " + (em.getSuperEntityModel() == null ? "none" : em.getSuperEntityModel().getType().toString())));
            log.debug((Object)"\tsub entities :");
            Iterator<IEntityModel> itrSub = em.getSubEntityModels().iterator();
            while (itrSub.hasNext()) {
                log.debug((Object)("\t\t" + itrSub.next().getType().toString()));
            }
            log.debug((Object)"\tattributes :");
            Iterator<IAttributeModel> itrAttr = em.getOwnAttributeModels().iterator();
            while (itrAttr.hasNext()) {
                log.debug((Object)("\t\t" + itrAttr.next().getType().toString()));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ModelComparator
    implements Comparator<IModel> {
        private ModelComparator() {
        }

        @Override
        public int compare(IModel o1, IModel o2) {
            try {
                String type1 = o1.getType().toString();
                String type2 = o1.getType().toString();
                return type2.compareTo(type1);
            }
            catch (IdASException e) {
                log.error((Object)e, (Throwable)e);
                return -1;
            }
        }
    }
}

