/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.idas.cp.model.util;

import com.hp.hpl.jena.ontology.CardinalityRestriction;
import com.hp.hpl.jena.ontology.MaxCardinalityRestriction;
import com.hp.hpl.jena.ontology.MinCardinalityRestriction;
import com.hp.hpl.jena.ontology.ObjectProperty;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntProperty;
import com.hp.hpl.jena.ontology.OntResource;
import com.hp.hpl.jena.ontology.Restriction;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.api.model.IdASModelException;

public class ModelUtils {
    private static Log log = LogFactory.getLog(ModelUtils.class);

    public static boolean isClassRelative(OntClass ancestor, OntClass descendant) throws IdASException {
        if (ancestor.equals(descendant)) {
            return true;
        }
        try {
            ExtendedIterator itr = descendant.listSuperClasses();
            while (itr.hasNext()) {
                OntClass cls = (OntClass)itr.next();
                if (!ModelUtils.isClassRelative(ancestor, cls)) continue;
                return true;
            }
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new IdASException(e.getMessage());
        }
        return false;
    }

    public static boolean isPropertyRelative(OntProperty ancestor, OntProperty descendant) throws IdASException {
        if (ancestor == null || descendant == null) {
            return false;
        }
        if (ancestor.getURI().equals(descendant.getURI())) {
            return true;
        }
        try {
            for (OntProperty tmpDescendant = descendant; tmpDescendant != null; tmpDescendant = tmpDescendant.getSuperProperty()) {
                if (!tmpDescendant.hasSuperProperty((Property)ancestor, false)) continue;
                return true;
            }
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new IdASException(e.getMessage());
        }
        return false;
    }

    private static void fillListSubClasses(List list, OntClass cls) {
        ExtendedIterator ei = cls.listSubClasses();
        while (ei.hasNext()) {
            OntClass child = (OntClass)ei.next();
            if (child == null || child.isRestriction()) continue;
            list.add(cls);
            ModelUtils.fillListSubClasses(list, cls);
        }
    }

    public static OntClass getSuperClass(OntClass clazz) throws IdASException {
        ExtendedIterator itr = clazz.listSuperClasses();
        while (itr.hasNext()) {
            OntClass cls = (OntClass)itr.next();
            if (cls.isRestriction()) continue;
            return cls;
        }
        return null;
    }

    public static List getListSuperClasses(OntClass ownerClass) throws IdASException {
        ArrayList<OntClass> classesList = new ArrayList<OntClass>();
        OntClass superClass = ModelUtils.getSuperClass(ownerClass);
        while (superClass != null) {
            classesList.add(superClass);
            superClass = ModelUtils.getSuperClass(superClass);
        }
        return classesList;
    }

    public static boolean isPropertyOfClass(OntClass ownerClass, OntProperty property) throws IdASException {
        ArrayList<OntClass> classesList = new ArrayList<OntClass>();
        classesList.add(ownerClass);
        classesList.addAll(ModelUtils.getListSuperClasses(ownerClass));
        for (int i = 0; i < classesList.size(); ++i) {
            OntClass ontClass = (OntClass)classesList.get(i);
            ExtendedIterator ei = property.listDomain();
            while (ei.hasNext()) {
                Object entity = ei.next();
                if (!(entity instanceof OntClass)) continue;
                OntClass domain = (OntClass)entity;
                if (!ontClass.getURI().equals(domain.getURI())) continue;
                return true;
            }
        }
        return false;
    }

    public static ArrayList getPropertiesByDomain(OntModel model, OntClass domainClass) throws IdASException {
        ArrayList<OntProperty> list = new ArrayList<OntProperty>();
        List subClasses = ModelUtils.getListSuperClasses(domainClass);
        Property domain = model.getProperty("http://www.w3.org/2000/01/rdf-schema#domain");
        int size = subClasses.size();
        for (int i = 0; i < size; ++i) {
            OntClass cls = (OntClass)subClasses.get(i);
            if (cls == null) continue;
            StmtIterator ei = model.listStatements(null, domain, (RDFNode)cls);
            while (ei.hasNext()) {
                OntProperty property = model.getOntProperty(ei.nextStatement().getSubject().getURI());
                list.add(property);
            }
        }
        return list;
    }

    public static OntClass getRangeClass(OntModel model, ObjectProperty property) throws IdASException {
        try {
            ExtendedIterator ranges = property.listRange();
            ArrayList<RDFNode> al = new ArrayList<RDFNode>();
            while (ranges.hasNext()) {
                OntResource range = (OntResource)ranges.next();
                if (!range.isClass()) continue;
                al.add(range.as(OntClass.class));
            }
            if (al.size() == 0) {
                return null;
            }
            if (al.size() == 1) {
                return (OntClass)al.get(0);
            }
            throw new IdASModelException("The current model implementation does not support multiple attribute value types. " + property.getURI());
        }
        catch (IdASException e) {
            throw e;
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            throw new IdASModelException((Throwable)e);
        }
    }

    public static ArrayList getInheritedPropertiesByDomain(OntModel model, OntClass domainClass) throws IdASException {
        ArrayList list = new ArrayList();
        List subClasses = ModelUtils.getListSuperClasses(domainClass);
        int size = subClasses.size();
        for (int i = 0; i < size; ++i) {
            OntClass cls = (OntClass)subClasses.get(i);
            list.addAll(ModelUtils.getOwnPropertiesByDomain(model, cls));
        }
        return list;
    }

    public static ArrayList getOwnPropertiesByDomain(OntModel model, OntClass domainClass) throws IdASException {
        ArrayList<OntProperty> list = new ArrayList<OntProperty>();
        Property domain = model.getProperty("http://www.w3.org/2000/01/rdf-schema#domain");
        StmtIterator ei = model.listStatements(null, domain, (RDFNode)domainClass);
        while (ei.hasNext()) {
            OntProperty property = model.getOntProperty(ei.nextStatement().getSubject().getURI());
            list.add(property);
        }
        return list;
    }

    public static int getMaxCardinality(OntClass cls, OntProperty attr) throws IdASException {
        ArrayList<OntClass> classes = new ArrayList<OntClass>();
        classes.add(cls);
        classes.addAll(ModelUtils.getListSuperClasses(cls));
        for (OntClass c : classes) {
            int res = ModelUtils.findMaxCardinality(c, attr);
            if (res == 0) continue;
            return res;
        }
        return 0;
    }

    public static int getMinCardinality(OntClass cls, OntProperty attr) throws IdASException {
        ArrayList<OntClass> classes = new ArrayList<OntClass>();
        classes.add(cls);
        classes.addAll(ModelUtils.getListSuperClasses(cls));
        for (OntClass c : classes) {
            int res = ModelUtils.findMinCardinality(c, attr);
            if (res == 0) continue;
            return res;
        }
        return 0;
    }

    private static int findMaxCardinality(OntClass cls, OntProperty attr) throws IdASException {
        ExtendedIterator itr = cls.listSuperClasses();
        while (itr.hasNext()) {
            Restriction r;
            OntClass c = (OntClass)itr.next();
            if (!c.isRestriction() || !(r = c.asRestriction()).onProperty((Property)attr)) continue;
            if (r.isCardinalityRestriction()) {
                CardinalityRestriction cr = r.asCardinalityRestriction();
                return cr.getCardinality();
            }
            if (!r.isMaxCardinalityRestriction()) continue;
            MaxCardinalityRestriction cr = r.asMaxCardinalityRestriction();
            return cr.getMaxCardinality();
        }
        return 0;
    }

    private static int findMinCardinality(OntClass cls, OntProperty attr) throws IdASException {
        ExtendedIterator itr = cls.listSuperClasses(true);
        while (itr.hasNext()) {
            Restriction r;
            OntClass c = (OntClass)itr.next();
            if (!c.isRestriction() || !(r = c.asRestriction()).onProperty((Property)attr)) continue;
            if (r.isCardinalityRestriction()) {
                CardinalityRestriction cr = r.asCardinalityRestriction();
                return cr.getCardinality();
            }
            if (!r.isMinCardinalityRestriction()) continue;
            MinCardinalityRestriction cr = r.asMinCardinalityRestriction();
            return cr.getMinCardinality();
        }
        return 0;
    }

    public static boolean isFunctionalProperty(OntModel model, String attributeType) throws IdASException {
        ObjectProperty op = model.getObjectProperty(attributeType);
        return op != null && op.isFunctionalProperty();
    }

    public static String getModelShortName(OntModel model, OntResource res) {
        String ns = res.getNameSpace();
        String prf = model.getNsURIPrefix(ns);
        String loc = res.getLocalName();
        String val = (prf + "_" + loc).replaceAll("-", "_");
        return val;
    }

    public static ArrayList getBaseClasses(OntModel md) {
        ArrayList<OntClass> list = new ArrayList<OntClass>();
        String OWL_THING = "http://www.w3.org/2002/07/owl#Thing";
        ExtendedIterator itr = md.listClasses();
        while (itr.hasNext()) {
            OntClass superClass;
            OntClass cls = (OntClass)itr.next();
            if (cls.getURI() == null || (superClass = cls.getSuperClass()) != null && !OWL_THING.equals(superClass.getURI())) continue;
            list.add(cls);
        }
        return list;
    }
}

