/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.idas.cp.model.util;

import java.net.URI;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.higgins.idas.api.IAttribute;
import org.eclipse.higgins.idas.api.IEntity;
import org.eclipse.higgins.idas.api.ISimpleValue;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.api.model.IAttributeModel;
import org.eclipse.higgins.idas.api.model.IEntityModel;

public class Validator {
    public static void validateEntity(IEntity entity) throws IdASException {
        if (!(entity.getModel() instanceof IEntityModel)) {
            throw new IdASException("Can not validate entity of unsupported context.");
        }
        HashMap attrMap = Validator.getAttrributeMap(entity.getAttributes());
        Validator.validateAttributes(entity, attrMap, entity.getModel().getAttributeModels().iterator());
    }

    private static HashMap getAttrributeMap(Iterator attrs) throws IdASException {
        HashMap<URI, IAttribute> map = new HashMap<URI, IAttribute>();
        while (attrs.hasNext()) {
            IAttribute attr = (IAttribute)attrs.next();
            map.put(attr.getType(), attr);
        }
        return map;
    }

    public static void checkCardinality(IEntityModel entity, IAttributeModel attrModel, int realValuesCount) throws IdASException {
        int min = entity.getMinCardinality(attrModel.getType());
        int max = entity.getMaxCardinality(attrModel.getType());
        if (min != 0 && realValuesCount < min) {
            throw new IdASException("Wrong cardinality for attributre " + attrModel.getType().toString() + ". Real values count = " + realValuesCount + " min cardinality = " + min);
        }
        if (max != 0 && realValuesCount > max) {
            throw new IdASException("Wrong cardinality for attributre " + attrModel.getType().toString() + ". Real values count = " + realValuesCount + " max cardinality = " + max);
        }
    }

    public static void validateComplexValue(IEntity val) throws IdASException {
        HashMap attrMap = Validator.getAttrributeMap(val.getAttributes());
        Validator.validateAttributes(val, attrMap, val.getModel().getAttributeModels().iterator());
    }

    public static void validateSimpleValue(ISimpleValue val) throws IdASException {
    }

    public static void validateAttributes(IEntity entity, HashMap attributes, Iterator attributeModels) throws IdASException {
        while (attributeModels.hasNext()) {
            IAttributeModel attrModel = (IAttributeModel)attributeModels.next();
            URI attrType = attrModel.getType();
            int valuesCount = 0;
            IAttribute attr = null;
            if (attributes.containsKey(attrType)) {
                attr = (IAttribute)attributes.get(attrType);
            }
            if (attr != null) {
                Iterator itrVal = attr.getValues();
                while (itrVal.hasNext()) {
                    ++valuesCount;
                    Object objVal = itrVal.next();
                    if (objVal instanceof ISimpleValue) {
                        ISimpleValue sv = (ISimpleValue)objVal;
                        Validator.validateSimpleValue(sv);
                        continue;
                    }
                    if (objVal instanceof IEntity) {
                        IEntity cv = (IEntity)objVal;
                        Validator.validateComplexValue(cv);
                        continue;
                    }
                    throw new IdASException("Instance of " + IAttribute.class.getName() + " expected, " + objVal.getClass().getName() + " found.");
                }
            }
            Validator.checkCardinality(entity.getModel(), attrModel, valuesCount);
        }
    }
}

