/**
 * Copyright (c) 2008 Parity Communications, Inc. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Markus Sabadello - initial API and implementation
 */
package org.eclipse.higgins.idas.cp.rdf;

import java.net.URI;
import java.util.Iterator;

import org.eclipse.higgins.idas.api.IValue;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.cp.rdf.util.MappingIterator;
import org.eclipse.higgins.idas.spi.BasicAttribute;
import org.eclipse.higgins.idas.spi.BasicContext;
import org.eclipse.higgins.idas.spi.BasicValueString;

import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.vocabulary.RDF;

public class RDFAttribute extends BasicAttribute {

	private Model model;
	private BasicContext containerCtx;
	private Resource resource;
	private Property property;

	RDFAttribute(Model model, BasicContext containerCtx, Resource resource, Property property) throws IdASException {

		super(URI.create(property.getURI()), (IValue) null, null, null);

		this.model = model;
		this.containerCtx = containerCtx;
		this.resource = resource;
		this.property = property;
	}

	public Iterator getValues() throws IdASException {

		return(new MappingIterator(this.resource.listProperties(this.property)) {

			public Object map(Object item) {

				Statement statement = (Statement) item;
				RDFNode object = statement.getObject();

				try {

					if (object.isLiteral()) {

						return(new BasicValueString(((Literal) object).getString(), RDFAttribute.this));
					} else if (object.isResource() && object.isURIResource()) {

						Resource resource = RDFAttribute.this.model.getResource(((Resource) object).getURI());

						if (resource != null) {

							String type = null;
							if (resource.hasProperty(RDF.type)) type = ((Resource) resource.listProperties(RDF.type).nextStatement().getObject()).getURI();
	
							return(new RDFEntity(RDFAttribute.this.containerCtx, type != null ? URI.create(type) : null, RDFAttribute.this.model, resource));
						} else {

							return(new RDFProxyEntity(RDFAttribute.this.containerCtx, ((Resource) object).getURI()));
						}
					} else if (object.isResource() && object.isAnon()) {

						String type = null;
						if (((Resource) object).hasProperty(RDF.type)) type = ((Resource) ((Resource) object).listProperties(RDF.type).nextStatement().getObject()).getURI();

						return(new RDFEntity(RDFAttribute.this.containerCtx, type != null ? URI.create(type) : null, RDFAttribute.this.model, resource));
					} else {

						return(null);
					}
				} catch (IdASException ex) {

					return(null);
				}
			} 
		});
	}
}
